/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.util.Comparator;

import javax.swing.tree.DefaultMutableTreeNode;

import de.renier.vdr.channel.Channel;
import de.renier.vdr.channel.editor.Messages;

/**
 * SortTypeAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class SortTypeAction extends AbstractSortAction {

  private static final long serialVersionUID = -3978322480855409715L;
  public final static int SORT_TYPE_TV = 0;
  public final static int SORT_TYPE_TVCRYPT = 1;
  public final static int SORT_TYPE_RADIO = 2;
  public final static int SORT_TYPE_RADIOCRYPT = 3;
  public final static int SORT_TYPE_SERVICE = 4;
  public final static int SORT_TYPE_SERVICECRYPT = 5;

  private int sortType = 0;

  public SortTypeAction(int type) {
    super(getTypeText(type));
    this.sortType = type;
  }

  private static String getTypeText(int type) {
    String text = null;
    switch (type) {
    case SORT_TYPE_TV:
      text = Messages.getString("SortTypeAction.0"); //$NON-NLS-1$
      break;
    case SORT_TYPE_TVCRYPT:
      text = Messages.getString("SortTypeAction.1"); //$NON-NLS-1$
      break;
    case SORT_TYPE_RADIO:
      text = Messages.getString("SortTypeAction.2"); //$NON-NLS-1$
      break;
    case SORT_TYPE_RADIOCRYPT:
      text = Messages.getString("SortTypeAction.3"); //$NON-NLS-1$
      break;
    case SORT_TYPE_SERVICE:
      text = Messages.getString("SortTypeAction.4"); //$NON-NLS-1$
      break;
    case SORT_TYPE_SERVICECRYPT:
      text = Messages.getString("SortTypeAction.5"); //$NON-NLS-1$
      break;
    default:
      text = Messages.getString("SortTypeAction.6"); //$NON-NLS-1$
    }
    return text;
  }

  private static Integer cassifyChannel(int type, Channel channel) {
    int ret = 0;
    switch (type) {
    case SORT_TYPE_TV:
      if (channel.isTelevision()) {
        ret += 500;
        if (!"0".equals(channel.getCaId())) { //$NON-NLS-1$
          ret += 10;
        }
      } else {
        ret += 1000;
      }
      break;
    case SORT_TYPE_TVCRYPT:
      if (channel.isTelevision()) {
        ret += 500;
        if ("0".equals(channel.getCaId())) { //$NON-NLS-1$
          ret += 10;
        }
      } else {
        ret += 1000;
      }
      break;
    case SORT_TYPE_RADIO:
      if (channel.isRadio()) {
        ret += 500;
        if (!"0".equals(channel.getCaId())) { //$NON-NLS-1$
          ret += 10;
        }
      } else {
        ret += 1000;
      }
      break;
    case SORT_TYPE_RADIOCRYPT:
      if (channel.isRadio()) {
        ret += 500;
        if ("0".equals(channel.getCaId())) { //$NON-NLS-1$
          ret += 10;
        }
      } else {
        ret += 1000;
      }
      break;
    case SORT_TYPE_SERVICE:
      if (channel.isService()) {
        ret += 500;
        if (!"0".equals(channel.getCaId())) { //$NON-NLS-1$
          ret += 10;
        }
      } else {
        ret += 1000;
      }
      break;
    case SORT_TYPE_SERVICECRYPT:
      if (channel.isService()) {
        ret += 500;
        if ("0".equals(channel.getCaId())) { //$NON-NLS-1$
          ret += 10;
        }
      } else {
        ret += 1000;
      }
      break;
    default:
      ret += 10000;
    }
    return new Integer(ret);
  }

  protected Comparator createSortComparator() {
    return new Comparator() {

      public int compare(Object o1, Object o2) {
        // only channels
        if (((DefaultMutableTreeNode) o1).getUserObject() instanceof Channel
            && ((DefaultMutableTreeNode) o2).getUserObject() instanceof Channel) {
          Channel element1 = (Channel) ((DefaultMutableTreeNode) o1).getUserObject();
          Channel element2 = (Channel) ((DefaultMutableTreeNode) o2).getUserObject();
          return cassifyChannel(sortType, element1).compareTo(cassifyChannel(sortType, element2));
        }
        return 0;
      }
    };
  }

}
