/************************************************************/
/*                                                          */
/* Module ID  - actmain.c                                   */
/*                                                          */
/* Function   - Allow caller to cut CP accounting records.  */
/*                                                          */
/* Called By  - N/A.                                        */
/*                                                          */
/* Calling To - N/A.                                        */
/*                                                          */
/* Parameters - See individual entry points.                */
/*                                                          */
/* Notes      - (1) Code published under GPL. Copyright     */
/*                  Neale Ferguson, Software AG.            */
/*                                                          */
/*                                                          */
/* Name       - Neale Ferguson.                             */
/*                                                          */
/* Date       - April, 2003.                                */
/*                                                          */
/*                                                          */
/* Associated    - (1) Refer To ........................... */
/* Documentation                                            */
/*                 (2) Refer To ........................... */
/*                                                          */
/************************************************************/

/************************************************************/
/*                                                          */
/*                     DEFINES                              */
/*                     -------                              */
/*                                                          */
/************************************************************/

#ifndef __KERNEL__
#  define __KERNEL__
#endif
#ifndef MODULE
#  define MODULE
#endif

#define __NO_VERSION__		/* don't define kernel_verion in module.h */

/*=============== End of Defines ===========================*/

/************************************************************/
/*                                                          */
/*              INCLUDE STATEMENTS                          */
/*              ------------------                          */
/*                                                          */
/************************************************************/

#include <linux/module.h>
#include <linux/version.h>

#include <linux/kernel.h>	/* printk() */
#include <linux/slab.h>		/* kmalloc() */
#include <linux/fs.h>		/* everything... */
#include <linux/errno.h>	/* error codes */
#include <linux/types.h>	/* size_t */
#include <linux/proc_fs.h>
#include <linux/fcntl.h>	/* O_ACCMODE */

#include <asm/system.h>		/* cli(), *_flags */
#include <asm/segment.h>	/* memcpy and such */
#include <asm/ebcdic.h>		/* ebcdic stuff */
#include <asm/uaccess.h>	/* copy to/from user space */

#include "cpint.h"		/* Common definitions */

/*================== End of Include Statements =============*/

/************************************************************/
/*                                                          */
/*              TYPE DEFINITIONS                            */
/*              ----------------                            */
/*                                                          */
/************************************************************/

/*================== End of Type Definitions ===============*/

/************************************************************/
/*                                                          */
/*             FUNCTION PROTOTYPES                          */
/*             -------------------                          */
/*                                                          */
/************************************************************/

/*================== End of Prototypes =====================*/

/************************************************************/
/*                                                          */
/*           GLOBAL VARIABLE DECLARATIONS                   */
/*           ----------------------------                   */
/*                                                          */
/************************************************************/

/*============== End of Variable Declarations ==============*/

/************************************************************/
/*                                                          */
/* Name       - account_open.                               */
/*                                                          */
/* Function   - Open the CP command device.                 */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*                                                          */
/************************************************************/

int
account_open(struct inode *inode, struct file *filp)
{

	return (0);
}

/*===================== End of Function ====================*/

/************************************************************/
/*                                                          */
/* Name       - account_write.                              */
/*                                                          */
/* Function   - Write a CP accounting record.               */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*              buf   - Pointer to read buffer.             */
/*              count - Size of read buffer.                */
/*                                                          */
/************************************************************/

ssize_t
account_write(struct file * filp, const char *buf, size_t count, loff_t * ppos)
{
	char acctData[70];
	int rc, lAcctData;

	lAcctData = (count <= sizeof (acctData) ? count : sizeof (acctData));
	if (lAcctData <= 0)
		return -EMSGSIZE;

	copy_from_user(acctData, buf, lAcctData);

#ifdef __s390x__
      __asm__("\tLRAG\t1,%1	  /* Get A(Record)     */\n" "\tLHI\t2,0x0010     /* Get function code */\n" "\tLGF\t3,%2         /* Get L'record      */\n" "\t.long\t0x8312004c /* Cut the record    */\n" "\tIPM\t%0           /* Capture the RC    */\n" "\tSRL\t%0,28        /* Shuffle down      */\n":"=d"(rc)
      :	"m"(*acctData), "m"(lAcctData)
      :	"cc", "1", "2", "3");
#else
      __asm__("\tLRA\t1,%1         /* Get A(Record)     */\n" "\tLHI\t2,0x0010     /* Get function code */\n" "\tL\t3,%2           /* Get L'record      */\n" "\t.long\t0x8312004c /* Cut the record    */\n" "\tIPM\t%0           /* Capture the RC    */\n" "\tSRL\t%0,28        /* Shuffle down      */\n":"=d"(rc)
      :	"m"(*acctData), "m"(lAcctData)
      :	"cc", "1", "2", "3");
#endif
	if (rc != 0)
		return -EINVAL;

	return (lAcctData);
}

/*============== End of Variable Declarations ==============*/

/************************************************************/
/*                                                          */
/* Name       - account_release.                            */
/*                                                          */
/* Function   - Close the CP account device.                */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*                                                          */
/************************************************************/

int
account_release(struct inode *inode, struct file *filp)
{

	return (0);
}

/*===================== End of Function ====================*/
