/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.jox.JOXDateHandler;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JOXBeanInput {
    protected static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected static Hashtable beanCache = new Hashtable();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    JOXBeanInput() {
    }

    public void readObject(Object object, InputSource inputSource) throws IOException {
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            Element element = document.getDocumentElement();
            this.readObject(object, element);
        }
        catch (SAXException sAXException) {
            throw new IOException("Error parsing XML document: " + sAXException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Error parsing XML document: " + parserConfigurationException.toString());
        }
    }

    public void readObject(Object object, Element element) throws IOException {
        if (object == null) {
            return;
        }
        try {
            BeanInfo beanInfo = (BeanInfo)beanCache.get(object.getClass());
            if (beanInfo == null) {
                beanInfo = Introspector.getBeanInfo(object.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = JOXBeanInput.class$("java.lang.Object")) : class$java$lang$Object);
                beanCache.put(object.getClass(), beanInfo);
            }
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            NamedNodeMap namedNodeMap = element.getAttributes();
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n2] instanceof IndexedPropertyDescriptor) {
                    this.readIndexedProperty(object, (IndexedPropertyDescriptor)propertyDescriptorArray[n2], nodeList, namedNodeMap);
                } else {
                    this.readProperty(object, propertyDescriptorArray[n2], nodeList, namedNodeMap);
                }
                ++n2;
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new IOException("Error getting bean info for " + object.getClass().getName() + ": " + introspectionException.toString());
        }
    }

    public void readProperty(Object object, PropertyDescriptor propertyDescriptor, NodeList nodeList, NamedNodeMap namedNodeMap) throws IOException {
        Object[] objectArray;
        Object object2;
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Method method;
            if (JOXBeanInput.namesMatch(propertyDescriptor.getName(), namedNodeMap.item(n2).getNodeName()) && (method = propertyDescriptor.getWriteMethod()) != null) {
                Object object3 = this.getObjectValue(propertyDescriptor, namedNodeMap.item(n2).getNodeValue());
                if (object3 != null) {
                    try {
                        method.invoke(object, object3);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IOException("Error setting property " + propertyDescriptor.getName() + ": " + invocationTargetException.toString());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IOException("Error setting property " + propertyDescriptor.getName() + ": " + illegalAccessException.toString());
                    }
                }
                return;
            }
            ++n2;
        }
        int n3 = nodeList.getLength();
        Vector<Object> vector = null;
        int n4 = 0;
        while (n4 < n3) {
            object2 = nodeList.item(n4);
            if (object2 instanceof Element) {
                Method method;
                objectArray = (Object[])object2;
                if (JOXBeanInput.namesMatch(propertyDescriptor.getName(), objectArray.getTagName()) && (method = propertyDescriptor.getWriteMethod()) != null) {
                    Object object4 = this.getObjectValue(propertyDescriptor, (Element)objectArray);
                    if (method.getParameterTypes()[0].isArray()) {
                        if (vector == null) {
                            vector = new Vector<Object>();
                        }
                        vector.addElement(object4);
                    } else {
                        if (object4 != null) {
                            try {
                                method.invoke(object, object4);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw new IOException("Error setting property " + propertyDescriptor.getName() + ": " + invocationTargetException.toString());
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw new IOException("Error setting property " + propertyDescriptor.getName() + ": " + illegalAccessException.toString());
                            }
                        }
                        return;
                    }
                }
            }
            ++n4;
        }
        if (vector != null) {
            object2 = propertyDescriptor.getWriteMethod();
            if (object2 == null) {
                return;
            }
            objectArray = (Object[])Array.newInstance(propertyDescriptor.getPropertyType(), vector.size());
            vector.copyInto(objectArray);
            try {
                ((Method)object2).invoke(object, new Object[]{objectArray});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException("Error setting property " + propertyDescriptor.getName() + ": " + invocationTargetException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Error setting property " + propertyDescriptor.getName() + ": " + illegalAccessException.toString());
            }
            return;
        }
    }

    public void readIndexedProperty(Object object, IndexedPropertyDescriptor indexedPropertyDescriptor, NodeList nodeList, NamedNodeMap namedNodeMap) throws IOException {
        Object object2;
        Object object3;
        Vector<Object> vector = new Vector<Object>();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Object object4;
            if (JOXBeanInput.namesMatch(indexedPropertyDescriptor.getName(), namedNodeMap.item(n2).getNodeName()) && (object4 = this.getObjectValue((PropertyDescriptor)indexedPropertyDescriptor, namedNodeMap.item(n2).getNodeValue())) != null) {
                vector.addElement(object4);
            }
            ++n2;
        }
        int n3 = nodeList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            object3 = nodeList.item(n4);
            if (object3 instanceof Element) {
                Object object5;
                object2 = (Element)object3;
                if (JOXBeanInput.namesMatch(indexedPropertyDescriptor.getName(), object2.getTagName()) && (object5 = this.getObjectValue((PropertyDescriptor)indexedPropertyDescriptor, (Element)object2)) != null) {
                    vector.addElement(object5);
                }
            }
            ++n4;
        }
        object3 = indexedPropertyDescriptor.getWriteMethod();
        if (object3 == null) {
            return;
        }
        object2 = Array.newInstance(indexedPropertyDescriptor.getPropertyType().getComponentType(), vector.size());
        vector.copyInto((Object[])object2);
        try {
            ((Method)object3).invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Error setting property " + indexedPropertyDescriptor.getName() + ": " + invocationTargetException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Error setting property " + indexedPropertyDescriptor.getName() + ": " + illegalAccessException.toString());
        }
    }

    public Object getObjectValue(PropertyDescriptor propertyDescriptor, Element element) throws IOException {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE) || clazz.equals(Boolean.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanInput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanInput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanInput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanInput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanInput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanInput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanInput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz) || (class$java$lang$String == null ? (class$java$lang$String = JOXBeanInput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            return JOXBeanInput.readBasicType(clazz, element);
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = JOXBeanInput.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz)) {
            return this.readDate(element);
        }
        try {
            Object obj = clazz.newInstance();
            this.readObject(obj, element);
            return obj;
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Error creating object for " + propertyDescriptor.getName() + ": " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Error creating object for " + propertyDescriptor.getName() + ": " + illegalAccessException.toString());
        }
    }

    public Object getObjectValue(PropertyDescriptor propertyDescriptor, String string) throws IOException {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE) || clazz.equals(Boolean.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanInput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanInput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanInput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanInput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanInput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanInput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanInput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz)) {
            return JOXBeanInput.parseBasicType(clazz, string);
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = JOXBeanInput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            return string;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = JOXBeanInput.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz)) {
            return this.parseDate(string, JOXDateHandler.determineDateFormat());
        }
        return null;
    }

    public static Object readBasicType(Class clazz, Element element) {
        String string = JOXBeanInput.getElementString(element);
        if (string == null) {
            return null;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = JOXBeanInput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            return string;
        }
        return JOXBeanInput.parseBasicType(clazz, string);
    }

    public static Object parseBasicType(Class clazz, String string) {
        if (clazz.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanInput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz)) {
            return new Integer(string);
        }
        if (clazz.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanInput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz)) {
            return new Long(string);
        }
        if (clazz.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanInput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz)) {
            return new Short(string);
        }
        if (clazz.equals(Byte.TYPE) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanInput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz)) {
            return new Byte(string);
        }
        if (clazz.equals(Boolean.TYPE) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanInput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
            return new Boolean(string);
        }
        if (clazz.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanInput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz)) {
            return new Float(string);
        }
        if (clazz.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanInput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz)) {
            return new Double(string);
        }
        return null;
    }

    public Object readDate(Element element) throws IOException {
        String string = JOXBeanInput.getElementString(element);
        String string2 = element.getAttribute("format");
        if ("".equals(string2)) {
            return this.parseDate(string, JOXDateHandler.determineDateFormat());
        }
        return this.parseDate(string, new SimpleDateFormat(string2));
    }

    public Object parseDate(String string, DateFormat dateFormat) throws IOException {
        if (string == null) {
            return null;
        }
        try {
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IOException("Error parsing date " + string);
        }
    }

    public static String getElementString(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Text) {
                return ((Text)node).getData();
            }
            ++n2;
        }
        return null;
    }

    public static boolean namesMatch(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2 && n4 < n) {
            char c = Character.toLowerCase(string.charAt(n4));
            if (c == '-' || c == '_') {
                ++n4;
                continue;
            }
            char c2 = Character.toLowerCase(string2.charAt(n3));
            if (c2 == '-' || c2 == '_') {
                ++n3;
                continue;
            }
            if (c2 != c) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return n3 == n2 && n4 == n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

