/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.feedback;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.feedback.FeedbackSurveyStateComponent;

@Service(value={Service.Level.APP})
@State(name="FeedbackSurveyState", storages={@Storage(value="full.line.survey.feedback.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0016J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u0016R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00078\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/completion/full/line/feedback/FeedbackSurveyStateComponent;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "languageToSessions", "", "", "", "value", "", "isNotificationShown", "()Z", "sessionsCount", "getSessionsCount", "()I", "acceptedCompletionsCnt", "getAcceptedCompletionsCnt", "mostPopularLanguage", "getMostPopularLanguage", "()Ljava/lang/String;", "getState", "loadState", "", "state", "fireCompletionShown", "language", "Lcom/intellij/lang/Language;", "fireCompletionAccepted", "fireNotificationShown", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nExplicitFeedback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplicitFeedback.kt\norg/jetbrains/completion/full/line/feedback/FeedbackSurveyStateComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class FeedbackSurveyStateComponent
implements PersistentStateComponent<FeedbackSurveyStateComponent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Property
    @XMap(keyAttributeName="language", valueAttributeName="sessions-count")
    @NotNull
    private final Map<String, Integer> languageToSessions = new LinkedHashMap();
    @Property
    private boolean isNotificationShown;
    @Property
    private int acceptedCompletionsCnt;

    public final boolean isNotificationShown() {
        return this.isNotificationShown;
    }

    public final int getSessionsCount() {
        return CollectionsKt.sumOfInt((Iterable)this.languageToSessions.values());
    }

    public final int getAcceptedCompletionsCnt() {
        return this.acceptedCompletionsCnt;
    }

    @Nullable
    public final String getMostPopularLanguage() {
        Map.Entry mostPopular;
        Object v0;
        Iterable iterable = this.languageToSessions.entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-FeedbackSurveyStateComponent$mostPopularLanguage$mostPopular$1 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator2.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = mostPopular = (Map.Entry)v0;
        return entry != null ? (String)entry.getKey() : null;
    }

    @NotNull
    public FeedbackSurveyStateComponent getState() {
        return this;
    }

    public void loadState(@NotNull FeedbackSurveyStateComponent state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public final void fireCompletionShown(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.languageToSessions.merge(language.getID(), 1, (arg_0, arg_1) -> FeedbackSurveyStateComponent.fireCompletionShown$lambda$1(fireCompletionShown.1.INSTANCE, arg_0, arg_1));
    }

    public final void fireCompletionAccepted() {
        int n = this.acceptedCompletionsCnt;
        this.acceptedCompletionsCnt = n + 1;
    }

    public final void fireNotificationShown() {
        if (!(!this.isNotificationShown)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.isNotificationShown = true;
    }

    private static final Integer fireCompletionShown$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/completion/full/line/feedback/FeedbackSurveyStateComponent$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/completion/full/line/feedback/FeedbackSurveyStateComponent;", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nExplicitFeedback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplicitFeedback.kt\norg/jetbrains/completion/full/line/feedback/FeedbackSurveyStateComponent$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,57:1\n40#2,3:58\n*S KotlinDebug\n*F\n+ 1 ExplicitFeedback.kt\norg/jetbrains/completion/full/line/feedback/FeedbackSurveyStateComponent$Companion\n*L\n54#1:58,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FeedbackSurveyStateComponent getInstance() {
            boolean $i$f$service = false;
            Class<FeedbackSurveyStateComponent> serviceClass$iv = FeedbackSurveyStateComponent.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (FeedbackSurveyStateComponent)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

