/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FrankensteinErrorFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    FrankensteinErrorFilter() {
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            FrankensteinErrorFilter.$$$reportNull$$$0(0);
        }
        return !FrankensteinErrorFilter.isFrankenstein(element.getContainingFile());
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        if (highlightInfo == null) {
            FrankensteinErrorFilter.$$$reportNull$$$0(1);
        }
        if (highlightInfo.getSeverity() != HighlightSeverity.WARNING && highlightInfo.getSeverity() != HighlightSeverity.WEAK_WARNING) {
            return true;
        }
        if (!FrankensteinErrorFilter.isFrankenstein(file)) {
            return true;
        }
        int start = highlightInfo.getStartOffset();
        int end = highlightInfo.getEndOffset();
        String text = file.getText().substring(start, end);
        return !"missingValue".equals(text);
    }

    private static boolean isFrankenstein(@Nullable PsiFile file) {
        return file != null && Boolean.TRUE.equals(file.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/intelliLang/inject/FrankensteinErrorFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

