/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import com.jetbrains.python.packaging.PyPackageInstallUtilsKt;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyPackagesUsageCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\f0\u0006\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/inspections/quickfix/InstallAllPackagesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "packageNames", "", "", "getPackageNames", "()Ljava/util/List;", "setPackageNames", "(Ljava/util/List;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "startInWriteAction", "", "availableInBatchMode", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nInstallAllPackagesQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallAllPackagesQuickFix.kt\ncom/jetbrains/python/inspections/quickfix/InstallAllPackagesQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1557#2:48\n1628#2,3:49\n*S KotlinDebug\n*F\n+ 1 InstallAllPackagesQuickFix.kt\ncom/jetbrains/python/inspections/quickfix/InstallAllPackagesQuickFix\n*L\n30#1:48\n30#1:49,3\n*E\n"})
public final class InstallAllPackagesQuickFix
implements LocalQuickFix {
    @NotNull
    private List<String> packageNames = CollectionsKt.emptyList();

    @NotNull
    public final List<String> getPackageNames() {
        return this.packageNames;
    }

    public final void setPackageNames(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.packageNames = list;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        Module module2 = module;
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(element);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        List<String> confirmedPackages = PyPackageInstallUtilsKt.getConfirmedPackages(this.packageNames);
        if (confirmedPackages.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = confirmedPackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PyRequirementsKt.pyRequirement((String)it));
        }
        List requirements = (List)destination$iv$iv;
        PyPackageRequirementsInspection.PyInstallRequirementsFix fix = new PyPackageRequirementsInspection.PyInstallRequirementsFix(this.getFamilyName(), module2, sdk3, requirements, CollectionsKt.emptyList(), new PyPackageRequirementsInspection.RunningPackagingTasksListener(module2));
        fix.applyFix(module2.getProject(), descriptor2);
        PyPackagesUsageCollector.Companion.getInstallAllEvent().log((Object)requirements.size());
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("python.unresolved.reference.inspection.install.all", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean availableInBatchMode() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

