/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.sdk.PythonSdkUtilKtKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B1\u0012\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0007J\u0012\u0010\u000f\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u00110\u0010H\u0007J\f\u0010\u0012\u001a\u00060\rj\u0002`\u000eH\u0007J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u00110\u0010H\u0007J\u001e\u0010\u0014\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u00110\u00102\n\u0010\u0015\u001a\u00060\rj\u0002`\u000eH\u0007J\u0012\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\rH\u0007J\f\u0010\u0018\u001a\u00060\rj\u0002`\u000eH\u0003J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\rH\u0003J\u001c\u0010\u001a\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u00112\n\u0010\u001b\u001a\u00060\rj\u0002`\u000eH\u0007J\u0018\u0010\u001c\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u00112\u0006\u0010\u001b\u001a\u00020\rH\u0003J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0003R$\u0010\u0002\u001a\u0018\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/sdk/VirtualEnvReader;", "", "envs", "", "", "Lorg/jetbrains/annotations/NonNls;", "isWindows", "", "<init>", "(Ljava/util/Map;Z)V", "pythonNames", "", "getVEnvRootDir", "Ljava/nio/file/Path;", "Lcom/jetbrains/python/sdk/Directory;", "findVEnvInterpreters", "", "Lcom/jetbrains/python/sdk/PythonBinary;", "getPyenvRootDir", "findPyenvInterpreters", "findLocalInterpreters", "root", "isPyenvSdk", "path", "getPyenvVersionsDir", "tryReadLink", "findPythonInPythonRoot", "dir", "findInterpreter", "resolveDirFromEnvOrElseGetDirInHomePath", "env", "dirName", "Companion", "intellij.python.psi.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVirtualEnvReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualEnvReader.kt\ncom/jetbrains/python/sdk/VirtualEnvReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1#2:151\n295#3,2:152\n*S KotlinDebug\n*F\n+ 1 VirtualEnvReader.kt\ncom/jetbrains/python/sdk/VirtualEnvReader\n*L\n128#1:152,2\n*E\n"})
public final class VirtualEnvReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> envs;
    @NotNull
    private final Set<String> pythonNames;
    @NotNull
    private static final VirtualEnvReader Instance = new VirtualEnvReader(null, false, 3, null);
    @NotNull
    public static final String DEFAULT_VIRTUALENVS_DIR = ".virtualenvs";
    @NotNull
    public static final String DEFAULT_VIRTUALENV_DIRNAME = ".venv";

    public VirtualEnvReader(@NotNull Map<String, String> envs, boolean isWindows) {
        Set set;
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        this.envs = envs;
        if (isWindows) {
            Object[] objectArray = new String[]{"pypy.exe", "python.exe"};
            set = SetsKt.setOf((Object[])objectArray);
        } else {
            Object[] objectArray = new String[]{"pypy", "python"};
            set = SetsKt.setOf((Object[])objectArray);
        }
        this.pythonNames = set;
    }

    public /* synthetic */ VirtualEnvReader(Map map2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = System.getenv();
        }
        if ((n & 2) != 0) {
            bl = SystemInfoRt.isWindows;
        }
        this(map2, bl);
    }

    @RequiresBackgroundThread
    @NotNull
    public final Path getVEnvRootDir() {
        return this.resolveDirFromEnvOrElseGetDirInHomePath("WORKON_HOME", DEFAULT_VIRTUALENVS_DIR);
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<Path> findVEnvInterpreters() {
        return this.findLocalInterpreters(this.getVEnvRootDir());
    }

    @RequiresBackgroundThread
    @NotNull
    public final Path getPyenvRootDir() {
        return this.resolveDirFromEnvOrElseGetDirInHomePath("PYENV_ROOT", ".pyenv");
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<Path> findPyenvInterpreters() {
        return this.findLocalInterpreters(this.getPyenvVersionsDir());
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<Path> findLocalInterpreters(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Path> candidates = new ArrayList<Path>();
        for (Path dir : PathsKt.listDirectoryEntries$default((Path)root, null, (int)1, null)) {
            Path it;
            if (this.findPythonInPythonRoot(dir) == null) continue;
            boolean bl = false;
            candidates.add(it);
        }
        return candidates;
    }

    @RequiresBackgroundThread
    public final boolean isPyenvSdk(@Nullable String path2) {
        CharSequence charSequence = path2;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        Path path3 = PythonSdkUtilKtKt.tryResolvePath(path2);
        if (path3 == null) {
            return false;
        }
        Path path4 = path3;
        return this.isPyenvSdk(path4);
    }

    @RequiresBackgroundThread
    public final boolean isPyenvSdk(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path path3 = this.tryReadLink(path2);
        if (path3 == null) {
            return false;
        }
        Path real = path3;
        return real.startsWith(NioPathUtil.toCanonicalPath((Path)this.getPyenvRootDir()));
    }

    @RequiresBackgroundThread
    private final Path getPyenvVersionsDir() {
        Path path2 = this.getPyenvRootDir().resolve("versions");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @RequiresBackgroundThread
    private final Path tryReadLink(Path path2) {
        try {
            return Files.isSymbolicLink(path2) ? path2.toRealPath(new LinkOption[0]) : path2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @RequiresBackgroundThread
    @Nullable
    public final Path findPythonInPythonRoot(@NotNull Path dir) {
        Path path2;
        Path path3;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path bin = dir.resolve("bin");
        Intrinsics.checkNotNull((Object)bin);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isDirectory(bin, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && (path3 = this.findInterpreter(bin)) != null) {
            Path it = path3;
            boolean bl = false;
            return it;
        }
        Path scripts = dir.resolve("Scripts");
        Intrinsics.checkNotNull((Object)scripts);
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (Files.isDirectory(scripts, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) && (path2 = this.findInterpreter(scripts)) != null) {
            Path it = path2;
            boolean bl = false;
            return it;
        }
        return this.findInterpreter(dir);
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresBackgroundThread
    private final Path findInterpreter(Path dir) {
        Object element$iv;
        Object v0;
        boolean bl;
        Iterable $this$firstOrNull$iv = PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null);
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            Path it = (Path)element$iv;
            boolean bl2 = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                String string = PathsKt.getName((Path)it).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (this.pythonNames.contains(string)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    @RequiresBackgroundThread
    private final Path resolveDirFromEnvOrElseGetDirInHomePath(String env, String dirName) {
        Object object;
        block3: {
            block2: {
                object = this.envs.get(env);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Path path2 = PythonSdkUtilKtKt.tryResolvePath(it);
                object = path2;
                if (path2 != null) break block3;
            }
            String[] stringArray = new String[]{dirName};
            Path path3 = Path.of(SystemProperties.getUserHome(), stringArray);
            object = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
        }
        return object;
    }

    public VirtualEnvReader() {
        this(null, false, 3, null);
    }

    @NotNull
    public static final VirtualEnvReader getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/VirtualEnvReader$Companion;", "", "<init>", "()V", "Instance", "Lcom/jetbrains/python/sdk/VirtualEnvReader;", "getInstance$annotations", "getInstance", "()Lcom/jetbrains/python/sdk/VirtualEnvReader;", "DEFAULT_VIRTUALENVS_DIR", "", "DEFAULT_VIRTUALENV_DIRNAME", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VirtualEnvReader getInstance() {
            return Instance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

