/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.suggestions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.stubs.PyFromImportStatementStub;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.suggestions.PycharmProSuggestionProviderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/suggestions/PycharmProSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "<init>", "()V", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findPackageSupportedByPro", "", "psiFile", "Lcom/jetbrains/python/psi/PyFile;", "isUntargetedIDE", "", "isDismissed", "isPythonFile", "PycharmProSuggestion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPycharmProSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PycharmProSuggestionProvider.kt\ncom/jetbrains/python/suggestions/PycharmProSuggestionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1611#2,9:106\n1863#2:115\n1864#2:117\n1620#2:118\n1611#2,9:119\n1863#2:128\n1864#2:130\n1620#2:131\n1#3:116\n1#3:129\n*S KotlinDebug\n*F\n+ 1 PycharmProSuggestionProvider.kt\ncom/jetbrains/python/suggestions/PycharmProSuggestionProvider\n*L\n61#1:106,9\n61#1:115\n61#1:117\n61#1:118\n62#1:119,9\n62#1:128\n62#1:130\n62#1:131\n61#1:116\n62#1:129\n*E\n"})
public final class PycharmProSuggestionProvider
implements PluginSuggestionProvider {
    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        if (!this.isPythonFile(vFile) || this.isDismissed() || PluginAdvertiserServiceKt.tryUltimateIsDisabled() || this.isUntargetedIDE() || FileIndexFacade.getInstance((Project)project).isInLibraryClasses(vFile)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
        if (psiFile == null || psiFile instanceof PyiFile || !(psiFile instanceof PyFile)) {
            return null;
        }
        if (PyCellUtil.hasCells(psiFile)) {
            String string = PyBundle.message("advertiser.code.cells.supported.by.pro", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new PycharmProSuggestion(string, project, null, 4, null);
        }
        String supportedPackage = this.findPackageSupportedByPro((PyFile)psiFile);
        if (supportedPackage != null) {
            Object[] objectArray = new Object[]{supportedPackage};
            String string = PyBundle.message("advertiser.package.supported.by.pro", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new PycharmProSuggestion(string, project, null, 4, null);
        }
        return null;
    }

    private final String findPackageSupportedByPro(PyFile psiFile) {
        boolean bl;
        String it$iv$iv;
        StubBasedPsiElement<PyFromImportStatementStub> it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List<PyFromImportStatement> list = psiFile.getFromImports();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFromImports(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (PyFromImportStatement)element$iv$iv;
            boolean bl3 = false;
            QualifiedName qualifiedName = it.getImportSourceQName();
            if ((qualifiedName != null ? qualifiedName.getFirstComponent() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<PyImportElement> list2 = psiFile.getImportTargets();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getImportTargets(...)");
        $this$mapNotNull$iv = list2;
        Set set2 = set;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (PyImportElement)element$iv$iv;
            boolean bl4 = false;
            QualifiedName qualifiedName = it.getImportedQName();
            if ((qualifiedName != null ? qualifiedName.getFirstComponent() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set imports = SetsKt.plus((Set)set2, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        return (String)CollectionsKt.firstOrNull((Iterable)CollectionsKt.intersect((Iterable)PycharmProSuggestionProviderKt.access$getPACKAGES_TO_ADVERTISE$p(), (Iterable)imports));
    }

    private final boolean isUntargetedIDE() {
        String string = ApplicationInfoImpl.getShadowInstanceImpl().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String productCode = string;
        return Intrinsics.areEqual((Object)productCode, (Object)"PY") || Intrinsics.areEqual((Object)productCode, (Object)"IU") || Intrinsics.areEqual((Object)productCode, (Object)"DS");
    }

    private final boolean isDismissed() {
        return PropertiesComponent.getInstance().isTrueValue("pycharm.pro.suggestion.dismissed");
    }

    private final boolean isPythonFile(VirtualFile $this$isPythonFile) {
        return Intrinsics.areEqual((Object)$this$isPythonFile.getFileType(), (Object)PythonFileType.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B)\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0001\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/suggestions/PycharmProSuggestionProvider$PycharmProSuggestion;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "label", "", "project", "Lcom/intellij/openapi/project/Project;", "pluginIds", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getPluginIds", "()Ljava/util/List;", "apply", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "setupCommercialIdeSuggestion", "", "panel", "dismissSuggestion", "intellij.python.community.impl"})
    private static final class PycharmProSuggestion
    implements PluginSuggestion {
        @NotNull
        private final String label;
        @NotNull
        private final Project project;
        @NotNull
        private final List<String> pluginIds;

        public PycharmProSuggestion(@Nls @NotNull String label, @NotNull Project project, @NotNull List<String> pluginIds) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            this.label = label;
            this.project = project;
            this.pluginIds = pluginIds;
        }

        public /* synthetic */ PycharmProSuggestion(String string, Project project, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, project, list);
        }

        @NotNull
        public List<String> getPluginIds() {
            return this.pluginIds;
        }

        @Nullable
        public EditorNotificationPanel apply(@NotNull FileEditor fileEditor) {
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Promo);
            this.setupCommercialIdeSuggestion(panel2, this.label);
            return panel2;
        }

        private final void setupCommercialIdeSuggestion(EditorNotificationPanel panel2, @Nls String label) {
            SuggestedIde ultimateIde = PluginAdvertiserService.Companion.getPyCharmProfessional();
            panel2.setText(label);
            panel2.icon(AllIcons.Ultimate.PycharmLock);
            PluginAdvertiserServiceKt.createTryUltimateActionLabel$default((EditorNotificationPanel)panel2, (SuggestedIde)ultimateIde, (Project)this.project, null, null, (int)12, null);
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> PycharmProSuggestion.setupCommercialIdeSuggestion$lambda$0(this));
        }

        private final void dismissSuggestion() {
            PropertiesComponent.getInstance().setValue("pycharm.pro.suggestion.dismissed", true);
        }

        private static final void setupCommercialIdeSuggestion$lambda$0(PycharmProSuggestion this$0) {
            FUSEventSource.EDITOR.logIgnoreExtension(this$0.project);
            this$0.dismissSuggestion();
            EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
        }
    }
}

