/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.amper;

import com.intellij.amper.FileUtilsKt;
import com.intellij.amper.ModuleUtilsKt;
import com.intellij.amper.project.AmperProjectManager;
import com.intellij.amper.project.entities.AmperFragmentEntity;
import com.intellij.amper.project.entities.AmperModel;
import com.intellij.amper.project.entities.AmperModelEntityKt;
import com.intellij.amper.project.sync.AmperSyncListener;
import com.intellij.amper.project.sync.AmperSyncResult;
import com.intellij.amper.project.sync.AmperSyncTaskDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.PackagesInterner;
import com.intellij.packageChecker.amper.AmperFilesModificationTracker;
import com.intellij.packageChecker.amper.AmperPackageCheckerUtilKt;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.BuildSystemDependenciesModelBase;
import com.intellij.packageChecker.java.ProjectDependenciesModels;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\fH\u0002J.\u0010&\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\f\u0018\u00010'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/packageChecker/amper/AmperProjectDependenciesModel;", "Lcom/intellij/packageChecker/java/BuildSystemDependenciesModelBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "refreshOnAmperSync", "", "supports", "", "isGradleBasedAmperProject", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAmperProject", "isAmperFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getAllModules", "", "Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "findPlatformModuleForFragment", "fragment", "Lcom/intellij/amper/project/entities/AmperModel$Fragment;", "findBuildFile", "amperModule", "Lcom/intellij/amper/project/entities/AmperModel$Module;", "declaredDependencies", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "findDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "platformModule", "buildFile", "findPackageDeclaration", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "packageToFind", "Lorg/jetbrains/security/package/Package;", "Companion", "intellij.packageChecker.amper"})
@SourceDebugExtension(value={"SMAP\nAmperProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmperProjectDependenciesModel.kt\ncom/intellij/packageChecker/amper/AmperProjectDependenciesModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 EntityStorage.kt\ncom/intellij/platform/workspace/storage/EntityStorageKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,164:1\n12574#2,2:165\n59#3:167\n1#4:168\n808#5,11:169\n14#6:180\n*S KotlinDebug\n*F\n+ 1 AmperProjectDependenciesModel.kt\ncom/intellij/packageChecker/amper/AmperProjectDependenciesModel\n*L\n70#1:165,2\n119#1:167\n140#1:169,11\n161#1:180\n*E\n"})
public final class AmperProjectDependenciesModel
extends BuildSystemDependenciesModelBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public AmperProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.refreshOnAmperSync();
        this.init();
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
    }

    private final void refreshOnAmperSync() {
        this.project.getMessageBus().connect().subscribe(AmperSyncListener.Companion.getTOPIC(), (Object)new AmperSyncListener(this){
            final /* synthetic */ AmperProjectDependenciesModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void syncFinished(AmperSyncTaskDescriptor task, AmperSyncResult result) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                this.this$0.refresh(AmperProjectDependenciesModel.access$getProject$p(this.this$0));
            }
        });
    }

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return AmperProjectManager.Companion.getInstance(project).isAmperProject() || this.isGradleBasedAmperProject(ProjectUtil.guessProjectDir((Project)project));
    }

    private final boolean isGradleBasedAmperProject(VirtualFile file) {
        if (file == null) {
            return false;
        }
        return ProjectDependenciesModels.INSTANCE.isProjectOfSystem(this.project, ProjectDependenciesModels.INSTANCE.getGRADLE_SYSTEM_ID()) && this.isAmperProject(file);
    }

    private final boolean isAmperProject(VirtualFile file) {
        boolean bl;
        block3: {
            if (file.isDirectory()) {
                VirtualFile[] virtualFileArray = file.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                Object[] $this$any$iv = virtualFileArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    VirtualFile p0 = (VirtualFile)element$iv;
                    boolean $i$f$isAmperProject$stub_for_inlining = false;
                    boolean bl2 = false;
                    if (!this.isAmperFile(p0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = this.isAmperFile(file);
            }
        }
        return bl;
    }

    private final boolean isAmperFile(VirtualFile file) {
        return FileUtilsKt.isAmperModuleFile((VirtualFile)file) || FileUtilsKt.isAmperProjectFile((VirtualFile)file);
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return FileUtilsKt.isAmperFile((PsiElement)((PsiElement)psiFile));
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ModuleUtilsKt.isAmperModule((Module)module);
    }

    @Override
    @NotNull
    protected ModificationTracker getModificationTracker(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (ModificationTracker)AmperFilesModificationTracker.Companion.getInstance(project);
    }

    @Override
    @NotNull
    public Iterable<MutableModuleModel> getAllModules() {
        List result = new ArrayList();
        AmperModel amperModel = AmperModelEntityKt.getAmperModel((Project)this.project);
        if (amperModel == null) {
            return CollectionsKt.emptyList();
        }
        AmperModel amperModel2 = amperModel;
        for (AmperModel.Module amperModule : amperModel2.getModules()) {
            for (AmperModel.Fragment fragment : amperModule.getFragments()) {
                Module platformModule = this.findPlatformModuleForFragment(this.project, fragment);
                if (platformModule == null) {
                    LOG.warn("Couldn't find platform module for Amper module " + amperModule.getName() + " and fragment " + fragment.getName());
                    continue;
                }
                VirtualFile buildFile = this.findBuildFile(amperModule);
                if (buildFile == null) {
                    LOG.warn("Couldn't find build file for Amper module " + amperModule.getName());
                    continue;
                }
                MutableModuleModel newModel = new MutableModuleModel(amperModule.getName() + "." + fragment.getName(), platformModule, buildFile, this.findDependencies(platformModule, buildFile), this.project);
                result.add(newModel);
            }
        }
        return result;
    }

    private final Module findPlatformModuleForFragment(Project project, AmperModel.Fragment fragment) {
        AmperFragmentEntity fragmentEntity;
        AmperFragmentEntity amperFragmentEntity;
        Object v0;
        ImmutableEntityStorage entityStorage;
        block1: {
            entityStorage = WorkspaceModel.Companion.getInstance(project).getCurrentSnapshot();
            EntityStorage $this$entities$iv = (EntityStorage)entityStorage;
            boolean $i$f$entities = false;
            Sequence sequence = $this$entities$iv.entities(AmperFragmentEntity.class);
            for (Object e : sequence) {
                AmperFragmentEntity it = (AmperFragmentEntity)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFragment(), (Object)fragment)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return (amperFragmentEntity = (fragmentEntity = (AmperFragmentEntity)v0)) != null && (amperFragmentEntity = amperFragmentEntity.getModule()) != null ? ModuleBridges.findModule((ModuleEntity)amperFragmentEntity, (EntityStorage)((EntityStorage)entityStorage)) : null;
    }

    private final VirtualFile findBuildFile(AmperModel.Module amperModule) {
        VirtualFileUrl virtualFileUrl = amperModule.getSourceFileUrl();
        return virtualFileUrl != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl) : null;
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return AmperPackageCheckerUtilKt.getOrFindDeclaredDependenciesInFileOnly(psiFile);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = ModuleUtilsKt.findAmperModuleFile((Module)module);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile amperModuleFile = virtualFile;
        return AmperPackageCheckerUtilKt.findDeclaredDependenciesFollowingLinks(this.project, amperModuleFile);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Dependency> findDependencies(Module platformModule, VirtualFile buildFile) {
        void $this$filterIsInstanceTo$iv$iv;
        Set dependencies = new LinkedHashSet();
        AmperModel.Fragment fragment = ModuleUtilsKt.findFragmentForPlatformModule((Module)platformModule);
        if (fragment == null) {
            return SetsKt.emptySet();
        }
        AmperModel.Fragment fragment2 = fragment;
        Iterable $this$filterIsInstance$iv = fragment2.getExternalDependencies();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AmperModel.Fragment.Notation.MavenDependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (AmperModel.Fragment.Notation.MavenDependency dependency : (List)destination$iv$iv) {
            Package pkg1;
            if (AmperPackageCheckerUtilKt.createPackage(dependency) == null) continue;
            Package pkg = PackagesInterner.Companion.getInstance(this.project).intern(pkg1);
            Pair<PsiElement, VirtualFile> pair = this.findPackageDeclaration(this.project, buildFile, pkg);
            if (pair == null) continue;
            VirtualFile file = (VirtualFile)pair.component2();
            DependencyContext dependencyContext = new DependencyContext(this.project, platformModule, file, null, (arg_0, arg_1, arg_2) -> AmperProjectDependenciesModel.findDependencies$lambda$1(this, arg_0, arg_1, arg_2), 8, null);
            ((Collection)dependencies).add(new Dependency(pkg, SetsKt.emptySet(), dependencyContext));
        }
        return dependencies;
    }

    private final Pair<PsiElement, VirtualFile> findPackageDeclaration(Project project, VirtualFile buildFile, Package packageToFind) {
        Object v0;
        block4: {
            Iterable iterable = AmperPackageCheckerUtilKt.findDeclaredDependenciesFollowingLinks(project, buildFile);
            for (Object t : iterable) {
                PackageDeclaration it = (PackageDeclaration)t;
                boolean bl = false;
                if (!it.getPkg().matches(packageToFind)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        PackageDeclaration packageDeclaration = v0;
        if (packageDeclaration == null) {
            return null;
        }
        PackageDeclaration declaration = packageDeclaration;
        PsiElement psiElement = (PsiElement)ActionsKt.runReadAction(() -> AmperProjectDependenciesModel.findPackageDeclaration$lambda$3(declaration));
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> AmperProjectDependenciesModel.findPackageDeclaration$lambda$4(psiElement2));
        if (psiFile == null) {
            return null;
        }
        PsiFile containingFile = psiFile;
        return new Pair((Object)psiElement2, (Object)containingFile.getVirtualFile());
    }

    private static final PsiElement findDependencies$lambda$1(AmperProjectDependenciesModel this$0, VirtualFile f, Module module, Package _pkg) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)_pkg, (String)"_pkg");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Pair<PsiElement, VirtualFile> pair = this$0.findPackageDeclaration(project, f, _pkg);
        return pair != null ? (PsiElement)pair.getFirst() : null;
    }

    private static final PsiElement findPackageDeclaration$lambda$3(PackageDeclaration $declaration) {
        return $declaration.getPsiElement();
    }

    private static final PsiFile findPackageDeclaration$lambda$4(PsiElement $psiElement) {
        return $psiElement.getContainingFile();
    }

    public static final /* synthetic */ Project access$getProject$p(AmperProjectDependenciesModel $this) {
        return $this.project;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AmperProjectDependenciesModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/packageChecker/amper/AmperProjectDependenciesModel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.packageChecker.amper"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

