/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.kotlin;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.qodana.QodanaBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/jvm/kotlin/QodanaKotlinSanityInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Visitor", "intellij.qodana.jvm.kotlin"})
public final class QodanaKotlinSanityInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (isOnTheFly) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiFile psiFile2 = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        PsiFile file = psiFile2;
        if (InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)file));
        if (virtualFile == null || CompilerConfiguration.getInstance((Project)holder.getProject()).isExcludedFromCompilation(virtualFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new Visitor(holder);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/qodana/jvm/kotlin/QodanaKotlinSanityInspection$Visitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitImportDirective", "", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "visitTypeReference", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "canResolve", "", "reference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "intellij.qodana.jvm.kotlin"})
    @SourceDebugExtension(value={"SMAP\nQodanaKotlinSanityInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaKotlinSanityInspection.kt\norg/jetbrains/qodana/jvm/kotlin/QodanaKotlinSanityInspection$Visitor\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,66:1\n162#2:67\n*S KotlinDebug\n*F\n+ 1 QodanaKotlinSanityInspection.kt\norg/jetbrains/qodana/jvm/kotlin/QodanaKotlinSanityInspection$Visitor\n*L\n39#1:67\n*E\n"})
    private static final class Visitor
    extends KtVisitorVoid {
        @NotNull
        private final ProblemsHolder holder;

        public Visitor(@NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        public void visitImportDirective(@NotNull KtImportDirective importDirective) {
            KtReferenceExpression ktReferenceExpression;
            Intrinsics.checkNotNullParameter((Object)importDirective, (String)"importDirective");
            KtExpression ktExpression = importDirective.getImportedReference();
            if (ktExpression == null) {
                return;
            }
            KtExpression referenceExpression = ktExpression;
            if (referenceExpression instanceof KtReferenceExpression) {
                ktReferenceExpression = (KtReferenceExpression)referenceExpression;
            } else {
                PsiElement $this$getChildOfType$iv = (PsiElement)referenceExpression;
                boolean $i$f$getChildOfType = false;
                ktReferenceExpression = (KtReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtReferenceExpression.class);
            }
            if (ktReferenceExpression == null) {
                return;
            }
            KtReferenceExpression reference = ktReferenceExpression;
            if (this.canResolve(ReferenceUtilsKt.getMainReference((KtReferenceExpression)reference))) {
                return;
            }
            Object[] objectArray = new Object[]{referenceExpression.getText()};
            this.holder.registerProblem((PsiElement)referenceExpression, QodanaBundle.message("inspection.message.unresolved.reference", objectArray), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }

        public void visitTypeReference(@NotNull KtTypeReference typeReference) {
            Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
            KtTypeElement ktTypeElement = typeReference.getTypeElement();
            KtUserType ktUserType = ktTypeElement instanceof KtUserType ? (KtUserType)ktTypeElement : null;
            if (ktUserType == null || (ktUserType = ktUserType.getReferenceExpression()) == null) {
                return;
            }
            KtUserType referenceExpression = ktUserType;
            if (this.canResolve((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)referenceExpression)) || typeReference.isPlaceholder()) {
                return;
            }
            Object[] objectArray = new Object[]{typeReference.getText()};
            this.holder.registerProblem((PsiElement)typeReference, QodanaBundle.message("inspection.message.unresolved.reference", objectArray), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }

        public final boolean canResolve(@NotNull KtReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            ResolveResult[] resolveResultArray = reference.multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            ResolveResult[] resolveResults = resolveResultArray;
            return !(resolveResults.length == 0);
        }
    }
}

