/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.zip.DosTime;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import com.intellij.util.io.zip.Zip64ExtraField;
import com.intellij.util.io.zip.ZipLong;
import com.intellij.util.io.zip.ZipShort;
import com.intellij.util.io.zip.ZipUInt64;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;
import org.jetbrains.annotations.NotNull;

final class JBZipOutputStream {
    private static final int ZIP64_MIN_VERSION = 45;
    private static final int ZIP_MIN_VERSION = 10;
    private static final long ZIP64_MAGIC = 0xFFFFFFFFL;
    public static final int DEFAULT_COMPRESSION = -1;
    private String comment = "";
    private int level = -1;
    private int method = 0;
    private final CRC32 crc = new CRC32();
    private long writtenOnDisk;
    private String encoding = null;
    private final Deflater def = new Deflater(this.level, true);
    private final RandomAccessFile raf;
    private final JBZipFile myFile;
    private static final byte[] LFH_SIG = ZipLong.getBytes(67324752L);
    static final byte[] CFH_SIG = ZipLong.getBytes(33639248L);
    static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    static final byte[] ZIP64_EOCD_LOC_SIG = ZipLong.getBytes(117853008L);
    static final byte[] ZIP64_EOCD_SIG = ZipLong.getBytes(101075792L);
    private final BufferExposingByteArrayOutputStream myBuffer = new BufferExposingByteArrayOutputStream();

    JBZipOutputStream(JBZipFile file, long currentCDOffset) {
        this.myFile = file;
        this.raf = this.myFile.myArchive;
        this.writtenOnDisk = currentCDOffset;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void finish() throws IOException {
        long cdOffset = this.getWritten();
        List<JBZipEntry> entries2 = this.myFile.getEntries();
        for (JBZipEntry entry : entries2) {
            this.writeCentralFileHeader(entry);
        }
        long cdLength = this.getWritten() - cdOffset;
        if (this.myFile.isZip64()) {
            this.writeZip64CentralDirectory(cdLength, cdOffset);
        }
        this.writeCentralDirectoryEnd(cdLength, cdOffset);
        this.flushBuffer();
        this.def.end();
    }

    private void writeZip64CentralDirectory(long cdLength, long cdOffset) throws IOException {
        long offset = this.getWritten();
        this.writeOut(ZIP64_EOCD_SIG);
        this.writeOut(ZipUInt64.getBytes(44L));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(ZipLong.getBytes(0L));
        this.writeOut(ZipLong.getBytes(0L));
        int numOfEntriesOnThisDisk = this.myFile.getEntries().size();
        byte[] numOfEntriesOnThisDiskData = ZipUInt64.getBytes(numOfEntriesOnThisDisk);
        this.writeOut(numOfEntriesOnThisDiskData);
        byte[] num = ZipUInt64.getBytes(this.myFile.getEntries().size());
        this.writeOut(num);
        this.writeOut(ZipUInt64.getBytes(cdLength));
        this.writeOut(ZipUInt64.getBytes(cdOffset));
        this.writeOut(ZIP64_EOCD_LOC_SIG);
        this.writeOut(ZipLong.getBytes(0L));
        this.writeOut(ZipUInt64.getBytes(offset));
        this.writeOut(ZipLong.getBytes(1L));
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + level);
        }
        this.level = level;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    private ExtraFieldData writeLocalFileHeader(JBZipEntry ze) throws IOException {
        long headerOffset = this.getWritten();
        ze.setHeaderOffset(headerOffset);
        if (this.myFile.isZip64()) {
            ze.addExtra(new Zip64ExtraField(new ZipUInt64(ze.getSize()), new ZipUInt64(ze.getCompressedSize()), new ZipUInt64(ze.getHeaderOffset())));
        } else if (headerOffset >= 0xFFFFFFFFL) {
            throw new IOException("entry header offset is greater than maximal supported: " + headerOffset);
        }
        this.writeOut(LFH_SIG);
        this.writeOutShort(this.myFile.isZip64() ? 45 : 10);
        this.writeOutShort(0);
        this.writeOutShort(ze.getMethod());
        this.writeOutLong(DosTime.javaToDosTime(ze.getTime()));
        this.writeOutLong(ze.getCrc());
        if (ze.getCompressedSize() >= 0xFFFFFFFFL) {
            throw new IOException("compressed size is greater than maximal supported: " + ze.getCompressedSize());
        }
        this.writeOutLong(ze.getCompressedSize());
        if (ze.getSize() >= 0xFFFFFFFFL) {
            throw new IOException("size is greater than maximal supported: " + ze.getSize());
        }
        this.writeOutLong(ze.getSize());
        byte[] name = this.getBytes(ze.getName());
        this.writeOutShort(name.length);
        byte[] extra = ze.getLocalFileHeaderDataExtra();
        this.writeOutShort(extra.length);
        this.writeOut(name);
        long extraOffset = this.getWritten();
        this.writeOut(extra);
        return new ExtraFieldData(extraOffset, extra.length);
    }

    private void updateLocalFileHeader(JBZipEntry ze, long crc, long compressedSize, ExtraFieldData extra) throws IOException {
        ze.setCrc(crc);
        ze.setCompressedSize(compressedSize);
        if (this.myFile.isZip64()) {
            ze.addExtra(new Zip64ExtraField(new ZipUInt64(ze.getSize()), new ZipUInt64(ze.getCompressedSize()), new ZipUInt64(ze.getHeaderOffset())));
        }
        this.flushBuffer();
        long offset = ze.getHeaderOffset() + 14L;
        this.raf.seek(offset);
        this.raf.write(ZipLong.getBytes(crc));
        this.raf.write(ZipLong.getBytes(compressedSize));
        this.raf.write(ZipLong.getBytes(ze.getSize()));
        this.raf.seek(extra.offset);
        byte[] extraData = ze.getLocalFileHeaderDataExtra();
        if (extra.length != (long)extraData.length) {
            throw new IOException("Extra data is unstable");
        }
        this.raf.write(extraData);
    }

    private void writeOutShort(int s) throws IOException {
        this.writeOut(ZipShort.getBytes(s));
    }

    private void writeOutLong(long s) throws IOException {
        this.writeOut(ZipLong.getBytes(s));
    }

    private void writeCentralFileHeader(JBZipEntry ze) throws IOException {
        this.writeOut(CFH_SIG);
        this.writeOutShort(ze.getPlatform() << 8 | 0x14);
        this.writeOutShort(10);
        this.writeOutShort(0);
        this.writeOutShort(ze.getMethod());
        this.writeOutLong(DosTime.javaToDosTime(ze.getTime()));
        this.writeOutLong(ze.getCrc());
        this.writeOutLong(ze.getCompressedSize());
        this.writeOutLong(ze.getSize());
        byte[] name = this.getBytes(ze.getName());
        this.writeOutShort(name.length);
        byte[] extra = ze.getCentralDirectoryExtraBytes();
        this.writeOutShort(extra.length);
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        byte[] commentB = this.getBytes(comm);
        this.writeOutShort(commentB.length);
        this.writeOutShort(0);
        this.writeOutShort(ze.getInternalAttributes());
        this.writeOutLong(ze.getExternalAttributes());
        this.writeOutLong(Math.min(ze.getHeaderOffset(), 0xFFFFFFFFL));
        this.writeOut(name);
        this.writeOut(extra);
        this.writeOut(commentB);
    }

    private void writeCentralDirectoryEnd(long cdLength, long cdOffset) throws IOException {
        this.writeOut(EOCD_SIG);
        this.writeOutShort(0);
        this.writeOutShort(0);
        int entiresCount = this.myFile.getEntries().size();
        this.writeOutShort(entiresCount);
        this.writeOutShort(entiresCount);
        this.writeOutLong(cdLength);
        this.writeOutLong(cdOffset);
        byte[] data = this.getBytes(this.comment);
        this.writeOutShort(data.length);
        this.writeOut(data);
    }

    private byte[] getBytes(String name) throws ZipException {
        if (this.encoding == null) {
            return name.getBytes(StandardCharsets.UTF_8);
        }
        try {
            return name.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    private void writeOut(byte[] data) throws IOException {
        this.writeOut(data, 0, data.length);
    }

    private void writeOut(byte[] data, int offset, int length) throws IOException {
        this.myBuffer.write(data, offset, length);
        if (this.myBuffer.size() > 8192) {
            this.flushBuffer();
        }
    }

    void ensureFlushed(long end) throws IOException {
        if (end > this.writtenOnDisk) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.raf.seek(this.writtenOnDisk);
        this.raf.write(this.myBuffer.getInternalBuffer(), 0, this.myBuffer.size());
        this.writtenOnDisk += (long)this.myBuffer.size();
        this.myBuffer.reset();
    }

    public void putNextEntryBytes(JBZipEntry entry, byte[] bytes) throws IOException {
        byte[] outputBytes;
        int outputBytesLength;
        this.prepareNextEntry(entry);
        this.crc.reset();
        this.crc.update(bytes);
        entry.setCrc(this.crc.getValue());
        if (entry.getMethod() == 8) {
            this.def.setLevel(this.level);
            BufferExposingByteArrayOutputStream compressedBytesStream = new BufferExposingByteArrayOutputStream();
            try (DeflaterOutputStream stream = new DeflaterOutputStream((OutputStream)compressedBytesStream, this.def);){
                stream.write(bytes);
            }
            outputBytesLength = compressedBytesStream.size();
            outputBytes = compressedBytesStream.getInternalBuffer();
        } else {
            outputBytesLength = bytes.length;
            outputBytes = bytes;
        }
        entry.setCompressedSize(outputBytesLength);
        entry.setSize(bytes.length);
        this.writeLocalFileHeader(entry);
        this.writeOut(outputBytes, 0, outputBytesLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putNextEntryContent(JBZipEntry entry, InputStream content) throws IOException {
        FilterOutputStream output;
        this.prepareNextEntry(entry);
        ExtraFieldData extra = this.writeLocalFileHeader(entry);
        this.flushBuffer();
        RandomAccessFileOutputStream fileOutput = new RandomAccessFileOutputStream(this.raf);
        BufferedOutputStream bufferedFileOutput = new BufferedOutputStream(fileOutput);
        if (entry.getMethod() == 8) {
            this.def.setLevel(this.level);
            output = new DeflaterOutputStream((OutputStream)bufferedFileOutput, this.def);
        } else {
            output = bufferedFileOutput;
        }
        long writtenSize = 0L;
        try {
            int count2;
            byte[] buffer = new byte[10240];
            this.crc.reset();
            while ((count2 = content.read(buffer)) > 0) {
                writtenSize += (long)count2;
                ((OutputStream)output).write(buffer, 0, count2);
                this.crc.update(buffer, 0, count2);
            }
        }
        finally {
            ((OutputStream)output).close();
        }
        this.writtenOnDisk += fileOutput.myWrittenBytes;
        entry.setSize(writtenSize);
        this.updateLocalFileHeader(entry, this.crc.getValue(), fileOutput.myWrittenBytes, extra);
    }

    private void prepareNextEntry(JBZipEntry entry) {
        if (entry.getMethod() == -1) {
            entry.setMethod(this.method);
        }
        if (entry.getTime() == -1L) {
            entry.setTime(System.currentTimeMillis());
        }
        if (this.myFile.isZip64()) {
            Zip64ExtraField field = new Zip64ExtraField(new ZipUInt64(entry.getSize()), new ZipUInt64(entry.getCompressedSize()), new ZipUInt64(0L));
            entry.addExtra(field);
        }
    }

    long getWritten() {
        return this.writtenOnDisk + (long)this.myBuffer.size();
    }

    private static class ExtraFieldData {
        private final long offset;
        private final long length;

        ExtraFieldData(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private final RandomAccessFile myFile;
        private long myWrittenBytes;

        RandomAccessFileOutputStream(RandomAccessFile file) {
            this.myFile = file;
        }

        @Override
        public void write(int b) throws IOException {
            this.myFile.write(b);
            ++this.myWrittenBytes;
        }

        @Override
        public void write(byte @NotNull [] b, int off, int len) throws IOException {
            if (b == null) {
                RandomAccessFileOutputStream.$$$reportNull$$$0(0);
            }
            this.myFile.write(b, off, len);
            this.myWrittenBytes += (long)len;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/zip/JBZipOutputStream$RandomAccessFileOutputStream", "write"));
        }
    }
}

