/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH&J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "", "type", "", "extensionSuffix", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getType", "()Ljava/lang/String;", "getExtensionSuffix", "XZ", "GZIP", "PLAIN", "createUnpackingStream", "Ljava/io/InputStream;", "packedStream", "compress", "", "file", "Ljava/nio/file/Path;", "output", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.indexing.shared"})
public abstract class SharedIndexCompression
extends Enum<SharedIndexCompression> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String type;
    @NotNull
    private final String extensionSuffix;
    public static final /* enum */ SharedIndexCompression XZ;
    public static final /* enum */ SharedIndexCompression GZIP;
    public static final /* enum */ SharedIndexCompression PLAIN;
    private static final /* synthetic */ SharedIndexCompression[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private SharedIndexCompression(String type, String extensionSuffix) {
        this.type = type;
        this.extensionSuffix = extensionSuffix;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getExtensionSuffix() {
        return this.extensionSuffix;
    }

    @NotNull
    public abstract InputStream createUnpackingStream(@NotNull InputStream var1);

    public abstract void compress(@NotNull Path var1, @NotNull Path var2, @NotNull ProgressIndicator var3);

    public static SharedIndexCompression[] values() {
        return (SharedIndexCompression[])$VALUES.clone();
    }

    public static SharedIndexCompression valueOf(String value) {
        return Enum.valueOf(SharedIndexCompression.class, value);
    }

    @NotNull
    public static EnumEntries<SharedIndexCompression> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @Nullable
    public static final SharedIndexCompression findByType(@Nullable String type) {
        return Companion.findByType(type);
    }

    public /* synthetic */ SharedIndexCompression(String $enum$name, int $enum$ordinal, String type, String extensionSuffix, DefaultConstructorMarker $constructor_marker) {
        this(type, extensionSuffix);
    }

    static {
        XZ = new XZ("XZ", 0);
        GZIP = new GZIP("GZIP", 1);
        PLAIN = new PLAIN("PLAIN", 2);
        $VALUES = sharedIndexCompressionArray = new SharedIndexCompression[]{SharedIndexCompression.XZ, SharedIndexCompression.GZIP, SharedIndexCompression.PLAIN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexCompression$Companion;", "", "<init>", "()V", "findByType", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "type", "", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndexCompression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexCompression.kt\ncom/intellij/indexing/shared/download/SharedIndexCompression$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n1310#2,2:61\n*S KotlinDebug\n*F\n+ 1 SharedIndexCompression.kt\ncom/intellij/indexing/shared/download/SharedIndexCompression$Companion\n*L\n57#1:61,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final SharedIndexCompression findByType(@Nullable String type) {
            SharedIndexCompression sharedIndexCompression;
            block1: {
                SharedIndexCompression[] $this$firstOrNull$iv = SharedIndexCompression.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    SharedIndexCompression element$iv;
                    SharedIndexCompression it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)type)) continue;
                    sharedIndexCompression = element$iv;
                    break block1;
                }
                sharedIndexCompression = null;
            }
            return sharedIndexCompression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"com/intellij/indexing/shared/download/SharedIndexCompression.GZIP", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "createUnpackingStream", "Ljava/util/zip/GZIPInputStream;", "packedStream", "Ljava/io/InputStream;", "compress", "", "file", "Ljava/nio/file/Path;", "output", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndexCompression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexCompression.kt\ncom/intellij/indexing/shared/download/SharedIndexCompression$GZIP\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n24#2:61\n*S KotlinDebug\n*F\n+ 1 SharedIndexCompression.kt\ncom/intellij/indexing/shared/download/SharedIndexCompression$GZIP\n*L\n33#1:61\n*E\n"})
    static final class GZIP
    extends SharedIndexCompression {
        /*
         * WARNING - void declaration
         */
        GZIP() {
            void var1_1;
        }

        @Override
        @NotNull
        public GZIPInputStream createUnpackingStream(@NotNull InputStream packedStream) {
            Intrinsics.checkNotNullParameter((Object)packedStream, (String)"packedStream");
            return new GZIPInputStream(packedStream);
        }

        @Override
        public void compress(@NotNull Path file, @NotNull Path output, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            GZIP $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GZIP.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Packing shared index with GZip");
            UtilKt.compressSharedIndex(file, output, indicator, (Function1<? super OutputStream, ? extends OutputStream>)((Function1)GZIP::compress$lambda$0));
        }

        private static final OutputStream compress$lambda$0(OutputStream it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new GZIPOutputStream(it, 0x100000);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"com/intellij/indexing/shared/download/SharedIndexCompression.PLAIN", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "createUnpackingStream", "Ljava/io/InputStream;", "packedStream", "compress", "", "file", "Ljava/nio/file/Path;", "output", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
    static final class PLAIN
    extends SharedIndexCompression {
        /*
         * WARNING - void declaration
         */
        PLAIN() {
            void var1_1;
        }

        @Override
        @NotNull
        public InputStream createUnpackingStream(@NotNull InputStream packedStream) {
            Intrinsics.checkNotNullParameter((Object)packedStream, (String)"packedStream");
            return packedStream;
        }

        @Override
        public void compress(@NotNull Path file, @NotNull Path output, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(file, output, copyOptionArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"com/intellij/indexing/shared/download/SharedIndexCompression.XZ", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "createUnpackingStream", "Lorg/tukaani/xz/XZInputStream;", "packedStream", "Ljava/io/InputStream;", "compress", "", "file", "Ljava/nio/file/Path;", "output", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndexCompression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexCompression.kt\ncom/intellij/indexing/shared/download/SharedIndexCompression$XZ\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n24#2:61\n*S KotlinDebug\n*F\n+ 1 SharedIndexCompression.kt\ncom/intellij/indexing/shared/download/SharedIndexCompression$XZ\n*L\n24#1:61\n*E\n"})
    static final class XZ
    extends SharedIndexCompression {
        /*
         * WARNING - void declaration
         */
        XZ() {
            void var1_1;
        }

        @NotNull
        public XZInputStream createUnpackingStream(@NotNull InputStream packedStream) {
            Intrinsics.checkNotNullParameter((Object)packedStream, (String)"packedStream");
            return new XZInputStream(packedStream);
        }

        @Override
        public void compress(@NotNull Path file, @NotNull Path output, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            XZ $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(XZ.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Packing shared index with XZ");
            UtilKt.compressSharedIndex(file, output, indicator, (Function1<? super OutputStream, ? extends OutputStream>)((Function1)XZ::compress$lambda$0));
        }

        private static final OutputStream compress$lambda$0(OutputStream it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (OutputStream)new XZOutputStream(it, (FilterOptions)new LZMA2Options());
        }
    }
}

