/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.Definitions;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.Bytes;

public class MapBasedEndpointContext
extends AddressEndpointContext {
    public static final Definitions<Definition<?>> ATTRIBUTE_DEFINITIONS = new Definitions<Definition<?>>("EndpointContextAttributes"){

        @Override
        public Definition<?> addIfAbsent(Definition<?> definition) {
            if (definition == null) {
                throw new NullPointerException();
            }
            Class<?> valueType = definition.getValueType();
            if (valueType != String.class && valueType != Integer.class && valueType != Long.class && valueType != Boolean.class && valueType != InetSocketAddress.class && !Bytes.class.isAssignableFrom(valueType)) {
                throw new IllegalArgumentException(valueType + " is not supported, only String, Integer, Long, Boolean, InetSocketAddress and Bytes!");
            }
            return super.addIfAbsent(definition);
        }
    };
    public static final String KEY_PREFIX_NONE_CRITICAL = "*";
    private final boolean hasCriticalEntries;
    private final Map<Definition<?>, Object> entries;

    public MapBasedEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, Attributes attributes) {
        this(peerAddress, null, peerIdentity, attributes);
    }

    public MapBasedEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, Attributes attributes) {
        super(peerAddress, virtualHost, peerIdentity);
        if (attributes == null) {
            throw new NullPointerException("missing attributes map, must not be null!");
        }
        attributes.lock();
        this.entries = Collections.unmodifiableMap(attributes.entries);
        this.hasCriticalEntries = MapBasedEndpointContext.findCriticalEntries(this.entries);
    }

    private static final boolean findCriticalEntries(Map<Definition<?>, Object> attributes) {
        for (Definition<?> key : attributes.keySet()) {
            if (key.getKey().startsWith(KEY_PREFIX_NONE_CRITICAL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T get(Definition<T> key) {
        return (T)this.entries.get(key);
    }

    @Override
    public Map<Definition<?>, Object> entries() {
        return this.entries;
    }

    @Override
    public boolean hasCriticalEntries() {
        return this.hasCriticalEntries;
    }

    @Override
    public String toString() {
        return String.format("MAP(%s)", this.getPeerAddressAsString());
    }

    public static MapBasedEndpointContext setEntries(EndpointContext context, Attributes attributes) {
        return new MapBasedEndpointContext(context.getPeerAddress(), context.getVirtualHost(), context.getPeerIdentity(), attributes);
    }

    public static MapBasedEndpointContext addEntries(EndpointContext context, Attributes attributes) {
        Attributes allAttributes = new Attributes(context.entries());
        allAttributes.addAll(attributes);
        return MapBasedEndpointContext.setEntries(context, allAttributes);
    }

    public static MapBasedEndpointContext removeEntries(EndpointContext context, Definition<?> ... attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes must not null!");
        }
        Attributes entries = new Attributes(context.entries());
        for (int index = 0; index < attributes.length; ++index) {
            try {
                Definition<?> key = attributes[index];
                if (entries.remove(key)) continue;
                throw new IllegalArgumentException(index + ". key '" + key + "' is not contained");
            }
            catch (NullPointerException ex) {
                throw new NullPointerException(index + ". " + ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(index + ". " + ex.getMessage());
            }
        }
        return new MapBasedEndpointContext(context.getPeerAddress(), context.getVirtualHost(), context.getPeerIdentity(), entries);
    }

    public static final class Attributes {
        private final Map<Definition<?>, Object> entries = new HashMap();
        private volatile boolean lock;

        public Attributes() {
        }

        private Attributes(Map<Definition<?>, Object> entries) {
            this.entries.putAll(entries);
        }

        public Attributes lock() {
            this.lock = true;
            return this;
        }

        public Attributes addAll(Attributes attributes) {
            if (this.lock) {
                throw new IllegalStateException("Already in use!");
            }
            this.entries.putAll(attributes.entries);
            return this;
        }

        public <T> Attributes add(Definition<T> definition, T value) {
            if (this.lock) {
                throw new IllegalStateException("Already in use!");
            }
            if (null == definition) {
                throw new NullPointerException("key is null");
            }
            if (null == value && !definition.getKey().startsWith(MapBasedEndpointContext.KEY_PREFIX_NONE_CRITICAL)) {
                throw new NullPointerException("value is null");
            }
            if (!ATTRIBUTE_DEFINITIONS.contains(definition)) {
                throw new IllegalArgumentException(definition + " is not supported!");
            }
            if (value == null) {
                this.entries.remove(definition);
            } else if (this.entries.put(definition, value) != null) {
                throw new IllegalArgumentException("'" + definition + "' already contained!");
            }
            return this;
        }

        public <T> boolean contains(Definition<T> key) {
            if (null == key) {
                throw new NullPointerException("key is null");
            }
            return this.entries.containsKey(key);
        }

        public <T> boolean remove(Definition<T> key) {
            if (this.lock) {
                throw new IllegalStateException("Already in use!");
            }
            if (null == key) {
                throw new NullPointerException("key is null");
            }
            return this.entries.remove(key) != null;
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof Attributes) {
                Attributes other = (Attributes)obj;
                return this.entries.equals(other.entries);
            }
            return false;
        }
    }
}

