//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

 // G4 Low energy model: n-p scattering -- Data
 // THIS FILE contains static array initialization
 // F.W. Jones, L.G. Greeniaus, H.P. Wellisch

// FWJ 27-AUG-2010: extended to 5 GeV by Tony Kwan TRIUMF

// Table of Cumulative np Scattering Probabilities
// To be used for generation as a function of std::cos(theta cm)
// NOTE: Assumes angle range to be generated is 0-180 degrees
//       This allows tracking of
//       well-defined GEANT4 particles and generation of secondary
// Range of validity of tables: 10 - 1200 MeV
// Results are extracted from RA Arndt"s PSA of 1998
// CM Angle range: 0.5 - 179.5 degrees in 1 degree steps
// Data written 8 values/line, delimited by commas
// Appended at end: cm momentum (GeV/c), Lab Energy (GeV), max 
// dsigma/domega-CM (mb/sr), total cross section 

 #include "G4Types.hh"

 const G4float G4LEnp::sig[NENERGY][NANGLE] = {
   //------------  0.01 GeV
  {0.00007f,  0.00030f,  0.00066f,  0.00118f,  0.00184f,  0.00265f,  0.00360f,
   0.00471f,  0.00595f,  0.00735f,  0.00888f,  0.01057f,  0.01239f,  0.01436f,
   0.01648f,  0.01874f,  0.02113f,  0.02367f,  0.02635f,  0.02917f,  0.03213f,
   0.03523f,  0.03847f,  0.04184f,  0.04534f,  0.04899f,  0.05276f,  0.05667f,
   0.06071f,  0.06488f,  0.06917f,  0.07360f,  0.07815f,  0.08283f,  0.08763f,
   0.09255f,  0.09760f,  0.10276f,  0.10805f,  0.11345f,  0.11896f,  0.12459f,
   0.13033f,  0.13618f,  0.14214f,  0.14821f,  0.15438f,  0.16066f,  0.16704f,
   0.17352f,  0.18009f,  0.18677f,  0.19353f,  0.20039f,  0.20734f,  0.21438f,
   0.22151f,  0.22871f,  0.23601f,  0.24338f,  0.25083f,  0.25835f,  0.26595f,
   0.27362f,  0.28136f,  0.28917f,  0.29704f,  0.30497f,  0.31297f,  0.32102f,
   0.32913f,  0.33729f,  0.34550f,  0.35376f,  0.36207f,  0.37042f,  0.37881f,
   0.38724f,  0.39570f,  0.40420f,  0.41273f,  0.42129f,  0.42988f,  0.43848f,
   0.44711f,  0.45576f,  0.46443f,  0.47310f,  0.48179f,  0.49049f,  0.49919f,
   0.50789f,  0.51659f,  0.52530f,  0.53399f,  0.54268f,  0.55136f,  0.56003f,
   0.56868f,  0.57731f,  0.58592f,  0.59451f,  0.60307f,  0.61161f,  0.62011f,
   0.62858f,  0.63701f,  0.64540f,  0.65376f,  0.66206f,  0.67032f,  0.67853f,
   0.68669f,  0.69480f,  0.70285f,  0.71083f,  0.71876f,  0.72662f,  0.73442f,
   0.74214f,  0.74979f,  0.75737f,  0.76487f,  0.77230f,  0.77964f,  0.78689f,
   0.79407f,  0.80115f,  0.80814f,  0.81504f,  0.82184f,  0.82854f,  0.83515f,
   0.84165f,  0.84805f,  0.85434f,  0.86052f,  0.86659f,  0.87255f,  0.87840f,
   0.88413f,  0.88974f,  0.89523f,  0.90060f,  0.90584f,  0.91096f,  0.91595f,
   0.92081f,  0.92554f,  0.93014f,  0.93460f,  0.93892f,  0.94311f,  0.94716f,
   0.95107f,  0.95484f,  0.95847f,  0.96195f,  0.96528f,  0.96847f,  0.97151f,
   0.97440f,  0.97714f,  0.97973f,  0.98217f,  0.98445f,  0.98658f,  0.98856f,
   0.99038f,  0.99204f,  0.99355f,  0.99490f,  0.99610f,  0.99713f,  0.99801f,
   0.99872f,  0.99928f,  0.99968f,  0.99992f,  1.00000f},
   //---------  0.02 GeV
  {0.00008f,  0.00030f,  0.00068f,  0.00120f,  0.00188f,  0.00271f,  0.00368f,
   0.00480f,  0.00608f,  0.00750f,  0.00906f,  0.01078f,  0.01264f,  0.01465f,
   0.01680f,  0.01909f,  0.02153f,  0.02411f,  0.02684f,  0.02970f,  0.03270f,
   0.03584f,  0.03912f,  0.04254f,  0.04609f,  0.04977f,  0.05359f,  0.05753f,
   0.06161f,  0.06582f,  0.07015f,  0.07461f,  0.07919f,  0.08390f,  0.08873f,
   0.09367f,  0.09874f,  0.10392f,  0.10922f,  0.11463f,  0.12015f,  0.12578f,
   0.13152f,  0.13737f,  0.14332f,  0.14937f,  0.15553f,  0.16178f,  0.16813f,
   0.17458f,  0.18112f,  0.18775f,  0.19447f,  0.20128f,  0.20817f,  0.21515f,
   0.22221f,  0.22935f,  0.23657f,  0.24386f,  0.25123f,  0.25866f,  0.26617f,
   0.27374f,  0.28138f,  0.28908f,  0.29685f,  0.30467f,  0.31255f,  0.32048f,
   0.32846f,  0.33650f,  0.34458f,  0.35271f,  0.36088f,  0.36909f,  0.37734f,
   0.38563f,  0.39395f,  0.40231f,  0.41069f,  0.41911f,  0.42754f,  0.43600f,
   0.44448f,  0.45298f,  0.46150f,  0.47003f,  0.47857f,  0.48712f,  0.49568f,
   0.50424f,  0.51280f,  0.52136f,  0.52992f,  0.53848f,  0.54703f,  0.55557f,
   0.56409f,  0.57260f,  0.58110f,  0.58957f,  0.59803f,  0.60645f,  0.61486f,
   0.62323f,  0.63157f,  0.63988f,  0.64815f,  0.65639f,  0.66458f,  0.67273f,
   0.68083f,  0.68889f,  0.69689f,  0.70484f,  0.71274f,  0.72057f,  0.72835f,
   0.73607f,  0.74372f,  0.75130f,  0.75881f,  0.76625f,  0.77362f,  0.78090f,
   0.78811f,  0.79524f,  0.80228f,  0.80924f,  0.81611f,  0.82289f,  0.82957f,
   0.83616f,  0.84265f,  0.84904f,  0.85533f,  0.86151f,  0.86759f,  0.87356f,
   0.87942f,  0.88516f,  0.89079f,  0.89630f,  0.90168f,  0.90695f,  0.91209f,
   0.91711f,  0.92200f,  0.92675f,  0.93138f,  0.93587f,  0.94022f,  0.94443f,
   0.94851f,  0.95244f,  0.95623f,  0.95987f,  0.96336f,  0.96670f,  0.96989f,
   0.97293f,  0.97582f,  0.97854f,  0.98111f,  0.98352f,  0.98578f,  0.98786f,
   0.98979f,  0.99155f,  0.99315f,  0.99459f,  0.99585f,  0.99695f,  0.99788f,
   0.99864f,  0.99924f,  0.99966f,  0.99992f,  1.00000f},
   //---------  0.03 GeV
  {0.00008f,  0.00032f,  0.00073f,  0.00129f,  0.00201f,  0.00289f,  0.00393f,
   0.00513f,  0.00649f,  0.00801f,  0.00968f,  0.01150f,  0.01348f,  0.01561f,
   0.01790f,  0.02033f,  0.02291f,  0.02564f,  0.02852f,  0.03154f,  0.03470f,
   0.03801f,  0.04145f,  0.04503f,  0.04875f,  0.05261f,  0.05659f,  0.06071f,
   0.06495f,  0.06932f,  0.07382f,  0.07844f,  0.08318f,  0.08804f,  0.09302f,
   0.09811f,  0.10331f,  0.10863f,  0.11405f,  0.11958f,  0.12522f,  0.13096f,
   0.13679f,  0.14273f,  0.14876f,  0.15489f,  0.16111f,  0.16742f,  0.17382f,
   0.18030f,  0.18687f,  0.19352f,  0.20025f,  0.20705f,  0.21394f,  0.22089f,
   0.22792f,  0.23501f,  0.24218f,  0.24941f,  0.25670f,  0.26405f,  0.27147f,
   0.27894f,  0.28646f,  0.29404f,  0.30167f,  0.30935f,  0.31708f,  0.32486f,
   0.33268f,  0.34054f,  0.34844f,  0.35638f,  0.36435f,  0.37236f,  0.38040f,
   0.38848f,  0.39658f,  0.40471f,  0.41286f,  0.42104f,  0.42924f,  0.43746f,
   0.44569f,  0.45395f,  0.46221f,  0.47049f,  0.47878f,  0.48708f,  0.49538f,
   0.50369f,  0.51201f,  0.52032f,  0.52863f,  0.53694f,  0.54524f,  0.55354f,
   0.56183f,  0.57010f,  0.57837f,  0.58662f,  0.59485f,  0.60306f,  0.61125f,
   0.61942f,  0.62756f,  0.63568f,  0.64377f,  0.65182f,  0.65984f,  0.66783f,
   0.67577f,  0.68368f,  0.69155f,  0.69937f,  0.70714f,  0.71486f,  0.72253f,
   0.73015f,  0.73772f,  0.74522f,  0.75267f,  0.76005f,  0.76737f,  0.77462f,
   0.78180f,  0.78891f,  0.79594f,  0.80290f,  0.80978f,  0.81658f,  0.82329f,
   0.82993f,  0.83647f,  0.84292f,  0.84928f,  0.85554f,  0.86171f,  0.86777f,
   0.87374f,  0.87960f,  0.88535f,  0.89099f,  0.89652f,  0.90194f,  0.90724f,
   0.91242f,  0.91747f,  0.92241f,  0.92721f,  0.93188f,  0.93643f,  0.94083f,
   0.94510f,  0.94923f,  0.95322f,  0.95706f,  0.96075f,  0.96429f,  0.96767f,
   0.97091f,  0.97398f,  0.97689f,  0.97964f,  0.98222f,  0.98464f,  0.98688f,
   0.98896f,  0.99086f,  0.99258f,  0.99413f,  0.99550f,  0.99669f,  0.99770f,
   0.99853f,  0.99917f,  0.99963f,  0.99991f,  1.00000f},
   //---------  0.05 GeV
  {0.00010f,  0.00040f,  0.00089f,  0.00157f,  0.00245f,  0.00352f,  0.00478f,
   0.00623f,  0.00787f,  0.00970f,  0.01170f,  0.01389f,  0.01626f,  0.01880f,
   0.02151f,  0.02439f,  0.02744f,  0.03065f,  0.03402f,  0.03754f,  0.04122f,
   0.04505f,  0.04902f,  0.05313f,  0.05738f,  0.06176f,  0.06628f,  0.07092f,
   0.07568f,  0.08057f,  0.08557f,  0.09068f,  0.09590f,  0.10123f,  0.10666f,
   0.11219f,  0.11781f,  0.12353f,  0.12933f,  0.13522f,  0.14119f,  0.14725f,
   0.15337f,  0.15957f,  0.16585f,  0.17218f,  0.17859f,  0.18505f,  0.19157f,
   0.19816f,  0.20479f,  0.21148f,  0.21821f,  0.22499f,  0.23182f,  0.23869f,
   0.24560f,  0.25255f,  0.25953f,  0.26655f,  0.27361f,  0.28069f,  0.28781f,
   0.29495f,  0.30212f,  0.30932f,  0.31654f,  0.32378f,  0.33105f,  0.33834f,
   0.34565f,  0.35298f,  0.36032f,  0.36769f,  0.37507f,  0.38247f,  0.38988f,
   0.39731f,  0.40476f,  0.41221f,  0.41968f,  0.42717f,  0.43466f,  0.44217f,
   0.44969f,  0.45722f,  0.46476f,  0.47231f,  0.47987f,  0.48744f,  0.49501f,
   0.50260f,  0.51019f,  0.51778f,  0.52539f,  0.53300f,  0.54061f,  0.54823f,
   0.55584f,  0.56347f,  0.57109f,  0.57871f,  0.58633f,  0.59395f,  0.60157f,
   0.60918f,  0.61678f,  0.62438f,  0.63197f,  0.63955f,  0.64711f,  0.65467f,
   0.66221f,  0.66973f,  0.67723f,  0.68472f,  0.69218f,  0.69961f,  0.70702f,
   0.71440f,  0.72175f,  0.72907f,  0.73635f,  0.74360f,  0.75080f,  0.75796f,
   0.76508f,  0.77215f,  0.77918f,  0.78615f,  0.79306f,  0.79992f,  0.80672f,
   0.81346f,  0.82013f,  0.82674f,  0.83328f,  0.83974f,  0.84613f,  0.85244f,
   0.85867f,  0.86482f,  0.87088f,  0.87685f,  0.88273f,  0.88851f,  0.89420f,
   0.89978f,  0.90526f,  0.91063f,  0.91589f,  0.92103f,  0.92605f,  0.93095f,
   0.93572f,  0.94036f,  0.94487f,  0.94923f,  0.95345f,  0.95751f,  0.96143f,
   0.96518f,  0.96876f,  0.97218f,  0.97542f,  0.97849f,  0.98136f,  0.98405f,
   0.98654f,  0.98884f,  0.99093f,  0.99281f,  0.99448f,  0.99593f,  0.99717f,
   0.99819f,  0.99898f,  0.99955f,  0.99989f,  1.00000f},
   //---------  0.07 GeV
  {0.00012f,  0.00048f,  0.00108f,  0.00191f,  0.00298f,  0.00427f,  0.00580f,
   0.00755f,  0.00952f,  0.01171f,  0.01412f,  0.01673f,  0.01954f,  0.02256f,
   0.02577f,  0.02916f,  0.03274f,  0.03649f,  0.04041f,  0.04450f,  0.04874f,
   0.05314f,  0.05768f,  0.06237f,  0.06719f,  0.07214f,  0.07722f,  0.08241f,
   0.08772f,  0.09313f,  0.09865f,  0.10426f,  0.10996f,  0.11575f,  0.12162f,
   0.12757f,  0.13359f,  0.13968f,  0.14583f,  0.15204f,  0.15830f,  0.16462f,
   0.17098f,  0.17738f,  0.18382f,  0.19029f,  0.19679f,  0.20333f,  0.20988f,
   0.21646f,  0.22306f,  0.22968f,  0.23630f,  0.24294f,  0.24959f,  0.25625f,
   0.26291f,  0.26958f,  0.27625f,  0.28291f,  0.28958f,  0.29625f,  0.30292f,
   0.30958f,  0.31624f,  0.32290f,  0.32955f,  0.33620f,  0.34284f,  0.34948f,
   0.35612f,  0.36275f,  0.36939f,  0.37601f,  0.38264f,  0.38927f,  0.39589f,
   0.40252f,  0.40915f,  0.41578f,  0.42241f,  0.42905f,  0.43570f,  0.44235f,
   0.44901f,  0.45568f,  0.46237f,  0.46906f,  0.47576f,  0.48248f,  0.48922f,
   0.49597f,  0.50274f,  0.50952f,  0.51633f,  0.52315f,  0.53000f,  0.53686f,
   0.54375f,  0.55066f,  0.55759f,  0.56454f,  0.57152f,  0.57851f,  0.58553f,
   0.59257f,  0.59963f,  0.60671f,  0.61381f,  0.62093f,  0.62807f,  0.63523f,
   0.64239f,  0.64958f,  0.65677f,  0.66398f,  0.67119f,  0.67841f,  0.68564f,
   0.69286f,  0.70009f,  0.70731f,  0.71453f,  0.72174f,  0.72894f,  0.73613f,
   0.74329f,  0.75044f,  0.75757f,  0.76467f,  0.77174f,  0.77879f,  0.78579f,
   0.79276f,  0.79968f,  0.80656f,  0.81340f,  0.82018f,  0.82690f,  0.83357f,
   0.84018f,  0.84672f,  0.85320f,  0.85960f,  0.86593f,  0.87218f,  0.87835f,
   0.88443f,  0.89042f,  0.89632f,  0.90212f,  0.90782f,  0.91341f,  0.91890f,
   0.92426f,  0.92950f,  0.93462f,  0.93960f,  0.94443f,  0.94913f,  0.95366f,
   0.95804f,  0.96225f,  0.96628f,  0.97012f,  0.97377f,  0.97722f,  0.98045f,
   0.98347f,  0.98625f,  0.98880f,  0.99111f,  0.99316f,  0.99495f,  0.99648f,
   0.99774f,  0.99873f,  0.99943f,  0.99986f,  1.00000f},
   //---------  0.10 GeV
  {0.00015f,  0.00060f,  0.00133f,  0.00235f,  0.00366f,  0.00524f,  0.00710f,
   0.00923f,  0.01162f,  0.01427f,  0.01716f,  0.02030f,  0.02366f,  0.02724f,
   0.03104f,  0.03503f,  0.03922f,  0.04360f,  0.04815f,  0.05287f,  0.05775f,
   0.06278f,  0.06795f,  0.07325f,  0.07868f,  0.08423f,  0.08988f,  0.09563f,
   0.10148f,  0.10742f,  0.11343f,  0.11951f,  0.12567f,  0.13187f,  0.13813f,
   0.14444f,  0.15078f,  0.15716f,  0.16357f,  0.17000f,  0.17644f,  0.18290f,
   0.18936f,  0.19582f,  0.20228f,  0.20874f,  0.21519f,  0.22162f,  0.22803f,
   0.23442f,  0.24080f,  0.24714f,  0.25346f,  0.25974f,  0.26600f,  0.27222f,
   0.27841f,  0.28456f,  0.29068f,  0.29676f,  0.30280f,  0.30881f,  0.31478f,
   0.32071f,  0.32661f,  0.33247f,  0.33830f,  0.34410f,  0.34987f,  0.35560f,
   0.36131f,  0.36700f,  0.37266f,  0.37830f,  0.38392f,  0.38953f,  0.39512f,
   0.40070f,  0.40628f,  0.41185f,  0.41741f,  0.42298f,  0.42856f,  0.43414f,
   0.43973f,  0.44533f,  0.45095f,  0.45659f,  0.46226f,  0.46795f,  0.47367f,
   0.47942f,  0.48520f,  0.49102f,  0.49689f,  0.50279f,  0.50874f,  0.51474f,
   0.52078f,  0.52688f,  0.53303f,  0.53924f,  0.54550f,  0.55181f,  0.55819f,
   0.56462f,  0.57111f,  0.57766f,  0.58427f,  0.59094f,  0.59767f,  0.60445f,
   0.61129f,  0.61819f,  0.62514f,  0.63215f,  0.63920f,  0.64631f,  0.65346f,
   0.66065f,  0.66789f,  0.67516f,  0.68246f,  0.68980f,  0.69717f,  0.70455f,
   0.71196f,  0.71938f,  0.72681f,  0.73425f,  0.74169f,  0.74913f,  0.75656f,
   0.76398f,  0.77138f,  0.77876f,  0.78611f,  0.79344f,  0.80072f,  0.80797f,
   0.81517f,  0.82232f,  0.82942f,  0.83646f,  0.84343f,  0.85034f,  0.85718f,
   0.86395f,  0.87063f,  0.87724f,  0.88375f,  0.89017f,  0.89650f,  0.90273f,
   0.90885f,  0.91485f,  0.92074f,  0.92650f,  0.93213f,  0.93762f,  0.94297f,
   0.94815f,  0.95316f,  0.95800f,  0.96264f,  0.96707f,  0.97129f,  0.97528f,
   0.97902f,  0.98250f,  0.98570f,  0.98861f,  0.99122f,  0.99351f,  0.99547f,
   0.99708f,  0.99835f,  0.99927f,  0.99982f,  1.00000f},
   //---------  0.14 GeV
  {0.00018f,  0.00069f,  0.00154f,  0.00271f,  0.00421f,  0.00603f,  0.00816f,
   0.01058f,  0.01329f,  0.01628f,  0.01953f,  0.02304f,  0.02678f,  0.03075f,
   0.03494f,  0.03933f,  0.04391f,  0.04867f,  0.05360f,  0.05868f,  0.06391f,
   0.06928f,  0.07478f,  0.08039f,  0.08611f,  0.09193f,  0.09784f,  0.10383f,
   0.10989f,  0.11602f,  0.12220f,  0.12843f,  0.13470f,  0.14101f,  0.14734f,
   0.15369f,  0.16005f,  0.16642f,  0.17279f,  0.17915f,  0.18550f,  0.19183f,
   0.19815f,  0.20443f,  0.21069f,  0.21690f,  0.22309f,  0.22922f,  0.23532f,
   0.24136f,  0.24736f,  0.25330f,  0.25919f,  0.26502f,  0.27079f,  0.27651f,
   0.28217f,  0.28777f,  0.29331f,  0.29879f,  0.30421f,  0.30958f,  0.31489f,
   0.32015f,  0.32536f,  0.33051f,  0.33562f,  0.34068f,  0.34569f,  0.35067f,
   0.35561f,  0.36051f,  0.36538f,  0.37022f,  0.37504f,  0.37984f,  0.38462f,
   0.38939f,  0.39414f,  0.39890f,  0.40365f,  0.40840f,  0.41316f,  0.41794f,
   0.42273f,  0.42754f,  0.43237f,  0.43723f,  0.44213f,  0.44706f,  0.45204f,
   0.45706f,  0.46213f,  0.46725f,  0.47243f,  0.47768f,  0.48298f,  0.48836f,
   0.49380f,  0.49933f,  0.50492f,  0.51060f,  0.51636f,  0.52221f,  0.52814f,
   0.53416f,  0.54027f,  0.54647f,  0.55277f,  0.55915f,  0.56563f,  0.57221f,
   0.57887f,  0.58563f,  0.59248f,  0.59941f,  0.60644f,  0.61355f,  0.62075f,
   0.62803f,  0.63538f,  0.64281f,  0.65031f,  0.65788f,  0.66551f,  0.67320f,
   0.68094f,  0.68873f,  0.69656f,  0.70443f,  0.71233f,  0.72025f,  0.72819f,
   0.73614f,  0.74409f,  0.75205f,  0.75999f,  0.76792f,  0.77583f,  0.78370f,
   0.79155f,  0.79935f,  0.80710f,  0.81480f,  0.82244f,  0.83001f,  0.83752f,
   0.84495f,  0.85230f,  0.85956f,  0.86674f,  0.87382f,  0.88080f,  0.88769f,
   0.89446f,  0.90113f,  0.90769f,  0.91412f,  0.92043f,  0.92660f,  0.93263f,
   0.93852f,  0.94424f,  0.94978f,  0.95514f,  0.96030f,  0.96524f,  0.96994f,
   0.97438f,  0.97854f,  0.98240f,  0.98593f,  0.98912f,  0.99193f,  0.99435f,
   0.99636f,  0.99794f,  0.99908f,  0.99977f,  1.00000f},
   //---------  0.18 GeV
  {0.00019f,  0.00073f,  0.00162f,  0.00286f,  0.00444f,  0.00635f,  0.00857f,
   0.01110f,  0.01391f,  0.01701f,  0.02036f,  0.02396f,  0.02779f,  0.03185f,
   0.03610f,  0.04055f,  0.04518f,  0.04998f,  0.05494f,  0.06004f,  0.06528f,
   0.07065f,  0.07613f,  0.08172f,  0.08741f,  0.09319f,  0.09906f,  0.10499f,
   0.11099f,  0.11705f,  0.12316f,  0.12931f,  0.13550f,  0.14171f,  0.14794f,
   0.15419f,  0.16045f,  0.16670f,  0.17296f,  0.17920f,  0.18543f,  0.19163f,
   0.19781f,  0.20396f,  0.21008f,  0.21615f,  0.22219f,  0.22817f,  0.23411f,
   0.24000f,  0.24584f,  0.25162f,  0.25734f,  0.26300f,  0.26861f,  0.27415f,
   0.27963f,  0.28505f,  0.29041f,  0.29571f,  0.30094f,  0.30612f,  0.31124f,
   0.31630f,  0.32131f,  0.32627f,  0.33117f,  0.33603f,  0.34084f,  0.34560f,
   0.35033f,  0.35502f,  0.35968f,  0.36430f,  0.36890f,  0.37348f,  0.37804f,
   0.38258f,  0.38711f,  0.39163f,  0.39615f,  0.40067f,  0.40520f,  0.40974f,
   0.41429f,  0.41886f,  0.42345f,  0.42808f,  0.43273f,  0.43742f,  0.44215f,
   0.44693f,  0.45175f,  0.45663f,  0.46156f,  0.46656f,  0.47163f,  0.47676f,
   0.48197f,  0.48725f,  0.49261f,  0.49806f,  0.50359f,  0.50921f,  0.51493f,
   0.52074f,  0.52664f,  0.53265f,  0.53875f,  0.54496f,  0.55127f,  0.55768f,
   0.56420f,  0.57082f,  0.57755f,  0.58439f,  0.59132f,  0.59836f,  0.60550f,
   0.61274f,  0.62008f,  0.62751f,  0.63503f,  0.64264f,  0.65033f,  0.65810f,
   0.66594f,  0.67385f,  0.68182f,  0.68985f,  0.69793f,  0.70606f,  0.71422f,
   0.72240f,  0.73061f,  0.73884f,  0.74706f,  0.75529f,  0.76350f,  0.77170f,
   0.77987f,  0.78800f,  0.79609f,  0.80412f,  0.81210f,  0.82001f,  0.82785f,
   0.83561f,  0.84329f,  0.85087f,  0.85836f,  0.86575f,  0.87303f,  0.88021f,
   0.88727f,  0.89422f,  0.90105f,  0.90776f,  0.91435f,  0.92080f,  0.92712f,
   0.93329f,  0.93931f,  0.94517f,  0.95086f,  0.95636f,  0.96165f,  0.96672f,
   0.97153f,  0.97607f,  0.98030f,  0.98420f,  0.98774f,  0.99088f,  0.99360f,
   0.99587f,  0.99766f,  0.99895f,  0.99974f,  1.00000f},
   //---------  0.24 GeV
  {0.00019f,  0.00074f,  0.00163f,  0.00288f,  0.00445f,  0.00635f,  0.00855f,
   0.01104f,  0.01381f,  0.01683f,  0.02010f,  0.02360f,  0.02732f,  0.03123f,
   0.03534f,  0.03962f,  0.04408f,  0.04869f,  0.05346f,  0.05837f,  0.06341f,
   0.06858f,  0.07388f,  0.07929f,  0.08480f,  0.09042f,  0.09613f,  0.10192f,
   0.10780f,  0.11374f,  0.11976f,  0.12583f,  0.13196f,  0.13813f,  0.14434f,
   0.15058f,  0.15686f,  0.16315f,  0.16945f,  0.17577f,  0.18208f,  0.18840f,
   0.19470f,  0.20099f,  0.20727f,  0.21352f,  0.21974f,  0.22593f,  0.23208f,
   0.23819f,  0.24426f,  0.25029f,  0.25626f,  0.26219f,  0.26805f,  0.27387f,
   0.27962f,  0.28532f,  0.29095f,  0.29653f,  0.30205f,  0.30750f,  0.31290f,
   0.31824f,  0.32351f,  0.32873f,  0.33390f,  0.33901f,  0.34407f,  0.34907f,
   0.35403f,  0.35895f,  0.36382f,  0.36865f,  0.37344f,  0.37820f,  0.38294f,
   0.38764f,  0.39232f,  0.39698f,  0.40163f,  0.40626f,  0.41089f,  0.41551f,
   0.42013f,  0.42475f,  0.42939f,  0.43403f,  0.43869f,  0.44337f,  0.44807f,
   0.45280f,  0.45757f,  0.46236f,  0.46720f,  0.47208f,  0.47701f,  0.48199f,
   0.48703f,  0.49213f,  0.49729f,  0.50251f,  0.50781f,  0.51318f,  0.51862f,
   0.52415f,  0.52976f,  0.53545f,  0.54124f,  0.54712f,  0.55309f,  0.55916f,
   0.56532f,  0.57159f,  0.57796f,  0.58443f,  0.59101f,  0.59769f,  0.60448f,
   0.61137f,  0.61837f,  0.62547f,  0.63267f,  0.63997f,  0.64737f,  0.65486f,
   0.66245f,  0.67012f,  0.67788f,  0.68571f,  0.69362f,  0.70159f,  0.70962f,
   0.71770f,  0.72583f,  0.73400f,  0.74220f,  0.75041f,  0.75864f,  0.76687f,
   0.77509f,  0.78329f,  0.79146f,  0.79960f,  0.80768f,  0.81571f,  0.82368f,
   0.83157f,  0.83937f,  0.84708f,  0.85470f,  0.86220f,  0.86960f,  0.87688f,
   0.88403f,  0.89106f,  0.89797f,  0.90474f,  0.91138f,  0.91788f,  0.92425f,
   0.93048f,  0.93656f,  0.94249f,  0.94827f,  0.95387f,  0.95929f,  0.96451f,
   0.96950f,  0.97424f,  0.97870f,  0.98284f,  0.98662f,  0.99001f,  0.99296f,
   0.99544f,  0.99741f,  0.99884f,  0.99971f,  1.00000f},
   //---------  0.34 GeV
  {0.00019f,  0.00072f,  0.00159f,  0.00279f,  0.00431f,  0.00612f,  0.00823f,
   0.01060f,  0.01322f,  0.01608f,  0.01917f,  0.02247f,  0.02598f,  0.02969f,
   0.03359f,  0.03768f,  0.04195f,  0.04641f,  0.05104f,  0.05584f,  0.06082f,
   0.06596f,  0.07126f,  0.07673f,  0.08235f,  0.08811f,  0.09403f,  0.10008f,
   0.10626f,  0.11257f,  0.11900f,  0.12554f,  0.13219f,  0.13893f,  0.14576f,
   0.15267f,  0.15965f,  0.16669f,  0.17379f,  0.18094f,  0.18812f,  0.19533f,
   0.20257f,  0.20981f,  0.21706f,  0.22430f,  0.23153f,  0.23874f,  0.24592f,
   0.25307f,  0.26017f,  0.26724f,  0.27424f,  0.28120f,  0.28808f,  0.29491f,
   0.30166f,  0.30834f,  0.31494f,  0.32147f,  0.32791f,  0.33427f,  0.34055f,
   0.34674f,  0.35285f,  0.35888f,  0.36483f,  0.37069f,  0.37647f,  0.38217f,
   0.38779f,  0.39334f,  0.39882f,  0.40422f,  0.40956f,  0.41483f,  0.42004f,
   0.42519f,  0.43028f,  0.43532f,  0.44031f,  0.44525f,  0.45015f,  0.45501f,
   0.45984f,  0.46463f,  0.46940f,  0.47414f,  0.47886f,  0.48356f,  0.48825f,
   0.49292f,  0.49759f,  0.50226f,  0.50693f,  0.51160f,  0.51629f,  0.52098f,
   0.52568f,  0.53041f,  0.53516f,  0.53994f,  0.54474f,  0.54958f,  0.55446f,
   0.55937f,  0.56434f,  0.56935f,  0.57441f,  0.57953f,  0.58471f,  0.58996f,
   0.59527f,  0.60065f,  0.60611f,  0.61165f,  0.61727f,  0.62297f,  0.62877f,
   0.63465f,  0.64063f,  0.64670f,  0.65287f,  0.65914f,  0.66552f,  0.67199f,
   0.67857f,  0.68525f,  0.69202f,  0.69890f,  0.70588f,  0.71295f,  0.72011f,
   0.72736f,  0.73469f,  0.74209f,  0.74957f,  0.75711f,  0.76470f,  0.77233f,
   0.78001f,  0.78771f,  0.79542f,  0.80314f,  0.81086f,  0.81855f,  0.82621f,
   0.83383f,  0.84140f,  0.84889f,  0.85631f,  0.86365f,  0.87088f,  0.87800f,
   0.88500f,  0.89188f,  0.89864f,  0.90525f,  0.91173f,  0.91806f,  0.92425f,
   0.93030f,  0.93621f,  0.94197f,  0.94758f,  0.95304f,  0.95835f,  0.96348f,
   0.96843f,  0.97316f,  0.97766f,  0.98188f,  0.98579f,  0.98932f,  0.99244f,
   0.99508f,  0.99719f,  0.99874f,  0.99968f,  1.00000f},
   //---------  0.42 GeV
  {0.00020f,  0.00075f,  0.00165f,  0.00289f,  0.00445f,  0.00633f,  0.00849f,
   0.01094f,  0.01364f,  0.01660f,  0.01979f,  0.02322f,  0.02688f,  0.03077f,
   0.03487f,  0.03920f,  0.04375f,  0.04852f,  0.05350f,  0.05870f,  0.06411f,
   0.06973f,  0.07556f,  0.08159f,  0.08782f,  0.09423f,  0.10084f,  0.10761f,
   0.11456f,  0.12167f,  0.12893f,  0.13633f,  0.14386f,  0.15152f,  0.15928f,
   0.16715f,  0.17510f,  0.18313f,  0.19123f,  0.19938f,  0.20757f,  0.21580f,
   0.22404f,  0.23229f,  0.24054f,  0.24877f,  0.25698f,  0.26515f,  0.27328f,
   0.28135f,  0.28937f,  0.29732f,  0.30519f,  0.31298f,  0.32068f,  0.32829f,
   0.33580f,  0.34320f,  0.35051f,  0.35771f,  0.36479f,  0.37177f,  0.37864f,
   0.38539f,  0.39204f,  0.39857f,  0.40499f,  0.41131f,  0.41751f,  0.42362f,
   0.42962f,  0.43551f,  0.44132f,  0.44702f,  0.45264f,  0.45816f,  0.46361f,
   0.46896f,  0.47424f,  0.47945f,  0.48458f,  0.48964f,  0.49464f,  0.49958f,
   0.50446f,  0.50928f,  0.51405f,  0.51878f,  0.52345f,  0.52809f,  0.53269f,
   0.53725f,  0.54178f,  0.54628f,  0.55076f,  0.55521f,  0.55965f,  0.56407f,
   0.56847f,  0.57287f,  0.57726f,  0.58165f,  0.58604f,  0.59044f,  0.59484f,
   0.59925f,  0.60368f,  0.60813f,  0.61260f,  0.61710f,  0.62163f,  0.62620f,
   0.63080f,  0.63545f,  0.64015f,  0.64490f,  0.64970f,  0.65457f,  0.65950f,
   0.66450f,  0.66958f,  0.67473f,  0.67997f,  0.68529f,  0.69070f,  0.69620f,
   0.70179f,  0.70749f,  0.71328f,  0.71917f,  0.72516f,  0.73126f,  0.73745f,
   0.74374f,  0.75014f,  0.75662f,  0.76320f,  0.76987f,  0.77661f,  0.78343f,
   0.79032f,  0.79727f,  0.80427f,  0.81131f,  0.81839f,  0.82548f,  0.83258f,
   0.83967f,  0.84675f,  0.85380f,  0.86081f,  0.86776f,  0.87464f,  0.88144f,
   0.88815f,  0.89475f,  0.90125f,  0.90762f,  0.91386f,  0.91997f,  0.92594f,
   0.93177f,  0.93746f,  0.94301f,  0.94842f,  0.95368f,  0.95880f,  0.96376f,
   0.96855f,  0.97316f,  0.97757f,  0.98173f,  0.98560f,  0.98913f,  0.99227f,
   0.99495f,  0.99711f,  0.99870f,  0.99967f,  1.00000f},
   //---------  0.50 GeV
  {0.00023f,  0.00086f,  0.00190f,  0.00333f,  0.00513f,  0.00729f,  0.00979f,
   0.01261f,  0.01574f,  0.01917f,  0.02288f,  0.02688f,  0.03115f,  0.03570f,
   0.04053f,  0.04562f,  0.05098f,  0.05661f,  0.06251f,  0.06866f,  0.07507f,
   0.08173f,  0.08863f,  0.09577f,  0.10314f,  0.11072f,  0.11851f,  0.12650f,
   0.13468f,  0.14303f,  0.15154f,  0.16020f,  0.16900f,  0.17791f,  0.18693f,
   0.19605f,  0.20524f,  0.21449f,  0.22379f,  0.23312f,  0.24247f,  0.25182f,
   0.26117f,  0.27048f,  0.27977f,  0.28900f,  0.29818f,  0.30728f,  0.31630f,
   0.32523f,  0.33406f,  0.34278f,  0.35138f,  0.35987f,  0.36823f,  0.37645f,
   0.38454f,  0.39250f,  0.40031f,  0.40798f,  0.41551f,  0.42289f,  0.43013f,
   0.43723f,  0.44419f,  0.45101f,  0.45769f,  0.46424f,  0.47065f,  0.47694f,
   0.48310f,  0.48913f,  0.49505f,  0.50085f,  0.50654f,  0.51212f,  0.51759f,
   0.52297f,  0.52824f,  0.53342f,  0.53852f,  0.54352f,  0.54845f,  0.55329f,
   0.55806f,  0.56276f,  0.56739f,  0.57195f,  0.57645f,  0.58089f,  0.58528f,
   0.58961f,  0.59390f,  0.59814f,  0.60233f,  0.60648f,  0.61060f,  0.61468f,
   0.61873f,  0.62275f,  0.62675f,  0.63072f,  0.63467f,  0.63861f,  0.64253f,
   0.64645f,  0.65035f,  0.65426f,  0.65816f,  0.66207f,  0.66598f,  0.66991f,
   0.67385f,  0.67781f,  0.68180f,  0.68581f,  0.68985f,  0.69393f,  0.69806f,
   0.70222f,  0.70644f,  0.71071f,  0.71505f,  0.71944f,  0.72391f,  0.72844f,
   0.73306f,  0.73776f,  0.74254f,  0.74741f,  0.75237f,  0.75742f,  0.76257f,
   0.76782f,  0.77317f,  0.77862f,  0.78416f,  0.78980f,  0.79553f,  0.80136f,
   0.80727f,  0.81327f,  0.81934f,  0.82548f,  0.83168f,  0.83794f,  0.84423f,
   0.85056f,  0.85690f,  0.86325f,  0.86960f,  0.87592f,  0.88222f,  0.88846f,
   0.89465f,  0.90076f,  0.90678f,  0.91271f,  0.91853f,  0.92424f,  0.92982f,
   0.93528f,  0.94061f,  0.94580f,  0.95086f,  0.95579f,  0.96058f,  0.96523f,
   0.96973f,  0.97408f,  0.97825f,  0.98221f,  0.98592f,  0.98933f,  0.99238f,
   0.99500f,  0.99713f,  0.99871f,  0.99967f,  1.00000f},
   //---------  0.58 GeV
  {0.00029f,  0.00110f,  0.00243f,  0.00427f,  0.00660f,  0.00938f,  0.01260f,
   0.01623f,  0.02027f,  0.02469f,  0.02948f,  0.03464f,  0.04015f,  0.04601f,
   0.05222f,  0.05876f,  0.06564f,  0.07283f,  0.08034f,  0.08815f,  0.09626f,
   0.10465f,  0.11331f,  0.12223f,  0.13138f,  0.14077f,  0.15037f,  0.16017f,
   0.17014f,  0.18027f,  0.19055f,  0.20096f,  0.21147f,  0.22207f,  0.23275f,
   0.24347f,  0.25423f,  0.26500f,  0.27577f,  0.28652f,  0.29723f,  0.30789f,
   0.31847f,  0.32897f,  0.33938f,  0.34967f,  0.35984f,  0.36987f,  0.37975f,
   0.38948f,  0.39905f,  0.40845f,  0.41767f,  0.42671f,  0.43556f,  0.44423f,
   0.45271f,  0.46099f,  0.46909f,  0.47699f,  0.48471f,  0.49223f,  0.49957f,
   0.50673f,  0.51371f,  0.52051f,  0.52714f,  0.53360f,  0.53989f,  0.54603f,
   0.55201f,  0.55785f,  0.56354f,  0.56908f,  0.57450f,  0.57978f,  0.58494f,
   0.58997f,  0.59489f,  0.59970f,  0.60440f,  0.60900f,  0.61350f,  0.61790f,
   0.62221f,  0.62644f,  0.63059f,  0.63465f,  0.63865f,  0.64257f,  0.64643f,
   0.65022f,  0.65395f,  0.65763f,  0.66125f,  0.66483f,  0.66836f,  0.67184f,
   0.67529f,  0.67870f,  0.68208f,  0.68543f,  0.68876f,  0.69206f,  0.69534f,
   0.69860f,  0.70185f,  0.70509f,  0.70832f,  0.71155f,  0.71478f,  0.71802f,
   0.72126f,  0.72451f,  0.72777f,  0.73105f,  0.73436f,  0.73769f,  0.74105f,
   0.74444f,  0.74787f,  0.75134f,  0.75486f,  0.75843f,  0.76206f,  0.76575f,
   0.76949f,  0.77331f,  0.77720f,  0.78116f,  0.78520f,  0.78933f,  0.79354f,
   0.79784f,  0.80222f,  0.80670f,  0.81128f,  0.81594f,  0.82070f,  0.82555f,
   0.83049f,  0.83552f,  0.84064f,  0.84583f,  0.85110f,  0.85643f,  0.86182f,
   0.86726f,  0.87274f,  0.87825f,  0.88378f,  0.88931f,  0.89484f,  0.90034f,
   0.90581f,  0.91122f,  0.91657f,  0.92185f,  0.92703f,  0.93212f,  0.93710f,
   0.94196f,  0.94671f,  0.95132f,  0.95582f,  0.96018f,  0.96443f,  0.96855f,
   0.97254f,  0.97640f,  0.98011f,  0.98366f,  0.98701f,  0.99011f,  0.99290f,
   0.99532f,  0.99731f,  0.99878f,  0.99969f,  1.00000f},
   //---------  0.62 GeV
  {0.00033f,  0.00125f,  0.00277f,  0.00487f,  0.00752f,  0.01069f,  0.01436f,
   0.01850f,  0.02311f,  0.02815f,  0.03361f,  0.03949f,  0.04576f,  0.05243f,
   0.05948f,  0.06691f,  0.07469f,  0.08283f,  0.09130f,  0.10010f,  0.10920f,
   0.11860f,  0.12828f,  0.13822f,  0.14841f,  0.15881f,  0.16943f,  0.18023f,
   0.19119f,  0.20230f,  0.21354f,  0.22488f,  0.23630f,  0.24779f,  0.25931f,
   0.27086f,  0.28241f,  0.29393f,  0.30542f,  0.31686f,  0.32821f,  0.33948f,
   0.35063f,  0.36166f,  0.37255f,  0.38329f,  0.39387f,  0.40427f,  0.41448f,
   0.42451f,  0.43433f,  0.44395f,  0.45335f,  0.46254f,  0.47151f,  0.48026f,
   0.48880f,  0.49711f,  0.50520f,  0.51307f,  0.52073f,  0.52818f,  0.53541f,
   0.54245f,  0.54928f,  0.55592f,  0.56236f,  0.56862f,  0.57470f,  0.58061f,
   0.58635f,  0.59192f,  0.59734f,  0.60260f,  0.60772f,  0.61270f,  0.61754f,
   0.62225f,  0.62684f,  0.63131f,  0.63566f,  0.63990f,  0.64404f,  0.64808f,
   0.65203f,  0.65588f,  0.65965f,  0.66334f,  0.66695f,  0.67049f,  0.67396f,
   0.67736f,  0.68071f,  0.68399f,  0.68723f,  0.69042f,  0.69356f,  0.69666f,
   0.69973f,  0.70276f,  0.70576f,  0.70874f,  0.71169f,  0.71462f,  0.71753f,
   0.72043f,  0.72332f,  0.72620f,  0.72908f,  0.73195f,  0.73483f,  0.73772f,
   0.74062f,  0.74353f,  0.74645f,  0.74939f,  0.75236f,  0.75535f,  0.75838f,
   0.76143f,  0.76453f,  0.76767f,  0.77085f,  0.77408f,  0.77736f,  0.78070f,
   0.78410f,  0.78756f,  0.79110f,  0.79470f,  0.79838f,  0.80214f,  0.80598f,
   0.80990f,  0.81391f,  0.81801f,  0.82220f,  0.82648f,  0.83086f,  0.83532f,
   0.83988f,  0.84452f,  0.84925f,  0.85406f,  0.85895f,  0.86392f,  0.86894f,
   0.87403f,  0.87916f,  0.88433f,  0.88952f,  0.89474f,  0.89995f,  0.90515f,
   0.91032f,  0.91546f,  0.92054f,  0.92555f,  0.93049f,  0.93533f,  0.94007f,
   0.94470f,  0.94921f,  0.95360f,  0.95786f,  0.96201f,  0.96603f,  0.96993f,
   0.97371f,  0.97737f,  0.98090f,  0.98427f,  0.98746f,  0.99043f,  0.99312f,
   0.99546f,  0.99738f,  0.99881f,  0.99970f,  1.00000f},
   //---------  0.68 GeV
  {0.00038f,  0.00148f,  0.00327f,  0.00575f,  0.00888f,  0.01263f,  0.01698f,
   0.02189f,  0.02733f,  0.03330f,  0.03977f,  0.04672f,  0.05414f,  0.06201f,
   0.07032f,  0.07906f,  0.08819f,  0.09771f,  0.10760f,  0.11783f,  0.12839f,
   0.13924f,  0.15038f,  0.16178f,  0.17340f,  0.18524f,  0.19725f,  0.20943f,
   0.22173f,  0.23415f,  0.24665f,  0.25920f,  0.27179f,  0.28438f,  0.29697f,
   0.30951f,  0.32199f,  0.33439f,  0.34669f,  0.35887f,  0.37091f,  0.38279f,
   0.39449f,  0.40600f,  0.41732f,  0.42841f,  0.43928f,  0.44992f,  0.46031f,
   0.47046f,  0.48034f,  0.48997f,  0.49934f,  0.50844f,  0.51728f,  0.52586f,
   0.53418f,  0.54223f,  0.55003f,  0.55758f,  0.56489f,  0.57195f,  0.57877f,
   0.58536f,  0.59173f,  0.59789f,  0.60383f,  0.60957f,  0.61511f,  0.62047f,
   0.62564f,  0.63064f,  0.63546f,  0.64013f,  0.64464f,  0.64901f,  0.65323f,
   0.65732f,  0.66128f,  0.66512f,  0.66884f,  0.67245f,  0.67596f,  0.67937f,
   0.68269f,  0.68592f,  0.68907f,  0.69215f,  0.69515f,  0.69809f,  0.70097f,
   0.70379f,  0.70656f,  0.70928f,  0.71196f,  0.71460f,  0.71721f,  0.71978f,
   0.72233f,  0.72486f,  0.72737f,  0.72986f,  0.73234f,  0.73481f,  0.73728f,
   0.73974f,  0.74221f,  0.74467f,  0.74715f,  0.74963f,  0.75212f,  0.75463f,
   0.75715f,  0.75970f,  0.76227f,  0.76486f,  0.76748f,  0.77013f,  0.77282f,
   0.77554f,  0.77830f,  0.78110f,  0.78395f,  0.78685f,  0.78980f,  0.79281f,
   0.79587f,  0.79899f,  0.80218f,  0.80544f,  0.80877f,  0.81217f,  0.81565f,
   0.81921f,  0.82286f,  0.82659f,  0.83040f,  0.83431f,  0.83831f,  0.84240f,
   0.84658f,  0.85085f,  0.85521f,  0.85966f,  0.86419f,  0.86881f,  0.87350f,
   0.87825f,  0.88307f,  0.88794f,  0.89285f,  0.89779f,  0.90274f,  0.90771f,
   0.91266f,  0.91760f,  0.92249f,  0.92733f,  0.93211f,  0.93681f,  0.94141f,
   0.94592f,  0.95031f,  0.95459f,  0.95874f,  0.96278f,  0.96669f,  0.97048f,
   0.97416f,  0.97772f,  0.98115f,  0.98444f,  0.98757f,  0.99048f,  0.99313f,
   0.99546f,  0.99737f,  0.99881f,  0.99970f,  1.00000f},
   //---------  0.74 GeV
  {0.00043f,  0.00168f,  0.00373f,  0.00655f,  0.01012f,  0.01440f,  0.01935f,
   0.02495f,  0.03117f,  0.03798f,  0.04537f,  0.05330f,  0.06176f,  0.07073f,
   0.08018f,  0.09010f,  0.10045f,  0.11121f,  0.12235f,  0.13386f,  0.14569f,
   0.15782f,  0.17022f,  0.18285f,  0.19570f,  0.20873f,  0.22190f,  0.23519f,
   0.24856f,  0.26200f,  0.27546f,  0.28892f,  0.30236f,  0.31574f,  0.32905f,
   0.34225f,  0.35532f,  0.36824f,  0.38099f,  0.39355f,  0.40591f,  0.41803f,
   0.42992f,  0.44155f,  0.45292f,  0.46401f,  0.47482f,  0.48533f,  0.49555f,
   0.50547f,  0.51509f,  0.52440f,  0.53341f,  0.54212f,  0.55052f,  0.55863f,
   0.56645f,  0.57398f,  0.58123f,  0.58821f,  0.59492f,  0.60137f,  0.60757f,
   0.61353f,  0.61925f,  0.62475f,  0.63002f,  0.63509f,  0.63996f,  0.64464f,
   0.64913f,  0.65345f,  0.65761f,  0.66160f,  0.66545f,  0.66915f,  0.67272f,
   0.67616f,  0.67948f,  0.68269f,  0.68580f,  0.68880f,  0.69171f,  0.69454f,
   0.69729f,  0.69997f,  0.70258f,  0.70512f,  0.70762f,  0.71006f,  0.71246f,
   0.71482f,  0.71714f,  0.71943f,  0.72170f,  0.72395f,  0.72618f,  0.72840f,
   0.73060f,  0.73280f,  0.73500f,  0.73720f,  0.73941f,  0.74162f,  0.74384f,
   0.74607f,  0.74831f,  0.75057f,  0.75286f,  0.75516f,  0.75748f,  0.75983f,
   0.76221f,  0.76461f,  0.76705f,  0.76952f,  0.77202f,  0.77456f,  0.77713f,
   0.77975f,  0.78240f,  0.78510f,  0.78784f,  0.79063f,  0.79348f,  0.79637f,
   0.79932f,  0.80232f,  0.80538f,  0.80851f,  0.81170f,  0.81497f,  0.81830f,
   0.82170f,  0.82519f,  0.82875f,  0.83240f,  0.83613f,  0.83995f,  0.84386f,
   0.84785f,  0.85194f,  0.85612f,  0.86038f,  0.86474f,  0.86918f,  0.87370f,
   0.87829f,  0.88296f,  0.88769f,  0.89247f,  0.89730f,  0.90216f,  0.90704f,
   0.91193f,  0.91682f,  0.92168f,  0.92650f,  0.93127f,  0.93598f,  0.94061f,
   0.94514f,  0.94957f,  0.95389f,  0.95809f,  0.96217f,  0.96613f,  0.96997f,
   0.97368f,  0.97728f,  0.98075f,  0.98409f,  0.98726f,  0.99022f,  0.99293f,
   0.99531f,  0.99728f,  0.99877f,  0.99969f,  1.00000f},
   //---------  0.80 GeV
  {0.00048f,  0.00187f,  0.00414f,  0.00728f,  0.01125f,  0.01601f,  0.02152f,
   0.02775f,  0.03467f,  0.04225f,  0.05046f,  0.05928f,  0.06868f,  0.07863f,
   0.08910f,  0.10007f,  0.11150f,  0.12335f,  0.13560f,  0.14821f,  0.16114f,
   0.17435f,  0.18782f,  0.20150f,  0.21536f,  0.22936f,  0.24347f,  0.25764f,
   0.27186f,  0.28608f,  0.30027f,  0.31440f,  0.32844f,  0.34237f,  0.35615f,
   0.36976f,  0.38318f,  0.39638f,  0.40935f,  0.42206f,  0.43450f,  0.44666f,
   0.45851f,  0.47006f,  0.48128f,  0.49218f,  0.50275f,  0.51298f,  0.52287f,
   0.53242f,  0.54164f,  0.55052f,  0.55906f,  0.56728f,  0.57518f,  0.58275f,
   0.59002f,  0.59699f,  0.60366f,  0.61005f,  0.61617f,  0.62202f,  0.62761f,
   0.63296f,  0.63808f,  0.64296f,  0.64764f,  0.65210f,  0.65637f,  0.66046f,
   0.66436f,  0.66811f,  0.67169f,  0.67512f,  0.67841f,  0.68157f,  0.68461f,
   0.68753f,  0.69035f,  0.69306f,  0.69568f,  0.69822f,  0.70068f,  0.70307f,
   0.70539f,  0.70766f,  0.70987f,  0.71204f,  0.71417f,  0.71626f,  0.71833f,
   0.72037f,  0.72239f,  0.72440f,  0.72639f,  0.72838f,  0.73037f,  0.73236f,
   0.73436f,  0.73636f,  0.73838f,  0.74041f,  0.74246f,  0.74452f,  0.74661f,
   0.74873f,  0.75086f,  0.75303f,  0.75523f,  0.75745f,  0.75971f,  0.76200f,
   0.76433f,  0.76669f,  0.76909f,  0.77153f,  0.77400f,  0.77651f,  0.77907f,
   0.78166f,  0.78429f,  0.78697f,  0.78969f,  0.79245f,  0.79526f,  0.79812f,
   0.80103f,  0.80399f,  0.80700f,  0.81007f,  0.81320f,  0.81639f,  0.81964f,
   0.82296f,  0.82635f,  0.82981f,  0.83334f,  0.83696f,  0.84066f,  0.84444f,
   0.84831f,  0.85226f,  0.85630f,  0.86044f,  0.86466f,  0.86896f,  0.87336f,
   0.87783f,  0.88238f,  0.88701f,  0.89170f,  0.89644f,  0.90123f,  0.90605f,
   0.91089f,  0.91575f,  0.92059f,  0.92542f,  0.93020f,  0.93493f,  0.93959f,
   0.94417f,  0.94865f,  0.95303f,  0.95729f,  0.96143f,  0.96545f,  0.96935f,
   0.97312f,  0.97677f,  0.98030f,  0.98369f,  0.98691f,  0.98994f,  0.99271f,
   0.99516f,  0.99719f,  0.99872f,  0.99968f,  1.00000f},
   //---------  0.90 GeV
  {0.00056f,  0.00217f,  0.00482f,  0.00847f,  0.01308f,  0.01861f,  0.02502f,
   0.03227f,  0.04031f,  0.04912f,  0.05865f,  0.06887f,  0.07974f,  0.09123f,
   0.10329f,  0.11587f,  0.12895f,  0.14246f,  0.15636f,  0.17061f,  0.18515f,
   0.19995f,  0.21495f,  0.23011f,  0.24538f,  0.26072f,  0.27608f,  0.29143f,
   0.30673f,  0.32194f,  0.33703f,  0.35195f,  0.36668f,  0.38120f,  0.39547f,
   0.40947f,  0.42318f,  0.43658f,  0.44965f,  0.46238f,  0.47475f,  0.48676f,
   0.49839f,  0.50964f,  0.52050f,  0.53098f,  0.54108f,  0.55078f,  0.56011f,
   0.56906f,  0.57764f,  0.58586f,  0.59372f,  0.60123f,  0.60840f,  0.61525f,
   0.62178f,  0.62800f,  0.63392f,  0.63957f,  0.64494f,  0.65004f,  0.65490f,
   0.65952f,  0.66392f,  0.66809f,  0.67206f,  0.67584f,  0.67943f,  0.68285f,
   0.68611f,  0.68921f,  0.69217f,  0.69499f,  0.69768f,  0.70026f,  0.70273f,
   0.70511f,  0.70739f,  0.70958f,  0.71170f,  0.71376f,  0.71575f,  0.71768f,
   0.71958f,  0.72142f,  0.72324f,  0.72502f,  0.72679f,  0.72853f,  0.73026f,
   0.73199f,  0.73371f,  0.73543f,  0.73715f,  0.73889f,  0.74063f,  0.74239f,
   0.74417f,  0.74597f,  0.74779f,  0.74964f,  0.75151f,  0.75342f,  0.75535f,
   0.75732f,  0.75933f,  0.76137f,  0.76345f,  0.76556f,  0.76771f,  0.76990f,
   0.77213f,  0.77440f,  0.77671f,  0.77905f,  0.78144f,  0.78386f,  0.78632f,
   0.78882f,  0.79135f,  0.79393f,  0.79654f,  0.79919f,  0.80188f,  0.80461f,
   0.80739f,  0.81020f,  0.81306f,  0.81596f,  0.81891f,  0.82191f,  0.82497f,
   0.82808f,  0.83125f,  0.83448f,  0.83778f,  0.84115f,  0.84459f,  0.84811f,
   0.85170f,  0.85538f,  0.85914f,  0.86299f,  0.86693f,  0.87095f,  0.87507f,
   0.87927f,  0.88355f,  0.88792f,  0.89236f,  0.89687f,  0.90145f,  0.90608f,
   0.91075f,  0.91545f,  0.92017f,  0.92489f,  0.92960f,  0.93427f,  0.93890f,
   0.94346f,  0.94794f,  0.95233f,  0.95661f,  0.96078f,  0.96484f,  0.96877f,
   0.97257f,  0.97626f,  0.97982f,  0.98324f,  0.98651f,  0.98960f,  0.99244f,
   0.99495f,  0.99706f,  0.99866f,  0.99966f,  1.00000f},
   //---------  1.00 GeV
  {0.00064f,  0.00248f,  0.00552f,  0.00970f,  0.01498f,  0.02132f,  0.02865f,
   0.03694f,  0.04614f,  0.05619f,  0.06706f,  0.07870f,  0.09105f,  0.10406f,
   0.11768f,  0.13184f,  0.14650f,  0.16159f,  0.17704f,  0.19281f,  0.20883f,
   0.22505f,  0.24140f,  0.25784f,  0.27431f,  0.29076f,  0.30714f,  0.32342f,
   0.33955f,  0.35548f,  0.37119f,  0.38664f,  0.40181f,  0.41666f,  0.43117f,
   0.44532f,  0.45910f,  0.47248f,  0.48546f,  0.49803f,  0.51018f,  0.52191f,
   0.53321f,  0.54408f,  0.55453f,  0.56457f,  0.57418f,  0.58339f,  0.59220f,
   0.60062f,  0.60867f,  0.61634f,  0.62365f,  0.63062f,  0.63725f,  0.64356f,
   0.64957f,  0.65527f,  0.66069f,  0.66583f,  0.67071f,  0.67534f,  0.67973f,
   0.68389f,  0.68784f,  0.69158f,  0.69512f,  0.69848f,  0.70167f,  0.70468f,
   0.70755f,  0.71027f,  0.71285f,  0.71530f,  0.71764f,  0.71987f,  0.72201f,
   0.72405f,  0.72601f,  0.72789f,  0.72971f,  0.73147f,  0.73319f,  0.73485f,
   0.73649f,  0.73809f,  0.73967f,  0.74123f,  0.74278f,  0.74432f,  0.74586f,
   0.74740f,  0.74894f,  0.75050f,  0.75206f,  0.75365f,  0.75525f,  0.75687f,
   0.75852f,  0.76020f,  0.76190f,  0.76363f,  0.76539f,  0.76719f,  0.76902f,
   0.77088f,  0.77278f,  0.77472f,  0.77669f,  0.77871f,  0.78076f,  0.78284f,
   0.78497f,  0.78713f,  0.78932f,  0.79156f,  0.79382f,  0.79613f,  0.79846f,
   0.80083f,  0.80322f,  0.80565f,  0.80811f,  0.81060f,  0.81311f,  0.81566f,
   0.81824f,  0.82085f,  0.82349f,  0.82617f,  0.82889f,  0.83164f,  0.83444f,
   0.83728f,  0.84017f,  0.84311f,  0.84611f,  0.84916f,  0.85228f,  0.85547f,
   0.85872f,  0.86205f,  0.86546f,  0.86895f,  0.87252f,  0.87618f,  0.87992f,
   0.88376f,  0.88768f,  0.89169f,  0.89578f,  0.89995f,  0.90420f,  0.90852f,
   0.91289f,  0.91732f,  0.92179f,  0.92627f,  0.93077f,  0.93526f,  0.93973f,
   0.94415f,  0.94851f,  0.95279f,  0.95699f,  0.96108f,  0.96506f,  0.96892f,
   0.97267f,  0.97630f,  0.97980f,  0.98319f,  0.98642f,  0.98949f,  0.99233f,
   0.99486f,  0.99700f,  0.99863f,  0.99965f,  1.00000f},
   //---------  1.10 GeV
  {0.00072f,  0.00280f,  0.00623f,  0.01096f,  0.01693f,  0.02409f,  0.03237f,
   0.04173f,  0.05210f,  0.06342f,  0.07565f,  0.08870f,  0.10253f,  0.11705f,
   0.13220f,  0.14790f,  0.16408f,  0.18067f,  0.19759f,  0.21477f,  0.23214f,
   0.24964f,  0.26719f,  0.28474f,  0.30223f,  0.31961f,  0.33682f,  0.35382f,
   0.37056f,  0.38702f,  0.40315f,  0.41893f,  0.43433f,  0.44933f,  0.46390f,
   0.47804f,  0.49173f,  0.50497f,  0.51774f,  0.53005f,  0.54190f,  0.55328f,
   0.56421f,  0.57468f,  0.58471f,  0.59431f,  0.60348f,  0.61224f,  0.62059f,
   0.62856f,  0.63616f,  0.64339f,  0.65028f,  0.65683f,  0.66306f,  0.66897f,
   0.67460f,  0.67993f,  0.68499f,  0.68979f,  0.69434f,  0.69865f,  0.70273f,
   0.70659f,  0.71025f,  0.71370f,  0.71696f,  0.72004f,  0.72295f,  0.72570f,
   0.72830f,  0.73076f,  0.73309f,  0.73529f,  0.73738f,  0.73937f,  0.74127f,
   0.74308f,  0.74481f,  0.74648f,  0.74809f,  0.74964f,  0.75116f,  0.75264f,
   0.75410f,  0.75554f,  0.75696f,  0.75837f,  0.75978f,  0.76120f,  0.76262f,
   0.76405f,  0.76550f,  0.76697f,  0.76845f,  0.76996f,  0.77150f,  0.77306f,
   0.77465f,  0.77627f,  0.77792f,  0.77961f,  0.78133f,  0.78308f,  0.78487f,
   0.78669f,  0.78855f,  0.79045f,  0.79238f,  0.79435f,  0.79636f,  0.79840f,
   0.80047f,  0.80258f,  0.80472f,  0.80690f,  0.80910f,  0.81133f,  0.81358f,
   0.81586f,  0.81816f,  0.82049f,  0.82283f,  0.82519f,  0.82757f,  0.82997f,
   0.83238f,  0.83482f,  0.83727f,  0.83974f,  0.84224f,  0.84476f,  0.84730f,
   0.84988f,  0.85249f,  0.85514f,  0.85782f,  0.86056f,  0.86334f,  0.86617f,
   0.86906f,  0.87201f,  0.87502f,  0.87811f,  0.88127f,  0.88450f,  0.88782f,
   0.89121f,  0.89469f,  0.89826f,  0.90191f,  0.90565f,  0.90947f,  0.91337f,
   0.91734f,  0.92138f,  0.92547f,  0.92961f,  0.93377f,  0.93795f,  0.94213f,
   0.94628f,  0.95040f,  0.95446f,  0.95845f,  0.96235f,  0.96616f,  0.96986f,
   0.97345f,  0.97693f,  0.98029f,  0.98355f,  0.98667f,  0.98964f,  0.99241f,
   0.99489f,  0.99700f,  0.99862f,  0.99965f,  1.00000f},
   //---------  1.20 GeV
  {0.00080f,  0.00312f,  0.00693f,  0.01219f,  0.01884f,  0.02680f,  0.03601f,
   0.04640f,  0.05791f,  0.07047f,  0.08400f,  0.09841f,  0.11364f,  0.12959f,
   0.14617f,  0.16331f,  0.18089f,  0.19885f,  0.21709f,  0.23553f,  0.25408f,
   0.27268f,  0.29125f,  0.30973f,  0.32804f,  0.34614f,  0.36398f,  0.38151f,
   0.39868f,  0.41547f,  0.43184f,  0.44777f,  0.46324f,  0.47822f,  0.49272f,
   0.50672f,  0.52021f,  0.53319f,  0.54567f,  0.55765f,  0.56914f,  0.58014f,
   0.59067f,  0.60074f,  0.61035f,  0.61953f,  0.62829f,  0.63665f,  0.64461f,
   0.65220f,  0.65943f,  0.66631f,  0.67286f,  0.67909f,  0.68501f,  0.69065f,
   0.69600f,  0.70108f,  0.70589f,  0.71046f,  0.71479f,  0.71889f,  0.72276f,
   0.72642f,  0.72988f,  0.73314f,  0.73621f,  0.73910f,  0.74183f,  0.74439f,
   0.74681f,  0.74908f,  0.75123f,  0.75325f,  0.75516f,  0.75697f,  0.75869f,
   0.76033f,  0.76190f,  0.76341f,  0.76486f,  0.76628f,  0.76766f,  0.76902f,
   0.77036f,  0.77169f,  0.77301f,  0.77434f,  0.77568f,  0.77704f,  0.77841f,
   0.77980f,  0.78121f,  0.78266f,  0.78413f,  0.78563f,  0.78717f,  0.78873f,
   0.79034f,  0.79197f,  0.79364f,  0.79535f,  0.79710f,  0.79888f,  0.80069f,
   0.80255f,  0.80444f,  0.80636f,  0.80833f,  0.81033f,  0.81236f,  0.81443f,
   0.81653f,  0.81866f,  0.82082f,  0.82301f,  0.82522f,  0.82746f,  0.82971f,
   0.83198f,  0.83427f,  0.83656f,  0.83887f,  0.84118f,  0.84350f,  0.84582f,
   0.84815f,  0.85047f,  0.85280f,  0.85514f,  0.85747f,  0.85982f,  0.86217f,
   0.86453f,  0.86690f,  0.86929f,  0.87171f,  0.87414f,  0.87661f,  0.87910f,
   0.88163f,  0.88421f,  0.88683f,  0.88950f,  0.89223f,  0.89502f,  0.89788f,
   0.90080f,  0.90380f,  0.90688f,  0.91003f,  0.91328f,  0.91660f,  0.92001f,
   0.92349f,  0.92705f,  0.93068f,  0.93437f,  0.93811f,  0.94189f,  0.94568f,
   0.94948f,  0.95326f,  0.95701f,  0.96071f,  0.96434f,  0.96789f,  0.97135f,
   0.97472f,  0.97798f,  0.98115f,  0.98421f,  0.98717f,  0.98999f,  0.99263f,
   0.99502f,  0.99707f,  0.99865f,  0.99965f,  1.00000f},
   //---------  1.3 GeV
  {0.00044f,  0.00170f,  0.00506f,  0.01004f,  0.01659f,  0.02465f,  0.03416f,
   0.04506f,  0.05727f,  0.07071f,  0.08529f,  0.10091f,  0.11749f,  0.13490f,
   0.15303f,  0.17179f,  0.19105f,  0.21070f,  0.23062f,  0.25072f,  0.27089f,
   0.29104f,  0.31108f,  0.33093f,  0.35050f,  0.36974f,  0.38858f,  0.40696f,
   0.42485f,  0.44221f,  0.45900f,  0.47520f,  0.49079f,  0.50576f,  0.52012f,
   0.53384f,  0.54695f,  0.55944f,  0.57133f,  0.58264f,  0.59338f,  0.60357f,
   0.61323f,  0.62239f,  0.63107f,  0.63930f,  0.64709f,  0.65448f,  0.66148f,
   0.66812f,  0.67441f,  0.68038f,  0.68605f,  0.69143f,  0.69654f,  0.70138f,
   0.70599f,  0.71035f,  0.71450f,  0.71843f,  0.72215f,  0.72567f,  0.72900f,
   0.73214f,  0.73511f,  0.73790f,  0.74052f,  0.74298f,  0.74529f,  0.74744f,
   0.74945f,  0.75133f,  0.75308f,  0.75470f,  0.75622f,  0.75763f,  0.75895f,
   0.76018f,  0.76133f,  0.76242f,  0.76344f,  0.76442f,  0.76536f,  0.76628f,
   0.76717f,  0.76805f,  0.76893f,  0.76981f,  0.77071f,  0.77164f,  0.77259f,
   0.77358f,  0.77461f,  0.77569f,  0.77682f,  0.77801f,  0.77927f,  0.78059f,
   0.78198f,  0.78344f,  0.78497f,  0.78658f,  0.78826f,  0.79002f,  0.79185f,
   0.79376f,  0.79574f,  0.79778f,  0.79990f,  0.80207f,  0.80431f,  0.80660f,
   0.80894f,  0.81133f,  0.81376f,  0.81623f,  0.81872f,  0.82125f,  0.82379f,
   0.82635f,  0.82893f,  0.83151f,  0.83409f,  0.83668f,  0.83927f,  0.84185f,
   0.84443f,  0.84701f,  0.84958f,  0.85215f,  0.85471f,  0.85727f,  0.85982f,
   0.86238f,  0.86494f,  0.86750f,  0.87007f,  0.87264f,  0.87523f,  0.87783f,
   0.88044f,  0.88308f,  0.88573f,  0.88841f,  0.89113f,  0.89388f,  0.89667f,
   0.89951f,  0.90239f,  0.90534f,  0.90836f,  0.91144f,  0.91460f,  0.91784f,
   0.92115f,  0.92455f,  0.92803f,  0.93158f,  0.93520f,  0.93889f,  0.94262f,
   0.94638f,  0.95016f,  0.95394f,  0.95769f,  0.96141f,  0.96508f,  0.96867f,
   0.97219f,  0.97561f,  0.97894f,  0.98217f,  0.98529f,  0.98828f,  0.99112f,
   0.99373f,  0.99605f,  0.99794f,  0.99929f,  1.00000f},
   //---------  1.4 GeV
  {0.00047f,  0.00183f,  0.00543f,  0.01078f,  0.01782f,  0.02649f,  0.03671f,
   0.04843f,  0.06154f,  0.07596f,  0.09158f,  0.10830f,  0.12599f,  0.14453f,
   0.16381f,  0.18368f,  0.20401f,  0.22469f,  0.24558f,  0.26658f,  0.28758f,
   0.30846f,  0.32913f,  0.34951f,  0.36951f,  0.38907f,  0.40813f,  0.42664f,
   0.44456f,  0.46184f,  0.47847f,  0.49443f,  0.50971f,  0.52431f,  0.53821f,
   0.55145f,  0.56402f,  0.57594f,  0.58723f,  0.59792f,  0.60803f,  0.61758f,
   0.62661f,  0.63515f,  0.64321f,  0.65084f,  0.65805f,  0.66488f,  0.67135f,
   0.67748f,  0.68330f,  0.68883f,  0.69408f,  0.69908f,  0.70383f,  0.70835f,
   0.71265f,  0.71674f,  0.72063f,  0.72433f,  0.72784f,  0.73117f,  0.73432f,
   0.73729f,  0.74010f,  0.74274f,  0.74522f,  0.74754f,  0.74971f,  0.75173f,
   0.75361f,  0.75535f,  0.75697f,  0.75846f,  0.75985f,  0.76112f,  0.76230f,
   0.76340f,  0.76441f,  0.76536f,  0.76625f,  0.76710f,  0.76791f,  0.76869f,
   0.76946f,  0.77022f,  0.77098f,  0.77175f,  0.77255f,  0.77338f,  0.77424f,
   0.77515f,  0.77612f,  0.77714f,  0.77823f,  0.77939f,  0.78062f,  0.78193f,
   0.78333f,  0.78481f,  0.78637f,  0.78803f,  0.78977f,  0.79160f,  0.79352f,
   0.79553f,  0.79762f,  0.79980f,  0.80205f,  0.80439f,  0.80679f,  0.80925f,
   0.81178f,  0.81437f,  0.81700f,  0.81967f,  0.82238f,  0.82512f,  0.82788f,
   0.83066f,  0.83345f,  0.83625f,  0.83905f,  0.84184f,  0.84463f,  0.84740f,
   0.85016f,  0.85291f,  0.85564f,  0.85835f,  0.86105f,  0.86373f,  0.86639f,
   0.86903f,  0.87166f,  0.87427f,  0.87687f,  0.87945f,  0.88203f,  0.88459f,
   0.88715f,  0.88970f,  0.89224f,  0.89480f,  0.89735f,  0.89992f,  0.90250f,
   0.90511f,  0.90775f,  0.91043f,  0.91316f,  0.91594f,  0.91878f,  0.92170f,
   0.92469f,  0.92776f,  0.93092f,  0.93416f,  0.93747f,  0.94087f,  0.94432f,
   0.94784f,  0.95139f,  0.95496f,  0.95854f,  0.96211f,  0.96564f,  0.96912f,
   0.97254f,  0.97588f,  0.97914f,  0.98231f,  0.98538f,  0.98833f,  0.99113f,
   0.99373f,  0.99603f,  0.99793f,  0.99929f,  1.00000f},
   //---------  1.5 GeV
  {0.00049f,  0.00194f,  0.00576f,  0.01143f,  0.01890f,  0.02810f,  0.03895f,
   0.05136f,  0.06525f,  0.08051f,  0.09702f,  0.11466f,  0.13329f,  0.15278f,
   0.17297f,  0.19374f,  0.21493f,  0.23642f,  0.25807f,  0.27974f,  0.30132f,
   0.32270f,  0.34379f,  0.36448f,  0.38471f,  0.40440f,  0.42350f,  0.44196f,
   0.45974f,  0.47682f,  0.49316f,  0.50877f,  0.52364f,  0.53776f,  0.55116f,
   0.56384f,  0.57583f,  0.58715f,  0.59782f,  0.60788f,  0.61736f,  0.62629f,
   0.63471f,  0.64264f,  0.65013f,  0.65719f,  0.66387f,  0.67019f,  0.67618f,
   0.68187f,  0.68727f,  0.69240f,  0.69730f,  0.70196f,  0.70641f,  0.71066f,
   0.71472f,  0.71859f,  0.72228f,  0.72580f,  0.72915f,  0.73233f,  0.73534f,
   0.73820f,  0.74090f,  0.74344f,  0.74583f,  0.74806f,  0.75015f,  0.75209f,
   0.75390f,  0.75557f,  0.75711f,  0.75853f,  0.75984f,  0.76105f,  0.76215f,
   0.76318f,  0.76412f,  0.76500f,  0.76582f,  0.76660f,  0.76734f,  0.76806f,
   0.76877f,  0.76947f,  0.77018f,  0.77091f,  0.77167f,  0.77247f,  0.77331f,
   0.77420f,  0.77516f,  0.77618f,  0.77728f,  0.77845f,  0.77972f,  0.78107f,
   0.78251f,  0.78405f,  0.78569f,  0.78743f,  0.78927f,  0.79121f,  0.79325f,
   0.79539f,  0.79763f,  0.79996f,  0.80238f,  0.80489f,  0.80747f,  0.81014f,
   0.81287f,  0.81567f,  0.81852f,  0.82142f,  0.82435f,  0.82732f,  0.83032f,
   0.83333f,  0.83635f,  0.83937f,  0.84239f,  0.84540f,  0.84839f,  0.85136f,
   0.85431f,  0.85724f,  0.86014f,  0.86300f,  0.86584f,  0.86864f,  0.87141f,
   0.87414f,  0.87684f,  0.87951f,  0.88215f,  0.88475f,  0.88732f,  0.88986f,
   0.89237f,  0.89485f,  0.89731f,  0.89974f,  0.90216f,  0.90457f,  0.90697f,
   0.90938f,  0.91180f,  0.91424f,  0.91671f,  0.91923f,  0.92180f,  0.92443f,
   0.92714f,  0.92993f,  0.93281f,  0.93578f,  0.93885f,  0.94200f,  0.94524f,
   0.94855f,  0.95193f,  0.95535f,  0.95880f,  0.96226f,  0.96571f,  0.96913f,
   0.97250f,  0.97582f,  0.97906f,  0.98222f,  0.98528f,  0.98824f,  0.99105f,
   0.99366f,  0.99598f,  0.99790f,  0.99928f,  1.00000f},
   //---------  1.6 GeV
  {0.00052f,  0.00203f,  0.00605f,  0.01201f,  0.01986f,  0.02952f,  0.04091f,
   0.05394f,  0.06851f,  0.08449f,  0.10176f,  0.12018f,  0.13960f,  0.15987f,
   0.18083f,  0.20233f,  0.22421f,  0.24632f,  0.26852f,  0.29069f,  0.31269f,
   0.33440f,  0.35574f,  0.37661f,  0.39692f,  0.41662f,  0.43563f,  0.45393f,
   0.47148f,  0.48825f,  0.50423f,  0.51942f,  0.53381f,  0.54743f,  0.56029f,
   0.57240f,  0.58380f,  0.59452f,  0.60458f,  0.61404f,  0.62291f,  0.63125f,
   0.63908f,  0.64645f,  0.65339f,  0.65993f,  0.66612f,  0.67198f,  0.67753f,
   0.68281f,  0.68783f,  0.69262f,  0.69720f,  0.70157f,  0.70576f,  0.70977f,
   0.71361f,  0.71729f,  0.72081f,  0.72417f,  0.72739f,  0.73045f,  0.73336f,
   0.73612f,  0.73874f,  0.74121f,  0.74353f,  0.74571f,  0.74774f,  0.74964f,
   0.75140f,  0.75303f,  0.75454f,  0.75592f,  0.75720f,  0.75837f,  0.75945f,
   0.76045f,  0.76136f,  0.76222f,  0.76302f,  0.76378f,  0.76451f,  0.76522f,
   0.76592f,  0.76662f,  0.76734f,  0.76807f,  0.76885f,  0.76966f,  0.77052f,
   0.77145f,  0.77244f,  0.77351f,  0.77466f,  0.77590f,  0.77723f,  0.77865f,
   0.78018f,  0.78181f,  0.78355f,  0.78540f,  0.78736f,  0.78943f,  0.79161f,
   0.79390f,  0.79629f,  0.79879f,  0.80138f,  0.80407f,  0.80685f,  0.80972f,
   0.81266f,  0.81566f,  0.81873f,  0.82185f,  0.82501f,  0.82820f,  0.83142f,
   0.83465f,  0.83789f,  0.84113f,  0.84435f,  0.84756f,  0.85075f,  0.85391f,
   0.85704f,  0.86012f,  0.86317f,  0.86618f,  0.86914f,  0.87205f,  0.87491f,
   0.87773f,  0.88049f,  0.88320f,  0.88587f,  0.88848f,  0.89104f,  0.89355f,
   0.89601f,  0.89843f,  0.90080f,  0.90313f,  0.90543f,  0.90769f,  0.90993f,
   0.91216f,  0.91439f,  0.91663f,  0.91888f,  0.92118f,  0.92352f,  0.92592f,
   0.92839f,  0.93095f,  0.93361f,  0.93637f,  0.93924f,  0.94221f,  0.94529f,
   0.94846f,  0.95172f,  0.95505f,  0.95843f,  0.96184f,  0.96527f,  0.96868f,
   0.97207f,  0.97541f,  0.97868f,  0.98188f,  0.98500f,  0.98800f,  0.99086f,
   0.99352f,  0.99589f,  0.99784f,  0.99926f,  1.00000f},
   //---------  1.7 GeV
  {0.00054f,  0.00212f,  0.00631f,  0.01254f,  0.02072f,  0.03080f,  0.04268f,
   0.05626f,  0.07142f,  0.08804f,  0.10598f,  0.12508f,  0.14517f,  0.16611f,
   0.18771f,  0.20981f,  0.23225f,  0.25488f,  0.27753f,  0.30007f,  0.32237f,
   0.34432f,  0.36580f,  0.38673f,  0.40703f,  0.42664f,  0.44549f,  0.46356f,
   0.48082f,  0.49724f,  0.51282f,  0.52756f,  0.54147f,  0.55456f,  0.56687f,
   0.57842f,  0.58925f,  0.59938f,  0.60886f,  0.61773f,  0.62604f,  0.63381f,
   0.64110f,  0.64795f,  0.65439f,  0.66045f,  0.66619f,  0.67161f,  0.67677f,
   0.68167f,  0.68635f,  0.69082f,  0.69510f,  0.69920f,  0.70315f,  0.70694f,
   0.71058f,  0.71408f,  0.71744f,  0.72066f,  0.72375f,  0.72670f,  0.72951f,
   0.73219f,  0.73473f,  0.73714f,  0.73940f,  0.74153f,  0.74353f,  0.74539f,
   0.74712f,  0.74873f,  0.75021f,  0.75159f,  0.75285f,  0.75402f,  0.75509f,
   0.75609f,  0.75701f,  0.75788f,  0.75870f,  0.75947f,  0.76022f,  0.76096f,
   0.76169f,  0.76243f,  0.76319f,  0.76397f,  0.76479f,  0.76566f,  0.76659f,
   0.76758f,  0.76865f,  0.76979f,  0.77102f,  0.77235f,  0.77377f,  0.77530f,
   0.77693f,  0.77867f,  0.78053f,  0.78250f,  0.78459f,  0.78679f,  0.78911f,
   0.79155f,  0.79410f,  0.79676f,  0.79952f,  0.80239f,  0.80535f,  0.80840f,
   0.81153f,  0.81473f,  0.81800f,  0.82132f,  0.82468f,  0.82808f,  0.83149f,
   0.83493f,  0.83836f,  0.84179f,  0.84520f,  0.84859f,  0.85194f,  0.85526f,
   0.85854f,  0.86177f,  0.86494f,  0.86806f,  0.87112f,  0.87412f,  0.87706f,
   0.87994f,  0.88275f,  0.88549f,  0.88817f,  0.89078f,  0.89333f,  0.89580f,
   0.89822f,  0.90057f,  0.90286f,  0.90509f,  0.90728f,  0.90941f,  0.91152f,
   0.91359f,  0.91566f,  0.91772f,  0.91980f,  0.92190f,  0.92406f,  0.92627f,
   0.92856f,  0.93095f,  0.93344f,  0.93604f,  0.93877f,  0.94161f,  0.94459f,
   0.94768f,  0.95088f,  0.95417f,  0.95754f,  0.96096f,  0.96441f,  0.96787f,
   0.97132f,  0.97473f,  0.97809f,  0.98137f,  0.98456f,  0.98765f,  0.99059f,
   0.99332f,  0.99576f,  0.99777f,  0.99923f,  1.00000f},
   //---------  1.8 GeV
  {0.00056f,  0.00220f,  0.00656f,  0.01302f,  0.02152f,  0.03198f,  0.04430f,
   0.05838f,  0.07409f,  0.09129f,  0.10983f,  0.12954f,  0.15025f,  0.17178f,
   0.19395f,  0.21658f,  0.23950f,  0.26255f,  0.28557f,  0.30841f,  0.33095f,
   0.35306f,  0.37463f,  0.39557f,  0.41581f,  0.43528f,  0.45394f,  0.47175f,
   0.48869f,  0.50474f,  0.51991f,  0.53420f,  0.54762f,  0.56021f,  0.57199f,
   0.58299f,  0.59326f,  0.60284f,  0.61177f,  0.62009f,  0.62786f,  0.63511f,
   0.64190f,  0.64825f,  0.65422f,  0.65984f,  0.66515f,  0.67018f,  0.67496f,
   0.67951f,  0.68386f,  0.68803f,  0.69203f,  0.69588f,  0.69958f,  0.70316f,
   0.70660f,  0.70992f,  0.71312f,  0.71620f,  0.71916f,  0.72199f,  0.72470f,
   0.72729f,  0.72976f,  0.73209f,  0.73430f,  0.73638f,  0.73834f,  0.74017f,
   0.74188f,  0.74347f,  0.74494f,  0.74631f,  0.74758f,  0.74876f,  0.74985f,
   0.75087f,  0.75182f,  0.75272f,  0.75357f,  0.75439f,  0.75519f,  0.75598f,
   0.75677f,  0.75758f,  0.75840f,  0.75926f,  0.76016f,  0.76112f,  0.76213f,
   0.76321f,  0.76437f,  0.76561f,  0.76694f,  0.76837f,  0.76990f,  0.77153f,
   0.77328f,  0.77514f,  0.77711f,  0.77920f,  0.78142f,  0.78375f,  0.78620f,
   0.78878f,  0.79147f,  0.79427f,  0.79719f,  0.80021f,  0.80333f,  0.80654f,
   0.80984f,  0.81321f,  0.81664f,  0.82013f,  0.82367f,  0.82723f,  0.83082f,
   0.83442f,  0.83802f,  0.84160f,  0.84517f,  0.84870f,  0.85219f,  0.85564f,
   0.85904f,  0.86238f,  0.86566f,  0.86886f,  0.87200f,  0.87507f,  0.87806f,
   0.88098f,  0.88382f,  0.88658f,  0.88926f,  0.89187f,  0.89439f,  0.89683f,
   0.89920f,  0.90149f,  0.90370f,  0.90585f,  0.90793f,  0.90996f,  0.91195f,
   0.91390f,  0.91582f,  0.91775f,  0.91968f,  0.92164f,  0.92365f,  0.92572f,
   0.92787f,  0.93013f,  0.93250f,  0.93499f,  0.93763f,  0.94041f,  0.94333f,
   0.94638f,  0.94957f,  0.95287f,  0.95627f,  0.95974f,  0.96326f,  0.96681f,
   0.97035f,  0.97387f,  0.97734f,  0.98073f,  0.98404f,  0.98723f,  0.99027f,
   0.99309f,  0.99561f,  0.99770f,  0.99920f,  1.00000f},
   //---------  1.9 GeV
  {0.00058f,  0.00228f,  0.00679f,  0.01347f,  0.02227f,  0.03309f,  0.04583f,
   0.06038f,  0.07659f,  0.09433f,  0.11343f,  0.13370f,  0.15496f,  0.17703f,
   0.19971f,  0.22282f,  0.24617f,  0.26960f,  0.29294f,  0.31604f,  0.33877f,
   0.36099f,  0.38262f,  0.40355f,  0.42370f,  0.44303f,  0.46148f,  0.47903f,
   0.49565f,  0.51134f,  0.52610f,  0.53995f,  0.55292f,  0.56502f,  0.57629f,
   0.58679f,  0.59654f,  0.60559f,  0.61400f,  0.62181f,  0.62908f,  0.63584f,
   0.64215f,  0.64805f,  0.65358f,  0.65879f,  0.66370f,  0.66835f,  0.67277f,
   0.67699f,  0.68103f,  0.68490f,  0.68863f,  0.69223f,  0.69570f,  0.69905f,
   0.70230f,  0.70544f,  0.70847f,  0.71140f,  0.71422f,  0.71693f,  0.71954f,
   0.72203f,  0.72441f,  0.72667f,  0.72882f,  0.73085f,  0.73277f,  0.73456f,
   0.73625f,  0.73783f,  0.73930f,  0.74068f,  0.74196f,  0.74316f,  0.74428f,
   0.74533f,  0.74633f,  0.74728f,  0.74819f,  0.74907f,  0.74994f,  0.75081f,
   0.75168f,  0.75257f,  0.75349f,  0.75444f,  0.75544f,  0.75649f,  0.75760f,
   0.75879f,  0.76005f,  0.76140f,  0.76284f,  0.76438f,  0.76601f,  0.76776f,
   0.76961f,  0.77158f,  0.77366f,  0.77586f,  0.77819f,  0.78063f,  0.78320f,
   0.78589f,  0.78869f,  0.79162f,  0.79466f,  0.79780f,  0.80105f,  0.80439f,
   0.80781f,  0.81131f,  0.81488f,  0.81850f,  0.82217f,  0.82587f,  0.82959f,
   0.83332f,  0.83704f,  0.84075f,  0.84443f,  0.84807f,  0.85167f,  0.85522f,
   0.85871f,  0.86213f,  0.86548f,  0.86875f,  0.87195f,  0.87506f,  0.87809f,
   0.88103f,  0.88389f,  0.88666f,  0.88933f,  0.89192f,  0.89442f,  0.89683f,
   0.89915f,  0.90138f,  0.90353f,  0.90561f,  0.90761f,  0.90955f,  0.91143f,
   0.91328f,  0.91510f,  0.91691f,  0.91873f,  0.92058f,  0.92248f,  0.92445f,
   0.92651f,  0.92868f,  0.93097f,  0.93341f,  0.93599f,  0.93874f,  0.94165f,
   0.94472f,  0.94793f,  0.95128f,  0.95474f,  0.95830f,  0.96192f,  0.96558f,
   0.96925f,  0.97290f,  0.97650f,  0.98003f,  0.98346f,  0.98677f,  0.98992f,
   0.99284f,  0.99545f,  0.99761f,  0.99917f,  1.00000f},
   //---------  2.0 GeV
  {0.00060f,  0.00235f,  0.00701f,  0.01391f,  0.02299f,  0.03416f,  0.04730f,
   0.06230f,  0.07900f,  0.09725f,  0.11687f,  0.13768f,  0.15947f,  0.18206f,
   0.20522f,  0.22877f,  0.25253f,  0.27630f,  0.29993f,  0.32327f,  0.34617f,
   0.36850f,  0.39016f,  0.41107f,  0.43114f,  0.45031f,  0.46856f,  0.48584f,
   0.50216f,  0.51750f,  0.53188f,  0.54532f,  0.55784f,  0.56948f,  0.58028f,
   0.59029f,  0.59955f,  0.60812f,  0.61604f,  0.62338f,  0.63017f,  0.63648f,
   0.64234f,  0.64781f,  0.65294f,  0.65775f,  0.66228f,  0.66658f,  0.67066f,
   0.67456f,  0.67830f,  0.68189f,  0.68535f,  0.68870f,  0.69194f,  0.69508f,
   0.69812f,  0.70107f,  0.70394f,  0.70671f,  0.70939f,  0.71197f,  0.71446f,
   0.71685f,  0.71914f,  0.72133f,  0.72341f,  0.72539f,  0.72726f,  0.72903f,
   0.73070f,  0.73226f,  0.73374f,  0.73513f,  0.73643f,  0.73766f,  0.73882f,
   0.73993f,  0.74098f,  0.74199f,  0.74298f,  0.74395f,  0.74490f,  0.74586f,
   0.74683f,  0.74782f,  0.74884f,  0.74990f,  0.75100f,  0.75217f,  0.75339f,
   0.75469f,  0.75606f,  0.75752f,  0.75906f,  0.76070f,  0.76244f,  0.76428f,
   0.76623f,  0.76829f,  0.77046f,  0.77276f,  0.77517f,  0.77770f,  0.78035f,
   0.78312f,  0.78601f,  0.78902f,  0.79214f,  0.79537f,  0.79871f,  0.80214f,
   0.80565f,  0.80924f,  0.81290f,  0.81662f,  0.82038f,  0.82417f,  0.82798f,
   0.83180f,  0.83561f,  0.83940f,  0.84316f,  0.84689f,  0.85056f,  0.85418f,
   0.85773f,  0.86121f,  0.86461f,  0.86792f,  0.87115f,  0.87429f,  0.87734f,
   0.88030f,  0.88316f,  0.88592f,  0.88859f,  0.89116f,  0.89363f,  0.89601f,
   0.89829f,  0.90047f,  0.90257f,  0.90458f,  0.90652f,  0.90839f,  0.91020f,
   0.91196f,  0.91370f,  0.91543f,  0.91717f,  0.91894f,  0.92076f,  0.92266f,
   0.92466f,  0.92677f,  0.92903f,  0.93144f,  0.93401f,  0.93677f,  0.93970f,
   0.94280f,  0.94607f,  0.94950f,  0.95306f,  0.95672f,  0.96047f,  0.96426f,
   0.96807f,  0.97186f,  0.97561f,  0.97928f,  0.98285f,  0.98629f,  0.98956f,
   0.99259f,  0.99529f,  0.99752f,  0.99914f,  1.00000f},
   //---------  2.2 GeV
  {0.00063f,  0.00250f,  0.00744f,  0.01476f,  0.02440f,  0.03623f,  0.05015f,
   0.06601f,  0.08365f,  0.10288f,  0.12351f,  0.14533f,  0.16812f,  0.19166f,
   0.21574f,  0.24014f,  0.26465f,  0.28908f,  0.31326f,  0.33703f,  0.36024f,
   0.38276f,  0.40448f,  0.42533f,  0.44523f,  0.46412f,  0.48198f,  0.49879f,
   0.51454f,  0.52924f,  0.54292f,  0.55560f,  0.56731f,  0.57812f,  0.58806f,
   0.59719f,  0.60557f,  0.61326f,  0.62031f,  0.62678f,  0.63274f,  0.63822f,
   0.64329f,  0.64799f,  0.65236f,  0.65646f,  0.66031f,  0.66395f,  0.66740f,
   0.67070f,  0.67387f,  0.67692f,  0.67988f,  0.68274f,  0.68553f,  0.68824f,
   0.69089f,  0.69347f,  0.69599f,  0.69844f,  0.70083f,  0.70315f,  0.70540f,
   0.70758f,  0.70969f,  0.71172f,  0.71367f,  0.71555f,  0.71734f,  0.71906f,
   0.72070f,  0.72227f,  0.72377f,  0.72520f,  0.72658f,  0.72790f,  0.72917f,
   0.73041f,  0.73161f,  0.73279f,  0.73395f,  0.73511f,  0.73628f,  0.73745f,
   0.73864f,  0.73986f,  0.74111f,  0.74240f,  0.74373f,  0.74512f,  0.74657f,
   0.74808f,  0.74966f,  0.75131f,  0.75304f,  0.75485f,  0.75675f,  0.75874f,
   0.76082f,  0.76300f,  0.76528f,  0.76767f,  0.77017f,  0.77278f,  0.77551f,
   0.77835f,  0.78130f,  0.78437f,  0.78755f,  0.79084f,  0.79423f,  0.79772f,
   0.80129f,  0.80495f,  0.80868f,  0.81247f,  0.81631f,  0.82017f,  0.82406f,
   0.82796f,  0.83185f,  0.83573f,  0.83957f,  0.84337f,  0.84711f,  0.85079f,
   0.85440f,  0.85793f,  0.86138f,  0.86473f,  0.86799f,  0.87115f,  0.87421f,
   0.87717f,  0.88002f,  0.88276f,  0.88540f,  0.88793f,  0.89036f,  0.89268f,
   0.89489f,  0.89700f,  0.89902f,  0.90094f,  0.90278f,  0.90455f,  0.90626f,
   0.90792f,  0.90955f,  0.91118f,  0.91283f,  0.91451f,  0.91626f,  0.91810f,
   0.92005f,  0.92215f,  0.92440f,  0.92684f,  0.92947f,  0.93230f,  0.93535f,
   0.93860f,  0.94205f,  0.94569f,  0.94948f,  0.95341f,  0.95744f,  0.96153f,
   0.96565f,  0.96976f,  0.97382f,  0.97779f,  0.98165f,  0.98535f,  0.98885f,
   0.99209f,  0.99497f,  0.99736f,  0.99909f,  1.00000f},
   //---------  2.4 GeV
  {0.00067f,  0.00264f,  0.00785f,  0.01558f,  0.02574f,  0.03821f,  0.05286f,
   0.06954f,  0.08806f,  0.10823f,  0.12981f,  0.15259f,  0.17632f,  0.20077f,
   0.22570f,  0.25088f,  0.27610f,  0.30116f,  0.32586f,  0.35003f,  0.37354f,
   0.39624f,  0.41803f,  0.43884f,  0.45859f,  0.47724f,  0.49476f,  0.51114f,
   0.52639f,  0.54053f,  0.55358f,  0.56559f,  0.57660f,  0.58667f,  0.59586f,
   0.60423f,  0.61184f,  0.61876f,  0.62505f,  0.63077f,  0.63599f,  0.64076f,
   0.64513f,  0.64915f,  0.65287f,  0.65634f,  0.65958f,  0.66264f,  0.66554f,
   0.66830f,  0.67096f,  0.67352f,  0.67601f,  0.67843f,  0.68079f,  0.68311f,
   0.68538f,  0.68761f,  0.68980f,  0.69195f,  0.69406f,  0.69613f,  0.69815f,
   0.70014f,  0.70207f,  0.70396f,  0.70579f,  0.70758f,  0.70931f,  0.71100f,
   0.71263f,  0.71422f,  0.71576f,  0.71727f,  0.71874f,  0.72017f,  0.72158f,
   0.72298f,  0.72436f,  0.72573f,  0.72710f,  0.72848f,  0.72986f,  0.73127f,
   0.73269f,  0.73415f,  0.73563f,  0.73715f,  0.73871f,  0.74031f,  0.74195f,
   0.74365f,  0.74539f,  0.74720f,  0.74905f,  0.75098f,  0.75296f,  0.75502f,
   0.75715f,  0.75936f,  0.76166f,  0.76404f,  0.76652f,  0.76910f,  0.77178f,
   0.77457f,  0.77746f,  0.78047f,  0.78359f,  0.78681f,  0.79014f,  0.79357f,
   0.79710f,  0.80071f,  0.80441f,  0.80816f,  0.81198f,  0.81583f,  0.81972f,
   0.82361f,  0.82751f,  0.83139f,  0.83525f,  0.83907f,  0.84283f,  0.84653f,
   0.85016f,  0.85371f,  0.85717f,  0.86054f,  0.86381f,  0.86698f,  0.87004f,
   0.87299f,  0.87584f,  0.87857f,  0.88118f,  0.88369f,  0.88608f,  0.88836f,
   0.89053f,  0.89259f,  0.89455f,  0.89642f,  0.89820f,  0.89991f,  0.90156f,
   0.90317f,  0.90475f,  0.90634f,  0.90794f,  0.90960f,  0.91133f,  0.91317f,
   0.91514f,  0.91728f,  0.91959f,  0.92211f,  0.92485f,  0.92782f,  0.93103f,
   0.93446f,  0.93813f,  0.94200f,  0.94605f,  0.95026f,  0.95458f,  0.95898f,
   0.96341f,  0.96783f,  0.97218f,  0.97645f,  0.98057f,  0.98451f,  0.98823f,
   0.99166f,  0.99470f,  0.99721f,  0.99904f,  1.00000f},
   //---------  2.6 GeV
  {0.00070f,  0.00277f,  0.00824f,  0.01635f,  0.02700f,  0.04007f,  0.05542f,
   0.07286f,  0.09220f,  0.11323f,  0.13570f,  0.15936f,  0.18397f,  0.20926f,
   0.23498f,  0.26089f,  0.28675f,  0.31237f,  0.33754f,  0.36209f,  0.38586f,
   0.40874f,  0.43061f,  0.45138f,  0.47101f,  0.48944f,  0.50666f,  0.52267f,
   0.53748f,  0.55112f,  0.56362f,  0.57504f,  0.58544f,  0.59487f,  0.60341f,
   0.61111f,  0.61806f,  0.62431f,  0.62995f,  0.63503f,  0.63962f,  0.64377f,
   0.64755f,  0.65100f,  0.65416f,  0.65709f,  0.65981f,  0.66237f,  0.66479f,
   0.66709f,  0.66930f,  0.67143f,  0.67351f,  0.67554f,  0.67754f,  0.67950f,
   0.68144f,  0.68336f,  0.68526f,  0.68715f,  0.68902f,  0.69087f,  0.69270f,
   0.69451f,  0.69630f,  0.69807f,  0.69982f,  0.70154f,  0.70323f,  0.70491f,
   0.70655f,  0.70818f,  0.70979f,  0.71138f,  0.71296f,  0.71453f,  0.71609f,
   0.71765f,  0.71921f,  0.72078f,  0.72236f,  0.72395f,  0.72556f,  0.72719f,
   0.72884f,  0.73051f,  0.73221f,  0.73393f,  0.73568f,  0.73746f,  0.73927f,
   0.74110f,  0.74297f,  0.74487f,  0.74680f,  0.74877f,  0.75079f,  0.75285f,
   0.75496f,  0.75712f,  0.75935f,  0.76166f,  0.76404f,  0.76650f,  0.76906f,
   0.77172f,  0.77447f,  0.77734f,  0.78032f,  0.78341f,  0.78661f,  0.78993f,
   0.79334f,  0.79686f,  0.80046f,  0.80414f,  0.80789f,  0.81170f,  0.81555f,
   0.81942f,  0.82331f,  0.82719f,  0.83105f,  0.83488f,  0.83867f,  0.84239f,
   0.84605f,  0.84963f,  0.85313f,  0.85653f,  0.85983f,  0.86302f,  0.86610f,
   0.86908f,  0.87193f,  0.87467f,  0.87729f,  0.87979f,  0.88217f,  0.88444f,
   0.88659f,  0.88863f,  0.89056f,  0.89239f,  0.89414f,  0.89582f,  0.89743f,
   0.89900f,  0.90056f,  0.90212f,  0.90371f,  0.90536f,  0.90710f,  0.90896f,
   0.91096f,  0.91315f,  0.91553f,  0.91814f,  0.92099f,  0.92409f,  0.92745f,
   0.93107f,  0.93492f,  0.93901f,  0.94329f,  0.94774f,  0.95231f,  0.95697f,
   0.96166f,  0.96633f,  0.97094f,  0.97543f,  0.97977f,  0.98390f,  0.98778f,
   0.99135f,  0.99450f,  0.99711f,  0.99900f,  1.00000f},
   //---------  2.8 GeV
  {0.00073f,  0.00289f,  0.00860f,  0.01706f,  0.02817f,  0.04179f,  0.05777f,
   0.07591f,  0.09600f,  0.11781f,  0.14108f,  0.16554f,  0.19093f,  0.21697f,
   0.24340f,  0.26997f,  0.29643f,  0.32256f,  0.34817f,  0.37305f,  0.39708f,
   0.42011f,  0.44204f,  0.46280f,  0.48233f,  0.50059f,  0.51757f,  0.53327f,
   0.54771f,  0.56093f,  0.57298f,  0.58392f,  0.59380f,  0.60270f,  0.61070f,
   0.61785f,  0.62425f,  0.62997f,  0.63507f,  0.63962f,  0.64370f,  0.64735f,
   0.65064f,  0.65362f,  0.65633f,  0.65883f,  0.66113f,  0.66328f,  0.66531f,
   0.66725f,  0.66910f,  0.67090f,  0.67266f,  0.67438f,  0.67609f,  0.67778f,
   0.67947f,  0.68116f,  0.68285f,  0.68454f,  0.68624f,  0.68794f,  0.68965f,
   0.69136f,  0.69307f,  0.69478f,  0.69649f,  0.69820f,  0.69991f,  0.70161f,
   0.70332f,  0.70502f,  0.70672f,  0.70843f,  0.71014f,  0.71186f,  0.71358f,
   0.71532f,  0.71707f,  0.71883f,  0.72061f,  0.72241f,  0.72423f,  0.72606f,
   0.72791f,  0.72977f,  0.73166f,  0.73355f,  0.73545f,  0.73737f,  0.73929f,
   0.74122f,  0.74316f,  0.74511f,  0.74706f,  0.74903f,  0.75101f,  0.75301f,
   0.75504f,  0.75710f,  0.75921f,  0.76136f,  0.76358f,  0.76587f,  0.76825f,
   0.77071f,  0.77327f,  0.77594f,  0.77872f,  0.78162f,  0.78463f,  0.78777f,
   0.79102f,  0.79438f,  0.79785f,  0.80141f,  0.80505f,  0.80877f,  0.81254f,
   0.81636f,  0.82020f,  0.82405f,  0.82789f,  0.83172f,  0.83551f,  0.83925f,
   0.84293f,  0.84653f,  0.85005f,  0.85348f,  0.85681f,  0.86004f,  0.86315f,
   0.86615f,  0.86903f,  0.87179f,  0.87442f,  0.87693f,  0.87932f,  0.88159f,
   0.88373f,  0.88577f,  0.88769f,  0.88951f,  0.89124f,  0.89290f,  0.89450f,
   0.89606f,  0.89760f,  0.89916f,  0.90075f,  0.90240f,  0.90416f,  0.90604f,
   0.90809f,  0.91032f,  0.91277f,  0.91545f,  0.91839f,  0.92160f,  0.92508f,
   0.92883f,  0.93283f,  0.93708f,  0.94153f,  0.94616f,  0.95091f,  0.95575f,
   0.96063f,  0.96548f,  0.97025f,  0.97489f,  0.97936f,  0.98360f,  0.98757f,
   0.99121f,  0.99442f,  0.99707f,  0.99898f,  1.00000f},
   //---------  3.0 GeV
  {0.00076f,  0.00300f,  0.00892f,  0.01769f,  0.02919f,  0.04329f,  0.05981f,
   0.07854f,  0.09927f,  0.12174f,  0.14569f,  0.17082f,  0.19686f,  0.22353f,
   0.25054f,  0.27764f,  0.30457f,  0.33111f,  0.35706f,  0.38222f,  0.40644f,
   0.42960f,  0.45158f,  0.47231f,  0.49173f,  0.50983f,  0.52659f,  0.54202f,
   0.55615f,  0.56902f,  0.58069f,  0.59122f,  0.60068f,  0.60915f,  0.61670f,
   0.62342f,  0.62938f,  0.63466f,  0.63934f,  0.64349f,  0.64717f,  0.65044f,
   0.65337f,  0.65600f,  0.65838f,  0.66056f,  0.66257f,  0.66444f,  0.66621f,
   0.66790f,  0.66953f,  0.67112f,  0.67268f,  0.67424f,  0.67579f,  0.67735f,
   0.67893f,  0.68052f,  0.68214f,  0.68378f,  0.68544f,  0.68713f,  0.68884f,
   0.69058f,  0.69234f,  0.69412f,  0.69592f,  0.69773f,  0.69956f,  0.70141f,
   0.70327f,  0.70514f,  0.70702f,  0.70892f,  0.71083f,  0.71276f,  0.71470f,
   0.71666f,  0.71863f,  0.72061f,  0.72262f,  0.72463f,  0.72666f,  0.72869f,
   0.73074f,  0.73278f,  0.73483f,  0.73687f,  0.73890f,  0.74092f,  0.74293f,
   0.74492f,  0.74688f,  0.74883f,  0.75076f,  0.75267f,  0.75457f,  0.75646f,
   0.75835f,  0.76025f,  0.76217f,  0.76412f,  0.76611f,  0.76815f,  0.77027f,
   0.77246f,  0.77475f,  0.77714f,  0.77964f,  0.78226f,  0.78500f,  0.78787f,
   0.79086f,  0.79397f,  0.79721f,  0.80055f,  0.80399f,  0.80753f,  0.81113f,
   0.81479f,  0.81850f,  0.82224f,  0.82598f,  0.82972f,  0.83343f,  0.83711f,
   0.84074f,  0.84431f,  0.84781f,  0.85122f,  0.85454f,  0.85776f,  0.86087f,
   0.86387f,  0.86676f,  0.86953f,  0.87218f,  0.87470f,  0.87711f,  0.87939f,
   0.88155f,  0.88360f,  0.88554f,  0.88738f,  0.88914f,  0.89082f,  0.89244f,
   0.89403f,  0.89560f,  0.89719f,  0.89882f,  0.90052f,  0.90233f,  0.90426f,
   0.90637f,  0.90867f,  0.91119f,  0.91396f,  0.91699f,  0.92030f,  0.92388f,
   0.92774f,  0.93186f,  0.93622f,  0.94079f,  0.94554f,  0.95041f,  0.95537f,
   0.96035f,  0.96529f,  0.97015f,  0.97486f,  0.97938f,  0.98365f,  0.98763f,
   0.99126f,  0.99445f,  0.99708f,  0.99899f,  1.00000f},
   //---------  3.4 GeV
  {0.00079f,  0.00310f,  0.00922f,  0.01828f,  0.03014f,  0.04465f,  0.06161f,
   0.08081f,  0.10201f,  0.12494f,  0.14932f,  0.17485f,  0.20124f,  0.22819f,
   0.25542f,  0.28267f,  0.30967f,  0.33619f,  0.36203f,  0.38701f,  0.41098f,
   0.43380f,  0.45539f,  0.47567f,  0.49459f,  0.51214f,  0.52831f,  0.54314f,
   0.55665f,  0.56889f,  0.57993f,  0.58985f,  0.59871f,  0.60661f,  0.61362f,
   0.61982f,  0.62530f,  0.63014f,  0.63442f,  0.63820f,  0.64155f,  0.64454f,
   0.64722f,  0.64964f,  0.65185f,  0.65389f,  0.65580f,  0.65761f,  0.65935f,
   0.66105f,  0.66273f,  0.66440f,  0.66609f,  0.66781f,  0.66957f,  0.67138f,
   0.67325f,  0.67518f,  0.67717f,  0.67923f,  0.68136f,  0.68355f,  0.68581f,
   0.68813f,  0.69051f,  0.69294f,  0.69541f,  0.69793f,  0.70048f,  0.70307f,
   0.70568f,  0.70832f,  0.71097f,  0.71364f,  0.71632f,  0.71901f,  0.72170f,
   0.72439f,  0.72708f,  0.72976f,  0.73243f,  0.73508f,  0.73771f,  0.74031f,
   0.74288f,  0.74541f,  0.74789f,  0.75031f,  0.75267f,  0.75497f,  0.75719f,
   0.75933f,  0.76138f,  0.76336f,  0.76525f,  0.76706f,  0.76879f,  0.77045f,
   0.77206f,  0.77361f,  0.77513f,  0.77663f,  0.77813f,  0.77964f,  0.78119f,
   0.78279f,  0.78446f,  0.78621f,  0.78806f,  0.79003f,  0.79213f,  0.79436f,
   0.79672f,  0.79923f,  0.80188f,  0.80466f,  0.80757f,  0.81060f,  0.81373f,
   0.81697f,  0.82028f,  0.82365f,  0.82708f,  0.83053f,  0.83400f,  0.83747f,
   0.84093f,  0.84435f,  0.84773f,  0.85106f,  0.85432f,  0.85751f,  0.86062f,
   0.86364f,  0.86656f,  0.86938f,  0.87210f,  0.87471f,  0.87721f,  0.87959f,
   0.88187f,  0.88405f,  0.88612f,  0.88810f,  0.88999f,  0.89182f,  0.89359f,
   0.89532f,  0.89704f,  0.89877f,  0.90054f,  0.90237f,  0.90431f,  0.90637f,
   0.90859f,  0.91099f,  0.91361f,  0.91646f,  0.91956f,  0.92293f,  0.92655f,
   0.93044f,  0.93456f,  0.93892f,  0.94346f,  0.94816f,  0.95296f,  0.95783f,
   0.96269f,  0.96750f,  0.97218f,  0.97670f,  0.98099f,  0.98500f,  0.98870f,
   0.99204f,  0.99496f,  0.99735f,  0.99908f,  1.00000f},
   //---------  3.8 GeV
  {0.00077f,  0.00304f,  0.00904f,  0.01792f,  0.02952f,  0.04371f,  0.06028f,
   0.07902f,  0.09967f,  0.12198f,  0.14567f,  0.17043f,  0.19598f,  0.22204f,
   0.24832f,  0.27455f,  0.30049f,  0.32592f,  0.35063f,  0.37445f,  0.39725f,
   0.41890f,  0.43933f,  0.45845f,  0.47625f,  0.49269f,  0.50780f,  0.52161f,
   0.53414f,  0.54547f,  0.55565f,  0.56477f,  0.57289f,  0.58010f,  0.58649f,
   0.59213f,  0.59710f,  0.60149f,  0.60536f,  0.60879f,  0.61183f,  0.61455f,
   0.61700f,  0.61923f,  0.62129f,  0.62322f,  0.62505f,  0.62681f,  0.62855f,
   0.63028f,  0.63203f,  0.63382f,  0.63567f,  0.63760f,  0.63961f,  0.64173f,
   0.64396f,  0.64630f,  0.64877f,  0.65136f,  0.65407f,  0.65691f,  0.65986f,
   0.66293f,  0.66611f,  0.66939f,  0.67276f,  0.67621f,  0.67975f,  0.68334f,
   0.68700f,  0.69071f,  0.69446f,  0.69825f,  0.70206f,  0.70590f,  0.70974f,
   0.71360f,  0.71744f,  0.72128f,  0.72510f,  0.72889f,  0.73264f,  0.73634f,
   0.73999f,  0.74356f,  0.74705f,  0.75044f,  0.75372f,  0.75689f,  0.75993f,
   0.76284f,  0.76560f,  0.76821f,  0.77067f,  0.77299f,  0.77516f,  0.77719f,
   0.77909f,  0.78088f,  0.78257f,  0.78418f,  0.78573f,  0.78724f,  0.78873f,
   0.79024f,  0.79178f,  0.79338f,  0.79506f,  0.79684f,  0.79873f,  0.80076f,
   0.80292f,  0.80524f,  0.80771f,  0.81033f,  0.81311f,  0.81603f,  0.81909f,
   0.82228f,  0.82558f,  0.82897f,  0.83245f,  0.83599f,  0.83957f,  0.84318f,
   0.84680f,  0.85042f,  0.85401f,  0.85756f,  0.86106f,  0.86450f,  0.86786f,
   0.87113f,  0.87430f,  0.87737f,  0.88032f,  0.88315f,  0.88585f,  0.88842f,
   0.89086f,  0.89318f,  0.89536f,  0.89742f,  0.89937f,  0.90122f,  0.90298f,
   0.90467f,  0.90632f,  0.90795f,  0.90959f,  0.91126f,  0.91300f,  0.91484f,
   0.91681f,  0.91894f,  0.92126f,  0.92379f,  0.92655f,  0.92956f,  0.93281f,
   0.93631f,  0.94004f,  0.94400f,  0.94814f,  0.95244f,  0.95685f,  0.96131f,
   0.96579f,  0.97022f,  0.97454f,  0.97869f,  0.98264f,  0.98632f,  0.98970f,
   0.99274f,  0.99540f,  0.99757f,  0.99916f,  1.00000f},
   //---------  4.2 GeV
  {0.00078f,  0.00307f,  0.00913f,  0.01809f,  0.02982f,  0.04417f,  0.06093f,
   0.07989f,  0.10079f,  0.12334f,  0.14725f,  0.17223f,  0.19797f,  0.22417f,
   0.25054f,  0.27681f,  0.30272f,  0.32806f,  0.35261f,  0.37621f,  0.39871f,
   0.42000f,  0.43999f,  0.45863f,  0.47589f,  0.49175f,  0.50624f,  0.51940f,
   0.53127f,  0.54191f,  0.55141f,  0.55983f,  0.56728f,  0.57382f,  0.57956f,
   0.58458f,  0.58897f,  0.59280f,  0.59615f,  0.59910f,  0.60170f,  0.60402f,
   0.60612f,  0.60804f,  0.60983f,  0.61153f,  0.61318f,  0.61480f,  0.61643f,
   0.61809f,  0.61981f,  0.62160f,  0.62348f,  0.62545f,  0.62754f,  0.62975f,
   0.63208f,  0.63453f,  0.63711f,  0.63981f,  0.64263f,  0.64556f,  0.64860f,
   0.65173f,  0.65495f,  0.65825f,  0.66162f,  0.66506f,  0.66855f,  0.67209f,
   0.67567f,  0.67929f,  0.68294f,  0.68663f,  0.69035f,  0.69409f,  0.69787f,
   0.70167f,  0.70550f,  0.70935f,  0.71322f,  0.71711f,  0.72101f,  0.72491f,
   0.72881f,  0.73269f,  0.73653f,  0.74033f,  0.74407f,  0.74773f,  0.75129f,
   0.75476f,  0.75810f,  0.76130f,  0.76437f,  0.76728f,  0.77004f,  0.77265f,
   0.77511f,  0.77742f,  0.77960f,  0.78166f,  0.78362f,  0.78550f,  0.78731f,
   0.78909f,  0.79086f,  0.79264f,  0.79445f,  0.79632f,  0.79827f,  0.80031f,
   0.80246f,  0.80474f,  0.80714f,  0.80968f,  0.81235f,  0.81516f,  0.81809f,
   0.82114f,  0.82430f,  0.82755f,  0.83087f,  0.83426f,  0.83770f,  0.84116f,
   0.84464f,  0.84811f,  0.85156f,  0.85497f,  0.85834f,  0.86164f,  0.86486f,
   0.86800f,  0.87104f,  0.87397f,  0.87679f,  0.87949f,  0.88207f,  0.88451f,
   0.88683f,  0.88902f,  0.89108f,  0.89303f,  0.89486f,  0.89660f,  0.89827f,
   0.89987f,  0.90144f,  0.90299f,  0.90457f,  0.90620f,  0.90791f,  0.90974f,
   0.91171f,  0.91387f,  0.91624f,  0.91884f,  0.92169f,  0.92481f,  0.92820f,
   0.93186f,  0.93578f,  0.93993f,  0.94430f,  0.94884f,  0.95352f,  0.95826f,
   0.96303f,  0.96776f,  0.97239f,  0.97686f,  0.98111f,  0.98509f,  0.98876f,
   0.99206f,  0.99495f,  0.99734f,  0.99907f,  1.00000f},
   //---------  4.6 GeV
  {0.00078f,  0.00309f,  0.00920f,  0.01824f,  0.03008f,  0.04457f,  0.06151f,
   0.08066f,  0.10176f,  0.12452f,  0.14865f,  0.17384f,  0.19977f,  0.22615f,
   0.25267f,  0.27907f,  0.30508f,  0.33048f,  0.35506f,  0.37866f,  0.40112f,
   0.42234f,  0.44222f,  0.46073f,  0.47784f,  0.49353f,  0.50784f,  0.52079f,
   0.53245f,  0.54288f,  0.55216f,  0.56037f,  0.56760f,  0.57395f,  0.57951f,
   0.58435f,  0.58858f,  0.59227f,  0.59550f,  0.59835f,  0.60087f,  0.60314f,
   0.60520f,  0.60711f,  0.60892f,  0.61066f,  0.61237f,  0.61408f,  0.61583f,
   0.61763f,  0.61950f,  0.62147f,  0.62355f,  0.62574f,  0.62806f,  0.63050f,
   0.63308f,  0.63577f,  0.63859f,  0.64153f,  0.64456f,  0.64770f,  0.65091f,
   0.65419f,  0.65753f,  0.66092f,  0.66433f,  0.66778f,  0.67123f,  0.67470f,
   0.67817f,  0.68165f,  0.68512f,  0.68860f,  0.69209f,  0.69559f,  0.69911f,
   0.70264f,  0.70621f,  0.70981f,  0.71344f,  0.71711f,  0.72081f,  0.72455f,
   0.72830f,  0.73208f,  0.73585f,  0.73962f,  0.74335f,  0.74705f,  0.75068f,
   0.75423f,  0.75768f,  0.76102f,  0.76422f,  0.76729f,  0.77020f,  0.77295f,
   0.77555f,  0.77799f,  0.78028f,  0.78244f,  0.78448f,  0.78641f,  0.78826f,
   0.79005f,  0.79180f,  0.79355f,  0.79531f,  0.79711f,  0.79897f,  0.80092f,
   0.80296f,  0.80511f,  0.80739f,  0.80979f,  0.81233f,  0.81499f,  0.81777f,
   0.82067f,  0.82367f,  0.82677f,  0.82993f,  0.83315f,  0.83641f,  0.83970f,
   0.84298f,  0.84626f,  0.84950f,  0.85270f,  0.85584f,  0.85890f,  0.86188f,
   0.86477f,  0.86755f,  0.87022f,  0.87278f,  0.87521f,  0.87752f,  0.87971f,
   0.88178f,  0.88373f,  0.88557f,  0.88731f,  0.88897f,  0.89055f,  0.89207f,
   0.89357f,  0.89505f,  0.89656f,  0.89812f,  0.89976f,  0.90152f,  0.90342f,
   0.90551f,  0.90780f,  0.91033f,  0.91313f,  0.91620f,  0.91956f,  0.92321f,
   0.92716f,  0.93137f,  0.93584f,  0.94053f,  0.94540f,  0.95041f,  0.95549f,
   0.96059f,  0.96565f,  0.97059f,  0.97536f,  0.97990f,  0.98414f,  0.98805f,
   0.99157f,  0.99464f,  0.99717f,  0.99901f,  1.00000f},
   //---------  5.0 GeV
  {0.00079f,  0.00311f,  0.00924f,  0.01833f,  0.03024f,  0.04481f,  0.06184f,
   0.08109f,  0.10230f,  0.12518f,  0.14941f,  0.17470f,  0.20071f,  0.22715f,
   0.25372f,  0.28014f,  0.30616f,  0.33154f,  0.35608f,  0.37960f,  0.40197f,
   0.42308f,  0.44285f,  0.46121f,  0.47816f,  0.49369f,  0.50783f,  0.52061f,
   0.53209f,  0.54235f,  0.55146f,  0.55951f,  0.56660f,  0.57280f,  0.57823f,
   0.58295f,  0.58707f,  0.59067f,  0.59382f,  0.59660f,  0.59907f,  0.60130f,
   0.60334f,  0.60524f,  0.60706f,  0.60882f,  0.61058f,  0.61236f,  0.61419f,
   0.61609f,  0.61809f,  0.62020f,  0.62244f,  0.62481f,  0.62732f,  0.62996f,
   0.63275f,  0.63566f,  0.63870f,  0.64185f,  0.64510f,  0.64843f,  0.65182f,
   0.65526f,  0.65873f,  0.66222f,  0.66571f,  0.66919f,  0.67265f,  0.67608f,
   0.67948f,  0.68284f,  0.68618f,  0.68949f,  0.69278f,  0.69606f,  0.69935f,
   0.70264f,  0.70596f,  0.70931f,  0.71271f,  0.71615f,  0.71965f,  0.72319f,
   0.72679f,  0.73043f,  0.73410f,  0.73779f,  0.74148f,  0.74515f,  0.74879f,
   0.75237f,  0.75587f,  0.75927f,  0.76256f,  0.76571f,  0.76871f,  0.77155f,
   0.77424f,  0.77676f,  0.77912f,  0.78134f,  0.78343f,  0.78539f,  0.78726f,
   0.78906f,  0.79081f,  0.79254f,  0.79427f,  0.79604f,  0.79786f,  0.79976f,
   0.80175f,  0.80386f,  0.80608f,  0.80843f,  0.81092f,  0.81353f,  0.81626f,
   0.81911f,  0.82206f,  0.82509f,  0.82820f,  0.83135f,  0.83454f,  0.83774f,
   0.84094f,  0.84411f,  0.84724f,  0.85031f,  0.85330f,  0.85621f,  0.85903f,
   0.86174f,  0.86434f,  0.86682f,  0.86919f,  0.87143f,  0.87355f,  0.87555f,
   0.87744f,  0.87923f,  0.88092f,  0.88252f,  0.88406f,  0.88554f,  0.88699f,
   0.88844f,  0.88990f,  0.89142f,  0.89300f,  0.89470f,  0.89654f,  0.89855f,
   0.90076f,  0.90321f,  0.90591f,  0.90889f,  0.91217f,  0.91575f,  0.91963f,
   0.92382f,  0.92828f,  0.93300f,  0.93794f,  0.94307f,  0.94833f,  0.95366f,
   0.95900f,  0.96429f,  0.96945f,  0.97443f,  0.97916f,  0.98357f,  0.98763f,
   0.99127f,  0.99445f,  0.99707f,  0.99898f,  1.00000}
 };

 // CM momentum (GeV/c)
 const G4float G4LEnp::pcm[NENERGY] = {
   0.685E-01f, 0.969E-01f, 0.119f, 0.153f, 0.181f, 0.217f, 0.256f,
   0.291f, 0.336f, 0.399f, 0.444f, 0.484f, 0.522f, 0.539f,
   0.565f, 0.589f, 0.613f, 0.650f, 0.685f, 0.718f, 0.750f,
   0.781f, 0.810f, 0.839f, 0.866f, 0.893f, 0.919f, 0.944f,
   0.969f, 1.016f, 1.061f, 1.104f, 1.146f, 1.186f, 1.263f,
   1.335f, 1.404f, 1.469f, 1.532f
};

 // Lab energy (GeV)
 const G4float G4LEnp::elab[NENERGY] = {
   0.100E-01f, 0.200E-01f, 0.300E-01f, 0.500E-01f, 0.700E-01f, 0.100f, 0.140f,
   0.180f, 0.240f, 0.340f, 0.420f, 0.500f, 0.580f, 0.620f,
   0.680f, 0.740f, 0.800f, 0.900f,  1.00f,  1.10f, 1.200f,    
   1.300f, 1.400f, 1.500f, 1.600f, 1.700f, 1.800f, 1.900f,
   2.000f, 2.200f, 2.400f, 2.600f, 2.800f, 3.000f, 3.400f,
   3.800f, 4.200f, 4.600f, 5.000f
};

 // Max dsigma/domega-CM (mb/sr)
 const G4float G4LEnp::dsigmax[NENERGY] = {
   79.0f,  43.0f,  29.8f,  20.0f,  16.3f,  14.5f,  13.3f,
   12.6f,  11.9f,  11.3f,  11.1f,  10.7f,  9.69f,  10.1f,
   11.4f,  12.5f,  13.3f,  14.5f,  15.6f,  16.9f,  18.3f,
   20.070f, 21.620f, 23.090f, 24.460f, 25.710f, 26.870f, 27.950f,
   28.990f, 30.950f, 32.790f, 34.570f, 36.370f, 38.090f, 40.810f,
   40.950f, 40.230f, 39.840f, 39.010f
};


 // Total cross section
 const G4float G4LEnp::sigtot[NENERGY] = {
   947.f,  485.f,  310.f,  168.f,  110.f,  75.7f,  55.2f,
   45.9f,  39.1f,  34.1f,  32.3f,  31.3f,  30.1f,  29.5f,
   28.4f,  27.4f,  26.4f,  24.8f,  23.4f,  22.4f,  21.9f,
   22.074f, 22.182f, 22.380f, 22.589f, 22.777f, 22.939f, 23.072f,
   23.182f, 23.339f, 23.443f, 23.561f, 23.752f, 23.996f, 24.841f,
   25.406f, 24.742f, 24.314f, 23.695f
};
