//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Direction to search for an NSAccessibilityCustomRotorItemResult.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitycustomrotorsearchdirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSAccessibilityCustomRotorSearchDirection(pub NSInteger);
impl NSAccessibilityCustomRotorSearchDirection {
    #[doc(alias = "NSAccessibilityCustomRotorSearchDirectionPrevious")]
    pub const Previous: Self = Self(0);
    #[doc(alias = "NSAccessibilityCustomRotorSearchDirectionNext")]
    pub const Next: Self = Self(1);
}

unsafe impl Encode for NSAccessibilityCustomRotorSearchDirection {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSAccessibilityCustomRotorSearchDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Use NSAccessibilityCustomRotorType when providing results for the
/// following types. This allows assistive technologies to assign keyboard
/// commands and gestures for these common search types.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitycustomrotortype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSAccessibilityCustomRotorType(pub NSInteger);
impl NSAccessibilityCustomRotorType {
    #[doc(alias = "NSAccessibilityCustomRotorTypeCustom")]
    pub const Custom: Self = Self(0);
    #[doc(alias = "NSAccessibilityCustomRotorTypeAny")]
    pub const Any: Self = Self(1);
    #[doc(alias = "NSAccessibilityCustomRotorTypeAnnotation")]
    pub const Annotation: Self = Self(2);
    #[doc(alias = "NSAccessibilityCustomRotorTypeBoldText")]
    pub const BoldText: Self = Self(3);
    #[doc(alias = "NSAccessibilityCustomRotorTypeHeading")]
    pub const Heading: Self = Self(4);
    #[doc(alias = "NSAccessibilityCustomRotorTypeHeadingLevel1")]
    pub const HeadingLevel1: Self = Self(5);
    #[doc(alias = "NSAccessibilityCustomRotorTypeHeadingLevel2")]
    pub const HeadingLevel2: Self = Self(6);
    #[doc(alias = "NSAccessibilityCustomRotorTypeHeadingLevel3")]
    pub const HeadingLevel3: Self = Self(7);
    #[doc(alias = "NSAccessibilityCustomRotorTypeHeadingLevel4")]
    pub const HeadingLevel4: Self = Self(8);
    #[doc(alias = "NSAccessibilityCustomRotorTypeHeadingLevel5")]
    pub const HeadingLevel5: Self = Self(9);
    #[doc(alias = "NSAccessibilityCustomRotorTypeHeadingLevel6")]
    pub const HeadingLevel6: Self = Self(10);
    #[doc(alias = "NSAccessibilityCustomRotorTypeImage")]
    pub const Image: Self = Self(11);
    #[doc(alias = "NSAccessibilityCustomRotorTypeItalicText")]
    pub const ItalicText: Self = Self(12);
    #[doc(alias = "NSAccessibilityCustomRotorTypeLandmark")]
    pub const Landmark: Self = Self(13);
    #[doc(alias = "NSAccessibilityCustomRotorTypeLink")]
    pub const Link: Self = Self(14);
    #[doc(alias = "NSAccessibilityCustomRotorTypeList")]
    pub const List: Self = Self(15);
    #[doc(alias = "NSAccessibilityCustomRotorTypeMisspelledWord")]
    pub const MisspelledWord: Self = Self(16);
    #[doc(alias = "NSAccessibilityCustomRotorTypeTable")]
    pub const Table: Self = Self(17);
    #[doc(alias = "NSAccessibilityCustomRotorTypeTextField")]
    pub const TextField: Self = Self(18);
    #[doc(alias = "NSAccessibilityCustomRotorTypeUnderlinedText")]
    pub const UnderlinedText: Self = Self(19);
    #[doc(alias = "NSAccessibilityCustomRotorTypeVisitedLink")]
    pub const VisitedLink: Self = Self(20);
    #[doc(alias = "NSAccessibilityCustomRotorTypeAudiograph")]
    pub const Audiograph: Self = Self(21);
}

unsafe impl Encode for NSAccessibilityCustomRotorType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSAccessibilityCustomRotorType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// NSAccessibilityCustomRotors allow assistive technologies, like
    /// VoiceOver, to search applications for content related to the given label.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitycustomrotor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSAccessibilityCustomRotor;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSAccessibilityCustomRotor {}
);

impl NSAccessibilityCustomRotor {
    extern_methods!(
        /// Convenience initializer that uses
        /// NSAccessibilityCustomRotorTypeCustom as the default rotor type. Use this
        /// initializer for custom rotors that are not one of the common types.
        #[unsafe(method(initWithLabel:itemSearchDelegate:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithLabel_itemSearchDelegate(
            this: Allocated<Self>,
            label: &NSString,
            item_search_delegate: &ProtocolObject<dyn NSAccessibilityCustomRotorItemSearchDelegate>,
        ) -> Retained<Self>;

        /// Convenience initializer for custom rotors that use a common type
        /// such as links, headings, etc. A default label will be provided.
        #[unsafe(method(initWithRotorType:itemSearchDelegate:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRotorType_itemSearchDelegate(
            this: Allocated<Self>,
            rotor_type: NSAccessibilityCustomRotorType,
            item_search_delegate: &ProtocolObject<dyn NSAccessibilityCustomRotorItemSearchDelegate>,
        ) -> Retained<Self>;

        /// The rotor type to provide results for.
        ///
        /// The default type is NSAccessibilityCustomRotorTypeCustom, unless
        /// the rotor type was specified in the initializer.
        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub unsafe fn r#type(&self) -> NSAccessibilityCustomRotorType;

        /// Setter for [`type`][Self::type].
        #[unsafe(method(setType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setType(&self, r#type: NSAccessibilityCustomRotorType);

        /// The localized label assistive technologies will use to describe
        /// the custom rotor.
        ///
        /// The label is only used when the rotor type is
        /// NSAccessibilityCustomRotorTypeCustom since a default is provided
        /// for all other types.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        pub unsafe fn label(&self) -> Retained<NSString>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLabel(&self, label: &NSString);

        /// The itemSearchDelegate will be asked to find the next item result
        /// after performing a search with the given search parameters.
        #[unsafe(method(itemSearchDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemSearchDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSAccessibilityCustomRotorItemSearchDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`itemSearchDelegate`][Self::itemSearchDelegate].
        #[unsafe(method(setItemSearchDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItemSearchDelegate(
            &self,
            item_search_delegate: Option<
                &ProtocolObject<dyn NSAccessibilityCustomRotorItemSearchDelegate>,
            >,
        );

        #[cfg(feature = "NSAccessibilityProtocols")]
        /// Provide an item load delegate if the rotor vends item results that
        /// do not have a backing UI element yet. The loader will be asked to load an
        /// element via the accessibilityElementWithToken protocol method when the
        /// item result is selected by an assistive client. Applications can use the
        /// item result's token to determine which item to return.
        #[unsafe(method(itemLoadingDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemLoadingDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSAccessibilityElementLoading>>>;

        #[cfg(feature = "NSAccessibilityProtocols")]
        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`itemLoadingDelegate`][Self::itemLoadingDelegate].
        #[unsafe(method(setItemLoadingDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItemLoadingDelegate(
            &self,
            item_loading_delegate: Option<&ProtocolObject<dyn NSAccessibilityElementLoading>>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl NSAccessibilityCustomRotor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// NSAccessibilityCustomRotorSearchParameters is a container for
    /// search parameters. It should be examined to determine the next matching
    /// NSAccessibilityCustomRotorItemResult.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitycustomrotorsearchparameters?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSAccessibilityCustomRotorSearchParameters;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSAccessibilityCustomRotorSearchParameters {}
);

impl NSAccessibilityCustomRotorSearchParameters {
    extern_methods!(
        /// The currentItem determines where the search will start from. If
        /// it is nil, the search should begin from, and include, the first or last
        /// item, depending on which search direction is used (e.g. search direction
        /// next will return the first item and previous will return the last item).
        #[unsafe(method(currentItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentItem(&self) -> Option<Retained<NSAccessibilityCustomRotorItemResult>>;

        /// Setter for [`currentItem`][Self::currentItem].
        #[unsafe(method(setCurrentItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCurrentItem(
            &self,
            current_item: Option<&NSAccessibilityCustomRotorItemResult>,
        );

        /// Either NSAccessibilityCustomRotorSearchDirectionPrevious or
        /// NSAccessibilityCustomRotorSearchDirectionNext.
        #[unsafe(method(searchDirection))]
        #[unsafe(method_family = none)]
        pub unsafe fn searchDirection(&self) -> NSAccessibilityCustomRotorSearchDirection;

        /// Setter for [`searchDirection`][Self::searchDirection].
        #[unsafe(method(setSearchDirection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSearchDirection(
            &self,
            search_direction: NSAccessibilityCustomRotorSearchDirection,
        );

        /// A string of text to filter the results against. This is used to get
        /// type-ahead results. For example, given a list of primary colors and filter
        /// text "Re", color item "Red" would be returned as a result.
        #[unsafe(method(filterString))]
        #[unsafe(method_family = none)]
        pub unsafe fn filterString(&self) -> Retained<NSString>;

        /// Setter for [`filterString`][Self::filterString].
        #[unsafe(method(setFilterString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFilterString(&self, filter_string: &NSString);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSAccessibilityCustomRotorSearchParameters {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// NSAccessibilityCustomRotorItemResults are the objects returned
    /// to assistive technologies that match a search parameter criteria.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitycustomrotoritemresult?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSAccessibilityCustomRotorItemResult;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSAccessibilityCustomRotorItemResult {}
);

impl NSAccessibilityCustomRotorItemResult {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSAccessibilityProtocols")]
        /// Creates an item result with a given target element. Assistive
        /// technologies may try to set accessibility focus on the element.
        #[unsafe(method(initWithTargetElement:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTargetElement(
            this: Allocated<Self>,
            target_element: &ProtocolObject<dyn NSAccessibilityElementProtocol>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Creates an item result with a given item load token and custom label.
        /// Use this initializer if the application has not yet loaded the element
        /// backing the item result.
        #[unsafe(method(initWithItemLoadingToken:customLabel:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithItemLoadingToken_customLabel(
            this: Allocated<Self>,
            item_loading_token: &NSAccessibilityLoadingToken,
            custom_label: &NSString,
        ) -> Retained<Self>;

        #[cfg(feature = "NSAccessibilityProtocols")]
        /// A target element references an element that will be messaged for
        /// other accessibility properties. If it is not nil, assistive technologies
        /// may try to set accessibility focus on it.
        #[unsafe(method(targetElement))]
        #[unsafe(method_family = none)]
        pub unsafe fn targetElement(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSAccessibilityElementProtocol>>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Provide an item load token if the application has not yet
        /// loaded the element backing the item result. Application can use the token
        /// to determine which item to return.
        #[unsafe(method(itemLoadingToken))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemLoadingToken(&self) -> Option<Retained<NSAccessibilityLoadingToken>>;

        /// For text-based elements such as an NSTextView, this is an NSRange
        /// that specifies the area of interest. If the target range has NSNotFound
        /// for the location, the search should begin from the first or last character
        /// of the text element, depending on the search direction.
        #[unsafe(method(targetRange))]
        #[unsafe(method_family = none)]
        pub unsafe fn targetRange(&self) -> NSRange;

        /// Setter for [`targetRange`][Self::targetRange].
        #[unsafe(method(setTargetRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTargetRange(&self, target_range: NSRange);

        /// A localized label that can be used instead of the default item
        /// label to describe the item result.
        ///
        /// Required if using the loader-based initializer. Optional otherwise.
        #[unsafe(method(customLabel))]
        #[unsafe(method_family = none)]
        pub unsafe fn customLabel(&self) -> Option<Retained<NSString>>;

        /// Setter for [`customLabel`][Self::customLabel].
        #[unsafe(method(setCustomLabel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCustomLabel(&self, custom_label: Option<&NSString>);
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitycustomrotoritemsearchdelegate?language=objc)
    pub unsafe trait NSAccessibilityCustomRotorItemSearchDelegate: NSObjectProtocol {
        /// Returns the found NSAccessibilityCustomRotorItemResult after
        /// performing a search with the given search parameters.
        #[unsafe(method(rotor:resultForSearchParameters:))]
        #[unsafe(method_family = none)]
        unsafe fn rotor_resultForSearchParameters(
            &self,
            rotor: &NSAccessibilityCustomRotor,
            search_parameters: &NSAccessibilityCustomRotorSearchParameters,
        ) -> Option<Retained<NSAccessibilityCustomRotorItemResult>>;
    }
);
