# Directory Documentation for `ebnf`

## Description
This package provides classes used to manage [Extended Backus–Naur Form (EBNF) Diagram](https://plantuml.com/ebnf).

## Link
- [Extended Backus–Naur Form (EBNF) Diagram](https://plantuml.com/ebnf)

## Reference
### Internal Reference
- [QA-16529](https://forum.plantuml.net/16529/could-we-add-syntax-diagrams)

### External Reference
- [Syntax diagram _(on Wikipedia)_](https://en.wikipedia.org/wiki/Syntax_diagram)
- [Extended Backus–Naur Form (EBNF) _(on Wikipedia)_](https://en.wikipedia.org/wiki/Extended_Backus%E2%80%93Naur_form)
- [ISO/IEC 14977 : 1996(E)](http://www.cl.cam.ac.uk/~mgk25/iso-14977.pdf)

## See also
- [PlantUML Regular expression (Regex) Diagram](https://plantuml.com/regex)
- [`regexdiagram`](../regexdiagram/) _(directory on plantuml)_

## Misc.
- [Shunting yard algorithm](https://en.wikipedia.org/wiki/Shunting_yard_algorithm)
