// This generates MIRROR_FUNCS.md
package main

import (
	"bytes"
	"fmt"
	"sort"
	"strings"

	"github.com/butuzov/mirror"
)

func main() {
	seen, keys := map[string]bool{}, map[string]string{}
	c := chaining(
		mirror.BufioMethods,
		mirror.BytesBufferMethods,
		mirror.BytesFunctions,
		mirror.HTTPTestMethods,
		mirror.MaphashFunctions,
		mirror.MaphashMethods,
		mirror.OsFileMethods,
		mirror.RegexpFunctions,
		mirror.RegexpRegexpMethods,
		mirror.StringFunctions,
		mirror.StringsBuilderMethods,
		mirror.UTF8Functions,
	)

	// Create callers and sort them
	for v := range c {
		a, b := formCaller(v), formAltCaller(v)

		if !seen[a] {
			seen[a] = true
			seen[b] = true
			keys[a] = b
		}

		if !seen[b] {
			seen[b] = true
			seen[a] = true
			keys[b] = a
		}
	}

	sortKeys := []string{}
	for k := range keys {
		sortKeys = append(sortKeys, k)
	}

	sort.Slice(sortKeys, func(i, j int) bool {
		return strings.Compare(cleanSortKey(sortKeys[i]), cleanSortKey(sortKeys[j])) < 0
	})

	var bb bytes.Buffer

	fmt.Fprintf(&bb, "<!-- This file is @generated by mirror-table, do not edit it manually -->\n\n")
	fmt.Fprint(&bb, `| Function | Mirror |
|----------|--------|
`)
	for _, k := range sortKeys {
		fmt.Fprintf(&bb, "| `%s` | `%s` |\n", k, keys[k])
	}

	fmt.Print(bb.String())
}
