/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.bam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.classfile.Signature;

public class BamCacheImpl<SignatureT extends Signature>
implements BamCache<SignatureT> {
    private final Map<HashKey, BlockAbstraction> cache = new HashMap<HashKey, BlockAbstraction>();

    @Override
    public void put(AbstractState stateKey, Precision precisionKey, SignatureT blockKey, BlockAbstraction blockAbstraction) {
        this.cache.put(this.getHashKey(stateKey, precisionKey, blockKey), blockAbstraction);
    }

    @Override
    public BlockAbstraction get(AbstractState stateKey, Precision precisionKey, SignatureT blockKey) {
        return this.cache.get(this.getHashKey(stateKey, precisionKey, blockKey));
    }

    public Set<HashKey> getKeySet() {
        return this.cache.keySet();
    }

    public List<BlockAbstraction> getBySignature(SignatureT signature) {
        List<HashKey> methodKeys = this.cache.keySet().stream().filter(k -> ((HashKey)k).blockKey.equals(signature)).collect(Collectors.toList());
        ArrayList<BlockAbstraction> res = new ArrayList<BlockAbstraction>();
        methodKeys.forEach(k -> res.add(this.cache.get(k)));
        return res;
    }

    @Override
    public Collection<BlockAbstraction> values() {
        return this.cache.values();
    }

    private HashKey getHashKey(AbstractState stateKey, Precision precisionKey, SignatureT blockKey) {
        return new HashKey(stateKey, precisionKey, (Signature)blockKey);
    }

    private static class HashKey {
        private final AbstractState stateKey;
        private final Precision precisionKey;
        private final Signature blockKey;

        public HashKey(AbstractState stateKey, Precision precisionKey, Signature blockKey) {
            this.stateKey = stateKey;
            this.precisionKey = precisionKey;
            this.blockKey = blockKey;
        }

        public Signature getBlockKey() {
            return this.blockKey;
        }

        public AbstractState getStateKey() {
            return this.stateKey;
        }

        public Precision getPrecisionKey() {
            return this.precisionKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashKey)) {
                return false;
            }
            HashKey other = (HashKey)o;
            return Objects.equals(this.stateKey, other.stateKey) && Objects.equals(this.precisionKey, other.precisionKey) && Objects.equals(this.blockKey, other.blockKey);
        }

        public int hashCode() {
            return Objects.hash(this.stateKey, this.precisionKey, this.blockKey);
        }
    }
}

