/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.bam;

import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BamTransferRelation;
import proguard.analysis.cpa.bam.CpaWithBamOperators;
import proguard.analysis.cpa.defaults.Cfa;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractDomain;
import proguard.analysis.cpa.interfaces.CfaEdge;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.MergeOperator;
import proguard.analysis.cpa.interfaces.PrecisionAdjustment;
import proguard.analysis.cpa.interfaces.StopOperator;
import proguard.classfile.Signature;

public class BamCpa<CfaNodeT extends CfaNode<CfaEdgeT, SignatureT>, CfaEdgeT extends CfaEdge<CfaNodeT>, SignatureT extends Signature>
implements ConfigurableProgramAnalysis {
    private final CpaWithBamOperators<CfaNodeT, CfaEdgeT, SignatureT> wrappedCpa;
    private final BamTransferRelation<CfaNodeT, CfaEdgeT, SignatureT> bamTransferRelation;

    public BamCpa(CpaWithBamOperators<CfaNodeT, CfaEdgeT, SignatureT> wrappedCpa, Cfa<CfaNodeT, CfaEdgeT, SignatureT> cfa, SignatureT mainFunction, BamCache<SignatureT> cache) {
        this(wrappedCpa, cfa, mainFunction, cache, -1, NeverAbortOperator.INSTANCE);
    }

    public BamCpa(CpaWithBamOperators<CfaNodeT, CfaEdgeT, SignatureT> wrappedCpa, Cfa<CfaNodeT, CfaEdgeT, SignatureT> cfa, SignatureT mainFunction, BamCache<SignatureT> cache, int maxCallStackDepth, AbortOperator abortOperator) {
        this.wrappedCpa = wrappedCpa;
        this.bamTransferRelation = new BamTransferRelation<CfaNodeT, CfaEdgeT, SignatureT>(wrappedCpa, cfa, mainFunction, cache, maxCallStackDepth, abortOperator);
    }

    public BamCpa(BamTransferRelation<CfaNodeT, CfaEdgeT, SignatureT> transferRelation) {
        this.wrappedCpa = transferRelation.getWrappedCpa();
        this.bamTransferRelation = transferRelation;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.wrappedCpa.getAbstractDomain();
    }

    @Override
    public BamTransferRelation<CfaNodeT, CfaEdgeT, SignatureT> getTransferRelation() {
        return this.bamTransferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.wrappedCpa.getMergeOperator();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.wrappedCpa.getStopOperator();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.wrappedCpa.getPrecisionAdjustment();
    }
}

