/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.Signature;
import proguard.classfile.util.ClassUtil;

public class MethodSignature
extends Signature {
    private static final transient Map<Method, MethodSignature> signatureCache = new IdentityHashMap<Method, MethodSignature>();
    public final String method;
    public final MethodDescriptor descriptor;

    public MethodSignature(String clazz, String method, MethodDescriptor descriptor) {
        super(clazz);
        this.method = method;
        this.descriptor = descriptor;
    }

    public MethodSignature(String clazz, String method, String descriptor) {
        this(clazz, method, new MethodDescriptor(descriptor));
    }

    public MethodSignature(Clazz clazz, Method method) {
        this(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz));
    }

    public static MethodSignature computeIfAbsent(Clazz clazz, Method method) {
        return signatureCache.computeIfAbsent(method, m -> new MethodSignature(clazz, method));
    }

    @Override
    protected String calculateFqn() {
        return String.format("L%s;%s%s", this.className == null ? "?" : this.className, this.method == null ? "?" : this.method, this.descriptor);
    }

    @Override
    protected String calculatePrettyFqn() {
        String result;
        String shortClassName;
        String params = this.descriptor == null ? "?" : this.descriptor.getPrettyArgumentTypes();
        String string = shortClassName = this.className == null ? "?" : ClassUtil.externalShortClassName(ClassUtil.externalClassName(this.className));
        if ("<init>".equals(this.method)) {
            result = String.format("%s(%s)", shortClassName, params);
        } else if ("<clinit>".equals(this.method)) {
            result = String.format("static initializer (%s)", shortClassName);
        } else {
            String returnType = this.descriptor == null ? "?" : this.descriptor.getPrettyReturnType();
            String methodName = this.method == null ? "?" : this.method;
            result = String.format("%s %s.%s(%s)", returnType, shortClassName, methodName, params);
        }
        return result;
    }

    public static void clearCache() {
        signatureCache.clear();
    }

    public boolean matchesIgnoreNull(MethodSignature other) {
        return !(this.className != null && other.className != null && !this.className.equals(other.className) || this.method != null && other.method != null && !this.method.equals(other.method) || this.descriptor != null && other.descriptor != null && !this.descriptor.matchesIgnoreNull(other.descriptor));
    }

    public boolean matchesIgnoreNullAndDollar(MethodSignature other) {
        return !(this.className != null && other.className != null && !this.className.replace('$', '/').equals(other.className.replace('$', '/')) || this.method != null && other.method != null && !this.method.replace('$', '/').equals(other.method.replace('$', '/')) || this.descriptor != null && other.descriptor != null && !this.descriptor.matchesIgnoreNullAndDollar(other.descriptor));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.descriptor, that.descriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.method, this.descriptor);
    }
}

