/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.editor.AttributeSorter;
import proguard.classfile.editor.ClassMemberSorter;
import proguard.classfile.editor.ConstantPoolSorter;
import proguard.classfile.editor.InterfaceSorter;
import proguard.classfile.visitor.ClassVisitor;

public class ClassElementSorter
implements ClassVisitor {
    private final ClassVisitor interfaceSorter = new InterfaceSorter();
    private final ClassVisitor constantPoolSorter = new ConstantPoolSorter();
    private final ClassVisitor classMemberSorter = new ClassMemberSorter();
    private final ClassVisitor attributeSorter = new AttributeSorter();
    private boolean sortInterfaces;
    private boolean sortConstants;
    private boolean sortMembers;
    private boolean sortAttributes;

    public ClassElementSorter() {
        this(true, true, false, true);
    }

    public ClassElementSorter(boolean sortInterfaces, boolean sortConstants, boolean sortMembers, boolean sortAttributes) {
        this.sortInterfaces = sortInterfaces;
        this.sortConstants = sortConstants;
        this.sortMembers = sortMembers;
        this.sortAttributes = sortAttributes;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.sortConstants) {
            programClass.accept(this.constantPoolSorter);
        }
        if (this.sortInterfaces) {
            programClass.accept(this.interfaceSorter);
        }
        if (this.sortMembers) {
            programClass.accept(this.classMemberSorter);
        }
        if (this.sortAttributes) {
            programClass.accept(this.attributeSorter);
        }
    }
}

