/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class ReachableCodeMarker
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private boolean[] isReachable = new boolean[8096];
    private boolean next;
    private boolean evaluateExceptions;

    public boolean isReachable(int offset) {
        return this.isReachable[offset];
    }

    public boolean isReachable(int startOffset, int endOffset) {
        for (int offset = startOffset; offset < endOffset; ++offset) {
            if (!this.isReachable[offset]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        if (this.isReachable.length < codeLength) {
            this.isReachable = new boolean[codeLength];
        } else {
            Arrays.fill(this.isReachable, 0, codeLength, false);
        }
        this.markCode(clazz, method, codeAttribute, 0);
        do {
            this.evaluateExceptions = false;
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.evaluateExceptions);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        byte opcode = simpleInstruction.opcode;
        if (opcode == -84 || opcode == -83 || opcode == -82 || opcode == -81 || opcode == -80 || opcode == -79 || opcode == -65) {
            this.next = false;
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        if (variableInstruction.opcode == -87) {
            this.next = false;
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        this.markBranchTarget(clazz, method, codeAttribute, offset + branchInstruction.branchOffset);
        byte opcode = branchInstruction.opcode;
        if (opcode == -89 || opcode == -56) {
            this.next = false;
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        this.markBranchTarget(clazz, method, codeAttribute, offset + switchInstruction.defaultOffset);
        this.markBranchTargets(clazz, method, codeAttribute, offset, switchInstruction.jumpOffsets);
        this.next = false;
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (!this.isReachable(exceptionInfo.u2handlerPC) && this.isReachable(exceptionInfo.u2startPC, exceptionInfo.u2endPC)) {
            this.markCode(clazz, method, codeAttribute, exceptionInfo.u2handlerPC);
            this.evaluateExceptions = true;
        }
    }

    private void markBranchTargets(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, int[] jumpOffsets) {
        for (int index = 0; index < jumpOffsets.length; ++index) {
            this.markCode(clazz, method, codeAttribute, offset + jumpOffsets[index]);
        }
    }

    private void markBranchTarget(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset) {
        boolean oldNext = this.next;
        this.markCode(clazz, method, codeAttribute, offset);
        this.next = oldNext;
    }

    private void markCode(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset) {
        boolean oldNext = this.next;
        byte[] code = codeAttribute.code;
        while (!this.isReachable[offset]) {
            Instruction instruction = InstructionFactory.create(code, offset);
            this.isReachable[offset] = true;
            this.next = true;
            instruction.accept(clazz, method, codeAttribute, offset, this);
            if (!this.next) break;
            offset += instruction.length(offset);
        }
        this.next = oldNext;
    }
}

