/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.EmptyStringMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.OrMatcher;
import proguard.util.SettableMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.VariableStringMatcher;
import proguard.util.WildcardManager;

public class ClassNameParser
implements StringParser {
    private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D'};
    private final WildcardManager wildcardManager;

    public ClassNameParser() {
        this(null);
    }

    public ClassNameParser(WildcardManager wildcardManager) {
        this.wildcardManager = wildcardManager;
    }

    @Override
    public StringMatcher parse(String regularExpression) {
        int index;
        StringMatcher nextMatcher = new EmptyStringMatcher();
        for (index = 0; index < regularExpression.length(); ++index) {
            int wildCardIndex;
            if (regularExpression.regionMatches(index, "L///;", 0, 5)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                VariableStringMatcher variableStringMatcher = new VariableStringMatcher(null, new char[]{')'}, 0, Integer.MAX_VALUE, settableMatcher);
                if (this.wildcardManager != null) {
                    this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
                }
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 5)));
                nextMatcher = variableStringMatcher;
                break;
            }
            if (regularExpression.regionMatches(index, "L***;", 0, 5)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                VariableStringMatcher variableStringMatcher = this.createAnyTypeMatcher(settableMatcher);
                if (this.wildcardManager != null) {
                    this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
                }
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 5)));
                nextMatcher = variableStringMatcher;
                break;
            }
            if (regularExpression.regionMatches(index, "**", 0, 2)) {
                SettableMatcher settableMatcher = index + 2 == regularExpression.length() ? null : new SettableMatcher();
                VariableStringMatcher variableStringMatcher = new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, settableMatcher);
                if (this.wildcardManager != null) {
                    this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
                }
                if (settableMatcher != null) {
                    settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 2)));
                }
                nextMatcher = variableStringMatcher;
                break;
            }
            if (regularExpression.charAt(index) == '*') {
                SettableMatcher settableMatcher = new SettableMatcher();
                VariableStringMatcher variableStringMatcher = new VariableStringMatcher(null, new char[]{';', '/'}, 0, Integer.MAX_VALUE, settableMatcher);
                if (this.wildcardManager != null) {
                    this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
                }
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                nextMatcher = variableStringMatcher;
                break;
            }
            if (regularExpression.charAt(index) == '?') {
                SettableMatcher settableMatcher = new SettableMatcher();
                VariableStringMatcher variableStringMatcher = new VariableStringMatcher(null, new char[]{';', '/'}, 1, 1, settableMatcher);
                if (this.wildcardManager != null) {
                    this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
                }
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                nextMatcher = variableStringMatcher;
                break;
            }
            if (regularExpression.charAt(index) == '%') {
                SettableMatcher settableMatcher = new SettableMatcher();
                VariableStringMatcher variableStringMatcher = new VariableStringMatcher(PRIMITIVE_TYPES, null, 1, 1, settableMatcher);
                if (this.wildcardManager != null) {
                    this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
                }
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                nextMatcher = variableStringMatcher;
                break;
            }
            if (this.wildcardManager == null || (wildCardIndex = this.wildcardManager.wildCardIndex(regularExpression, index)) < 0) continue;
            int closingIndex = regularExpression.indexOf(62, index + 1);
            nextMatcher = this.wildcardManager.createMatchedStringMatcher(wildCardIndex, this.parse(regularExpression.substring(closingIndex + 1)));
            break;
        }
        return index != 0 ? new FixedStringMatcher(regularExpression.substring(0, index), nextMatcher) : nextMatcher;
    }

    private VariableStringMatcher createAnyTypeMatcher(StringMatcher nextMatcher) {
        return new VariableStringMatcher(new char[]{'['}, null, 0, 255, new OrMatcher(new VariableStringMatcher(PRIMITIVE_TYPES, null, 1, 1, nextMatcher), new VariableStringMatcher(new char[]{'L'}, null, 1, 1, new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, new VariableStringMatcher(new char[]{';'}, null, 1, 1, nextMatcher)))));
    }

    public static void main(String[] args2) {
        try {
            System.out.println("Regular expression [" + args2[0] + "]");
            ClassNameParser parser = new ClassNameParser();
            StringMatcher matcher = parser.parse(args2[0]);
            for (int index = 1; index < args2.length; ++index) {
                String string = args2[index];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + matcher.matches(args2[index]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

