/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Disulfide;
import driftwood.moldb2.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class Disulfides {
    private Collection disulfides = new ArrayList();

    protected void add(Disulfide disulfide) {
        this.disulfides.add(disulfide);
        disulfide.disulfideIndex = this.disulfides.size();
    }

    public Disulfide get(Residue residue) {
        Iterator iterator = this.disulfides.iterator();
        while (iterator.hasNext()) {
            Disulfide disulfide = (Disulfide)iterator.next();
            if (!disulfide.contains(residue)) continue;
            return disulfide;
        }
        return null;
    }

    public Collection getAll() {
        return Collections.unmodifiableCollection(this.disulfides);
    }

    public Object classify(Residue residue) {
        Disulfide disulfide = this.get(residue);
        if (disulfide != null) {
            return disulfide.getType();
        }
        return null;
    }

    public boolean isInDisulfide(Residue residue) {
        return !Disulfide.NOT_IN_DISULFIDE.equals(this.classify(residue));
    }

    public boolean isIntraChain(Residue residue) {
        return Disulfide.INTRA_CHAIN.equals(this.classify(residue));
    }

    public boolean isInterChain(Residue residue) {
        return Disulfide.INTER_CHAIN.equals(this.classify(residue));
    }

    public static class NoDisulfides
    extends Disulfides {
        public Object classify(Residue residue) {
            return Disulfide.NOT_IN_DISULFIDE;
        }
    }
}

