/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dangle;

import chiropraxis.dangle.AtomSpec;
import chiropraxis.dangle.Measurement;
import chiropraxis.dangle.ResSpec;
import chiropraxis.dangle.XyzSpec;
import driftwood.data.UberMap;
import driftwood.parser.CharWindow;
import driftwood.parser.RegexTokenMatcher;
import driftwood.parser.TokenWindow;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    final Matcher FOR = Pattern.compile("for").matcher("");
    final Matcher CIS = Pattern.compile("cis").matcher("");
    final Matcher RESNAME = Pattern.compile("[_A-Z0-9]{3}|/[^/ ]*/").matcher("");
    final Matcher SUPERBLTN = Pattern.compile("rnabb|suitefit").matcher("");
    final Matcher BUILTIN = Pattern.compile("phi|psi|omega|chi1|chi2|chi3|chi4|tau|cbdev|alpha|beta|gamma|delta|epsilon|zeta|c2o2|eta|theta|chi|alpha-1|beta-1|gamma-1|delta-1|epsilon-1|zeta-1|chi-1|O5'-C5'|O5'--C5'|C5'-C4'|C5'--C4'|C4'-C3'|C4'--C3'|C3'-C2'|C3'--C2'|C2'-C1'|C2'--C1'|O4'-C1'|O4'--C1'|O4'-C4'|O4'--C4'|O3'--C3'|O3'-C3'|C2'-O2'|C2'--O2'|C4'-O4'-C1'|O4'-C1'-C2'|C1'-C2'-C3'|C4'-C3'-C2'|C3'-C2'-C1'|C2'-C1'-O4'|C1'-O4'-C4'|O3'-C3'-C4'|C3'-C4'-C5'|C3'-C4'-O4'-C1'|C4'-O4'-C1'-C2'|O4'-C1'-C2'-C3'|C4'-C3'-C2'-C1'|C3'-C2'-C1'-O4'|C2'-C1'-O4'-C4'|O3'-C4'-C3'-C2'|C5'-C3'-C4'-O4'").matcher("");
    final Matcher DISTANCE = Pattern.compile("dist(ance)?").matcher("");
    final Matcher ANGLE = Pattern.compile("angle").matcher("");
    final Matcher DIHEDRAL = Pattern.compile("dihedral|torsion").matcher("");
    final Matcher V_ANGLE = Pattern.compile("vector_angle|v_angle").matcher("");
    final Matcher MAXB = Pattern.compile("maxb", 2).matcher("");
    final Matcher MINQ = Pattern.compile("minq|mino|minocc", 2).matcher("");
    final Matcher PLANARITY = Pattern.compile("planarity").matcher("");
    final Matcher PUCKER = Pattern.compile("pucker").matcher("");
    final Matcher LABEL = Pattern.compile("[A-Za-z0-9*'_.+-]+").matcher("");
    final Matcher AVG = Pattern.compile("avg").matcher("");
    final Matcher IDEALTET = Pattern.compile("idealtet").matcher("");
    final Matcher VECTOR = Pattern.compile("vector").matcher("");
    final Matcher NORMAL = Pattern.compile("normal").matcher("");
    final Matcher RESNO = Pattern.compile("i|i(-[1-9])|i\\+([1-9])").matcher("");
    final Matcher ATOMNAME = Pattern.compile("[_A-Z0-9*']{4}|/[^/ ]*/").matcher("");
    final Matcher IDEAL = Pattern.compile("ideal").matcher("");
    final Matcher REALNUM = RegexTokenMatcher.SIGNED_REAL.matcher("");
    final Matcher OPERATOR = Pattern.compile("[()]").matcher("");
    final Pattern[] toIgnore = new Pattern[]{RegexTokenMatcher.WHITESPACE, Pattern.compile("[,;]+"), RegexTokenMatcher.HASH_COMMENT};
    final Pattern[] toAccept = new Pattern[]{this.LABEL.pattern(), this.OPERATOR.pattern(), RegexTokenMatcher.SLASH_QUOTED_STRING, RegexTokenMatcher.SIGNED_REAL};
    TokenWindow t;

    public Collection parse(CharWindow charWindow) throws ParseException, IOException {
        RegexTokenMatcher regexTokenMatcher = new RegexTokenMatcher(RegexTokenMatcher.joinPatterns(this.toAccept), RegexTokenMatcher.joinPatterns(this.toIgnore));
        this.t = new TokenWindow(charWindow, regexTokenMatcher);
        UberMap uberMap = new UberMap();
        while (this.t.token() != null) {
            Measurement[] measurementArray = this.measurement_for();
            for (int i = 0; i < measurementArray.length; ++i) {
                Measurement measurement = measurementArray[i];
                Measurement measurement2 = (Measurement)uberMap.get(measurement.getLabel());
                if (measurement2 == null) {
                    uberMap.put(measurement.getLabel(), measurement);
                    continue;
                }
                if (measurement2 instanceof Measurement.Group) {
                    ((Measurement.Group)measurement2).add(measurement);
                    continue;
                }
                Measurement.Group group = new Measurement.Group(measurement2).add(measurement);
                uberMap.put(group.getLabel(), group);
            }
        }
        return uberMap.values();
    }

    Measurement[] measurement_for() throws ParseException, IOException {
        ResSpec resSpec = null;
        if (this.t.accept(this.FOR)) {
            resSpec = this.resspec();
        }
        Measurement[] measurementArray = this.measurement();
        if (resSpec != null) {
            for (int i = 0; i < measurementArray.length; ++i) {
                measurementArray[i].setResSpec(resSpec);
            }
        }
        return measurementArray;
    }

    ResSpec resspec() throws ParseException, IOException {
        int n = 0;
        if (this.t.accept(this.RESNO)) {
            String string = this.RESNO.group(1);
            if (string == null) {
                string = this.RESNO.group(2);
            }
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Unexpected difficulty parsing residue number [" + this.t.token() + "]", 0);
                }
            }
        }
        boolean bl = this.t.accept(this.CIS);
        if (this.t.accept(this.RESNAME)) {
            ResSpec resSpec = new ResSpec(n, bl, this.RESNAME.group());
            return resSpec;
        }
        throw this.t.syntaxError("Expected residue name [" + this.t.token() + "]");
    }

    Measurement[] measurement() throws ParseException, IOException {
        if (this.t.accept(this.SUPERBLTN)) {
            return Measurement.newSuperBuiltin(this.SUPERBLTN.group());
        }
        if (this.t.accept(this.BUILTIN)) {
            return new Measurement[]{Measurement.newBuiltin(this.BUILTIN.group())};
        }
        if (this.t.accept(this.DISTANCE)) {
            Measurement measurement = Measurement.newDistance(this.label(), this.xyzspec(), this.xyzspec());
            if (this.t.accept(this.IDEAL)) {
                measurement.setMeanAndSigma(this.realnum(), this.realnum());
            }
            return new Measurement[]{measurement};
        }
        if (this.t.accept(this.ANGLE)) {
            Measurement measurement = Measurement.newAngle(this.label(), this.xyzspec(), this.xyzspec(), this.xyzspec());
            if (this.t.accept(this.IDEAL)) {
                measurement.setMeanAndSigma(this.realnum(), this.realnum());
            }
            return new Measurement[]{measurement};
        }
        if (this.t.accept(this.DIHEDRAL)) {
            return new Measurement[]{Measurement.newDihedral(this.label(), this.xyzspec(), this.xyzspec(), this.xyzspec(), this.xyzspec())};
        }
        if (this.t.accept(this.V_ANGLE)) {
            Measurement measurement = Measurement.newVectorAngle(this.label(), this.xyzspec(), this.xyzspec());
            if (this.t.accept(this.IDEAL)) {
                measurement.setMeanAndSigma(this.realnum(), this.realnum());
            }
            return new Measurement[]{measurement};
        }
        if (this.t.accept(this.MAXB)) {
            return new Measurement[]{Measurement.newMaxB(this.label(), this.atomspec())};
        }
        if (this.t.accept(this.MINQ)) {
            return new Measurement[]{Measurement.newMinQ(this.label(), this.atomspec())};
        }
        if (this.t.accept(this.PLANARITY)) {
            Measurement.Planarity planarity = new Measurement.Planarity(this.label());
            this.t.require("(");
            planarity.add(this.xyzspec());
            while (!this.t.accept(")")) {
                planarity.add(this.xyzspec());
            }
            return new Measurement[]{planarity};
        }
        if (this.t.accept(this.PUCKER)) {
            String string = "pseudorot_angle";
            Measurement.PuckerAng puckerAng = new Measurement.PuckerAng(string);
            String string2 = "amplitude";
            Measurement.PuckerAmp puckerAmp = new Measurement.PuckerAmp(string2);
            return new Measurement[]{puckerAng, puckerAmp};
        }
        throw this.t.syntaxError("Expected measurement type ('distance', 'angle', 'dihedral', etc) [" + this.t.token() + "]");
    }

    String label() throws ParseException, IOException {
        if (this.t.accept(this.LABEL)) {
            return this.LABEL.group();
        }
        throw this.t.syntaxError("Expected descriptive label [" + this.t.token() + "]");
    }

    XyzSpec xyzspec() throws ParseException, IOException {
        if (this.t.accept(this.AVG)) {
            this.t.require("(");
            XyzSpec.Average average = new XyzSpec.Average();
            average.add(this.xyzspec());
            while (!this.t.accept(")")) {
                average.add(this.xyzspec());
            }
            return average;
        }
        if (this.t.accept(this.IDEALTET)) {
            this.t.require("(");
            XyzSpec.IdealTetrahedral idealTetrahedral = new XyzSpec.IdealTetrahedral(this.xyzspec(), this.xyzspec(), this.xyzspec(), this.realnum(), this.realnum(), this.realnum(), this.realnum(), this.realnum());
            this.t.require(")");
            return idealTetrahedral;
        }
        if (this.t.accept(this.VECTOR)) {
            this.t.require("(");
            XyzSpec.Vector vector = new XyzSpec.Vector(this.xyzspec(), this.xyzspec());
            this.t.require(")");
            return vector;
        }
        if (this.t.accept(this.NORMAL)) {
            this.t.require("(");
            XyzSpec.Normal normal = new XyzSpec.Normal();
            normal.add(this.xyzspec());
            while (!this.t.accept(")")) {
                normal.add(this.xyzspec());
            }
            return normal;
        }
        try {
            return this.atomspec();
        }
        catch (ParseException parseException) {
            throw this.t.syntaxError("Expected xyz specifier or atom name [" + this.t.token() + "]");
        }
    }

    AtomSpec atomspec() throws ParseException, IOException {
        Object object;
        int n = 0;
        if (this.t.accept(this.RESNO)) {
            object = this.RESNO.group(1);
            if (object == null) {
                object = this.RESNO.group(2);
            }
            if (object != null) {
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Unexpected difficulty parsing residue number [" + this.t.token() + "]", 0);
                }
            }
        }
        if (this.t.accept(this.ATOMNAME)) {
            object = new AtomSpec(n, this.ATOMNAME.group());
            return object;
        }
        throw this.t.syntaxError("Expected atom name [" + this.t.token() + "]");
    }

    double realnum() throws ParseException, IOException {
        if (this.t.accept(this.REALNUM)) {
            try {
                return Double.parseDouble(this.REALNUM.group());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Unexpected difficulty parsing real number [" + this.t.token() + "]", 0);
            }
        }
        throw this.t.syntaxError("Expected real number [" + this.t.token() + "]");
    }

    public static void main(String[] stringArray) {
        Parser parser = new Parser();
        try {
            Collection collection = parser.parse(new CharWindow(System.in));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                System.out.print(" " + iterator.next() + " ;");
            }
            System.out.println();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

