/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.BackrubWindow;
import chiropraxis.kingtools.ModelManager2;
import chiropraxis.kingtools.Remodeler;
import chiropraxis.rotarama.Rotamer;
import chiropraxis.sc.RotamerDef;
import chiropraxis.sc.SidechainAngles2;
import chiropraxis.sc.SidechainIdealizer;
import driftwood.gui.AngleDial;
import driftwood.gui.ReclickListSelectionModel;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import driftwood.gui.TablePane2;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.util.SoftLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import king.KingMain;

public class SidechainRotator
implements Remodeler,
ChangeListener,
ListSelectionListener,
WindowListener {
    static final DecimalFormat df1 = new DecimalFormat("0.0");
    KingMain kMain;
    Residue targetRes;
    ModelManager2 modelman;
    SidechainAngles2 scAngles;
    Rotamer rotamer;
    SidechainIdealizer scIdealizer = null;
    JDialog dialog;
    JCheckBox cbIdealize;
    JList rotamerList;
    AngleDial[] dials;
    JLabel rotaQuality;
    boolean isUpdating = false;

    public SidechainRotator(KingMain kingMain, Residue residue, ModelManager2 modelManager2) throws IOException {
        this.kMain = kingMain;
        this.targetRes = residue;
        this.modelman = modelManager2;
        this.scAngles = new SidechainAngles2();
        this.rotamer = Rotamer.getInstance();
        try {
            this.scIdealizer = new SidechainIdealizer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
        this.buildGUI(kingMain.getTopWindow());
        this.modelman.registerTool(this, Collections.singleton(this.targetRes));
    }

    private void buildGUI(Frame frame) {
        TablePane tablePane = new TablePane();
        String[] stringArray = this.scAngles.nameAllAngles(this.targetRes);
        if (stringArray == null) {
            throw new IllegalArgumentException("Bad residue code '" + this.targetRes.getName() + "' isn't recognized");
        }
        double[] dArray = this.scAngles.measureAllAngles(this.targetRes, this.modelman.getMoltenState());
        this.dials = new AngleDial[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            tablePane.add(new JLabel(stringArray[i]));
            this.dials[i] = new AngleDial();
            this.dials[i].setOrigDegrees(dArray[i]);
            this.dials[i].setDegrees(dArray[i]);
            this.dials[i].addChangeListener(this);
            tablePane.add(this.dials[i]);
            tablePane.newRow();
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)tablePane, "West");
        RotamerDef[] rotamerDefArray = this.scAngles.getAllRotamers(this.targetRes);
        if (rotamerDefArray == null) {
            throw new IllegalArgumentException("Bad residue code '" + this.targetRes.getName() + "' isn't recognized");
        }
        RotamerDef rotamerDef = new RotamerDef();
        rotamerDef.rotamerName = "original";
        rotamerDef.chiAngles = this.scAngles.measureChiAngles(this.targetRes, this.modelman.getMoltenState());
        RotamerDef[] rotamerDefArray2 = new RotamerDef[rotamerDefArray.length + 1];
        System.arraycopy(rotamerDefArray, 0, rotamerDefArray2, 1, rotamerDefArray.length);
        rotamerDefArray2[0] = rotamerDef;
        this.rotamerList = new JList<RotamerDef>(rotamerDefArray2);
        this.rotamerList.setSelectionMode(0);
        this.rotamerList.setSelectionModel(new ReclickListSelectionModel(this.rotamerList));
        this.rotamerList.addListSelectionListener(this);
        this.rotaQuality = new JLabel();
        this.rotaQuality.setToolTipText("Quality assessment for the current side-chain conformation");
        this.setFeedback();
        TablePane tablePane2 = new TablePane();
        tablePane2.hfill(true).vfill(true).weights(1.0, 1.0).addCell(new JScrollPane(this.rotamerList));
        tablePane2.newRow().weights(1.0, 0.0).add(this.rotaQuality);
        jPanel.add((Component)tablePane2, "Center");
        this.cbIdealize = new JCheckBox(new ReflectiveAction("Idealize sidechain", null, this, "onIdealizeOnOff"));
        if (this.scIdealizer != null) {
            this.cbIdealize.setSelected(true);
        } else {
            this.cbIdealize.setEnabled(false);
        }
        jPanel.add((Component)this.cbIdealize, "North");
        JButton jButton = new JButton(new ReflectiveAction("Finished", null, this, "onReleaseResidue"));
        JButton jButton2 = new JButton(new ReflectiveAction("BACKRUB mainchain", null, this, "onBackrub"));
        TablePane2 tablePane22 = new TablePane2();
        tablePane22.addCell(jButton);
        tablePane22.addCell(jButton2);
        jPanel.add((Component)tablePane22, "South");
        this.dialog = new JDialog(frame, this.targetRes.toString(), false);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this);
        this.dialog.setContentPane(jPanel);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void onReleaseResidue(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this.dialog, "Do you want to keep the changes\nyou've made to this residue?", "Keep changes?", 1, 3);
        if (n == 2) {
            return;
        }
        if (n == 0) {
            this.modelman.requestStateChange(this);
            this.modelman.addUserMod("Refit sidechain of " + this.targetRes);
        } else {
            this.modelman.unregisterTool(this);
        }
        this.dialog.dispose();
    }

    public void onBackrub(ActionEvent actionEvent) {
        try {
            new BackrubWindow(this.kMain, this.targetRes, this.modelman);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), this.targetRes + "doesn't have neighbors in the same chain.\n", "Sorry!", 0);
        }
    }

    public void onIdealizeOnOff(ActionEvent actionEvent) {
        this.stateChanged(null);
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void isUpdating(boolean bl) {
        this.isUpdating = bl;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.isUpdating()) {
            this.modelman.requestStateRefresh();
        }
        this.setFeedback();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        RotamerDef rotamerDef = (RotamerDef)this.rotamerList.getSelectedValue();
        if (rotamerDef != null) {
            this.initSomeAngles(rotamerDef.chiAngles);
        }
    }

    public boolean getValueIsAdjusting() {
        if (this.isUpdating()) {
            return true;
        }
        for (int i = 0; i < this.dials.length; ++i) {
            if (!this.dials[i].getValueIsAdjusting()) continue;
            return true;
        }
        return false;
    }

    public double[] getAllAngles() {
        double[] dArray = new double[this.dials.length];
        for (int i = 0; i < this.dials.length; ++i) {
            dArray[i] = this.dials[i].getDegrees();
        }
        return dArray;
    }

    public void setAllAngles(double[] dArray) {
        if (dArray.length < this.dials.length) {
            throw new IllegalArgumentException("Not enough angles provided!");
        }
        this.isUpdating(true);
        for (int i = 0; i < this.dials.length; ++i) {
            this.dials[i].setDegrees(dArray[i]);
        }
        this.isUpdating(false);
        this.stateChanged(new ChangeEvent(this));
    }

    public void initAllAngles(double[] dArray) {
        if (dArray.length < this.dials.length) {
            throw new IllegalArgumentException("Not enough angles provided!");
        }
        this.initSomeAngles(dArray);
    }

    public void initSomeAngles(double[] dArray) {
        int n = Math.min(dArray.length, this.dials.length);
        this.isUpdating(true);
        for (int i = 0; i < n; ++i) {
            this.dials[i].setOrigDegrees(dArray[i]);
            this.dials[i].setDegrees(dArray[i]);
        }
        this.isUpdating(false);
        this.stateChanged(new ChangeEvent(this));
    }

    public void setFeedback() {
        try {
            double d = this.rotamer.evaluate(this.targetRes, this.modelman.getMoltenState()) * 100.0;
            String string = d > 20.0 ? "Excellent" : (d > 10.0 ? "Good" : (d > 2.0 ? "Fair" : (d > 1.0 ? "Poor" : "OUTLIER")));
            this.rotaQuality.setText(string + " (" + df1.format(d) + "%)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.rotaQuality.setText("-");
        }
    }

    public ModelState updateModelState(ModelState modelState) {
        ModelState modelState2 = this.scIdealizer != null && this.cbIdealize.isSelected() ? this.scIdealizer.idealizeSidechain(this.targetRes, modelState) : modelState;
        modelState2 = this.scAngles.setAllAngles(this.targetRes, modelState2, this.getAllAngles());
        return modelState2;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.onReleaseResidue(null);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

