/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class HingeFit {
    static final Triple X_AXIS = new Triple(1.0, 0.0, 0.0);
    static final Triple Y_AXIS = new Triple(0.0, 1.0, 0.0);
    static final Triple Z_AXIS = new Triple(0.0, 0.0, 1.0);
    static final Triple ORIGIN = new Triple(0.0, 0.0, 0.0);
    Builder builder;
    AtomState[] ca1 = null;
    AtomState[] ca2 = null;
    Triple[] tmp1 = null;
    Triple[] tmp2 = null;
    String[] labels = null;
    File file1 = null;
    File file2 = null;
    InputStream input1 = null;
    InputStream input2 = null;
    PrintStream output = System.out;
    int numTries = 25;

    public HingeFit() {
        this.builder = new Builder();
    }

    void initData() throws IOException {
        int n;
        this.ca1 = this.loadAtomStates(this.input1);
        this.ca2 = this.loadAtomStates(this.input2);
        if (this.ca1.length != this.ca2.length) {
            throw new IllegalArgumentException("Selections must have same number of C-alphas");
        }
        this.tmp1 = new Triple[this.ca1.length];
        this.tmp2 = new Triple[this.ca1.length];
        for (n = 0; n < this.ca1.length; ++n) {
            this.tmp1[n] = new Triple();
            this.tmp2[n] = new Triple();
        }
        this.labels = new String[this.ca1.length];
        for (n = 0; n < this.ca1.length; ++n) {
            this.labels[n] = this.ca1[n].getResidue().toString();
        }
    }

    AtomState[] loadAtomStates(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Must supply two input files");
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(inputStream);
        Model model = coordinateFile.getFirstModel();
        Collection collection = model.getResidues();
        ModelState modelState = model.getState();
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (Residue residue : collection) {
            Atom atom = residue.getAtom(" CA ");
            try {
                if (atom == null) continue;
                arrayList.add(modelState.get(atom));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        AtomState[] atomStateArray = arrayList.toArray(new AtomState[arrayList.size()]);
        return atomStateArray;
    }

    double calcRMSD(Triple[] tripleArray, Triple[] tripleArray2) {
        double d = 0.0;
        for (int i = 0; i < tripleArray.length; ++i) {
            d += tripleArray[i].sqDistance(tripleArray2[i]);
        }
        d = Math.sqrt(d / (double)tripleArray.length);
        return d;
    }

    void transform(Triple[] tripleArray, Triple[] tripleArray2, Transform transform) {
        for (int i = 0; i < tripleArray.length; ++i) {
            transform.transform(tripleArray[i], tripleArray2[i]);
        }
    }

    void transform(Triple[] tripleArray, Triple[] tripleArray2, int n, int n2, Transform transform) {
        for (int i = n; i <= n2; ++i) {
            transform.transform(tripleArray[i], tripleArray2[i]);
        }
    }

    double bestFitZ(Triple[] tripleArray, Triple[] tripleArray2, int n, int n2) {
        double d;
        Triple[] tripleArray3 = new Triple[tripleArray2.length];
        for (int i = 0; i < tripleArray3.length; ++i) {
            tripleArray3[i] = new Triple(tripleArray2[i]);
        }
        double d2 = this.calcRMSD(tripleArray, tripleArray2);
        double d3 = 0.0;
        Transform transform = new Transform();
        double d4 = d2;
        double d5 = 0.0;
        while (true) {
            d = d4;
            transform.likeRotation(Z_AXIS, d5 += 0.05);
            this.transform(tripleArray2, tripleArray3, n, n2, transform);
            d4 = this.calcRMSD(tripleArray, tripleArray3);
            if (d4 > d) break;
            d3 = d5;
        }
        d4 = d2;
        d5 = 0.0;
        while (true) {
            double d6 = d4;
            transform.likeRotation(Z_AXIS, d5 -= 0.05);
            this.transform(tripleArray2, tripleArray3, n, n2, transform);
            d4 = this.calcRMSD(tripleArray, tripleArray3);
            if (d4 > d6) break;
            if (!(d4 < d)) continue;
            d3 = d5;
        }
        return d3;
    }

    double findBestHinge() {
        Transform transform;
        DecimalFormat decimalFormat = new DecimalFormat("0.0000");
        int n = 0;
        int n2 = 0;
        double d = this.calcRMSD(this.ca1, this.ca2);
        double d2 = Double.NaN;
        double d3 = d;
        for (int i = 0; i < this.ca2.length; ++i) {
            for (int j = i + 2; j < this.ca2.length; ++j) {
                transform = this.builder.dock3on3(ORIGIN, Z_AXIS, X_AXIS, this.ca2[i], this.ca2[j], this.ca2[i + 1]);
                this.transform(this.ca1, this.tmp1, transform);
                this.transform(this.ca2, this.tmp2, transform);
                double d4 = this.bestFitZ(this.tmp1, this.tmp2, i, j);
                transform.likeRotation(Z_AXIS, d4);
                this.transform(this.tmp2, this.tmp2, i, j, transform);
                double d5 = this.calcRMSD(this.tmp1, this.tmp2);
                if (!(d5 < d3)) continue;
                d3 = d5;
                n = i;
                n2 = j;
                d2 = d4;
            }
        }
        transform = new Transform().likeRotation(this.ca2[n], this.ca2[n2], d2);
        this.transform(this.ca2, this.ca2, n, n2, transform);
        System.err.println("Most advantageous rotation: " + decimalFormat.format(d2) + " degrees between " + this.labels[n] + " and " + this.labels[n2]);
        System.err.println("RMSD (before) = " + decimalFormat.format(d) + "; RMSD (after) = " + decimalFormat.format(d3) + "; diff = " + decimalFormat.format(d3 - d));
        return d3;
    }

    void drawCa1() {
        System.out.println("@group {ref CAs} dominant");
        System.out.println("@vectorlist {C-alpha trace} color= white");
        this.drawCaTrace(this.ca1);
    }

    void drawCa2() {
        System.out.println("@group {mobile CAs} dominant animate");
        System.out.println("@vectorlist {C-alpha trace} color= yellowtint");
        this.drawCaTrace(this.ca2);
    }

    void drawCaTrace(AtomState[] atomStateArray) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0####");
        for (int i = 0; i < atomStateArray.length; ++i) {
            System.out.println("{" + atomStateArray[i] + "} " + decimalFormat.format(atomStateArray[i].getX()) + " " + decimalFormat.format(atomStateArray[i].getY()) + " " + decimalFormat.format(atomStateArray[i].getZ()));
        }
    }

    public void Main() throws IOException {
        this.initData();
        System.out.println("@kinemage 1");
        this.drawCa1();
        this.drawCa2();
        for (int i = 0; i < this.numTries; ++i) {
            this.findBestHinge();
            System.err.println();
            this.drawCa2();
        }
        try {
            this.input1.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.input2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.output.close();
    }

    public static void main(String[] stringArray) {
        HingeFit hingeFit = new HingeFit();
        try {
            hingeFit.showHelp(false);
            hingeFit.parseArguments(stringArray);
            hingeFit.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            hingeFit.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println();
            System.err.println("*** I/O error: " + iOException.getMessage());
            System.exit(2);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("HingeFit.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'HingeFit.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.HingeFit");
        System.err.println("Copyright (C) 2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        File file = new File(string);
        try {
            if (file.exists()) {
                if (this.input1 == null) {
                    this.file1 = file;
                    this.input1 = new BufferedInputStream(new FileInputStream(file));
                } else if (this.input2 == null) {
                    this.file2 = file;
                    this.input2 = new BufferedInputStream(new FileInputStream(file));
                } else {
                    this.output = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                }
            } else if (this.input1 != null && this.input2 != null) {
                this.output = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            } else {
                System.err.println("*** WARNING: file '" + file + "' was not found");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("*** WARNING: file '" + file + "' was not found");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-tries")) {
            try {
                this.numTries = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

