/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.NDFloatTable;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TauByPhiPsi {
    private static TauByPhiPsi instance = null;
    float[] phipsi = new float[2];
    NDFloatTable genTable = null;
    NDFloatTable glyTable = null;
    NDFloatTable proTable = null;
    NDFloatTable preproTable = null;

    public static TauByPhiPsi getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        instance = new TauByPhiPsi();
        return instance;
    }

    public static void freeInstance() {
        instance = null;
    }

    private TauByPhiPsi() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("p_a_karplus_1996/tau-general.ndft");
        InputStream inputStream2 = this.getClass().getResourceAsStream("p_a_karplus_1996/tau-glycine.ndft");
        InputStream inputStream3 = this.getClass().getResourceAsStream("p_a_karplus_1996/tau-proline.ndft");
        InputStream inputStream4 = this.getClass().getResourceAsStream("p_a_karplus_1996/tau-prepro.ndft");
        if (inputStream == null || inputStream2 == null || inputStream3 == null || inputStream4 == null) {
            throw new IOException("Could not find required .ndft files");
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.genTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream2));
        this.glyTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream3));
        this.proTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream4));
        this.preproTable = new NDFloatTable(dataInputStream);
        inputStream.close();
        inputStream2.close();
        inputStream3.close();
        inputStream4.close();
    }

    public double getExpectedTau(Model model, Residue residue, ModelState modelState) throws ResidueException {
        double d;
        double d2;
        try {
            d2 = AminoAcid.getPhi(model, residue, modelState);
            d = AminoAcid.getPsi(model, residue, modelState);
        }
        catch (AtomException atomException) {
            throw new ResidueException("Can't get tau angle for " + residue + ": " + atomException.getMessage());
        }
        this.phipsi[0] = (float)d2;
        this.phipsi[1] = (float)d;
        String string = residue.getName();
        double d3 = string.equals("GLY") ? (double)this.glyTable.valueAt(this.phipsi) : (string.equals("PRO") ? (double)this.proTable.valueAt(this.phipsi) : (AminoAcid.isPrepro(model, residue, modelState) ? (double)this.preproTable.valueAt(this.phipsi) : (double)this.genTable.valueAt(this.phipsi)));
        return d3;
    }

    public double getTauDeviation(Model model, Residue residue, ModelState modelState) throws ResidueException {
        try {
            double d = this.getExpectedTau(model, residue, modelState);
            double d2 = AminoAcid.getTau(residue, modelState);
            return d2 - d;
        }
        catch (AtomException atomException) {
            throw new ResidueException("Couldn't calculate tau: " + atomException.getMessage());
        }
    }
}

