/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.forge.legacy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.util.ModInfo;
import com.velocitypowered.proxy.connection.forge.legacy.LegacyForgeConstants;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;

class LegacyForgeUtil {
    private LegacyForgeUtil() {
        throw new AssertionError();
    }

    static byte getHandshakePacketDiscriminator(PluginMessage message) {
        Preconditions.checkArgument(message.getChannel().equals("FML|HS"));
        Preconditions.checkArgument(message.content().isReadable());
        return message.content().getByte(0);
    }

    static List<ModInfo.Mod> readModList(PluginMessage message) {
        Preconditions.checkNotNull(message, "message");
        Preconditions.checkArgument(message.getChannel().equals("FML|HS"), "message is not a FML HS plugin message");
        ByteBuf contents = message.content().slice();
        byte discriminator = contents.readByte();
        if (discriminator == 2) {
            ImmutableList.Builder mods = ImmutableList.builder();
            int modCount = ProtocolUtils.readVarInt(contents);
            for (int index = 0; index < modCount; ++index) {
                String id = ProtocolUtils.readString(contents);
                String version = ProtocolUtils.readString(contents);
                mods.add(new ModInfo.Mod(id, version));
            }
            return mods.build();
        }
        return ImmutableList.of();
    }

    static PluginMessage resetPacket() {
        PluginMessage msg = new PluginMessage();
        msg.setChannel("FML|HS");
        msg.replace(Unpooled.wrappedBuffer((byte[])LegacyForgeConstants.FORGE_LEGACY_HANDSHAKE_RESET_DATA.clone()));
        return msg;
    }
}

