/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.plugin;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.api.plugin.meta.PluginDependency;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.plugin.PluginClassLoader;
import com.velocitypowered.proxy.plugin.loader.VelocityPluginContainer;
import com.velocitypowered.proxy.plugin.loader.java.JavaPluginLoader;
import com.velocitypowered.proxy.plugin.util.PluginDependencyUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VelocityPluginManager
implements PluginManager {
    private static final Logger logger = LogManager.getLogger(VelocityPluginManager.class);
    private final Map<String, PluginContainer> plugins = new LinkedHashMap<String, PluginContainer>();
    private final Map<Object, PluginContainer> pluginInstances = new IdentityHashMap<Object, PluginContainer>();
    private final VelocityServer server;

    public VelocityPluginManager(VelocityServer server) {
        this.server = Preconditions.checkNotNull(server, "server");
    }

    private void registerPlugin(PluginContainer plugin) {
        this.plugins.put(plugin.getDescription().getId(), plugin);
        Optional<?> instance = plugin.getInstance();
        instance.ifPresent(o -> this.pluginInstances.put(o, plugin));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="I looked carefully and there's no way SpotBugs is right.")
    public void loadPlugins(Path directory) throws IOException {
        PluginContainer container;
        Preconditions.checkNotNull(directory, "directory");
        Preconditions.checkArgument(directory.toFile().isDirectory(), "provided path isn't a directory");
        ArrayList<PluginDescription> found = new ArrayList<PluginDescription>();
        JavaPluginLoader loader = new JavaPluginLoader(this.server, directory);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, p -> p.toFile().isFile() && p.toString().endsWith(".jar"));){
            for (Path path : stream) {
                try {
                    found.add(loader.loadPluginDescription(path));
                }
                catch (Exception e) {
                    logger.error("Unable to load plugin {}", (Object)path, (Object)e);
                }
            }
        }
        if (found.isEmpty()) {
            return;
        }
        List<PluginDescription> sortedPlugins = PluginDependencyUtils.sortCandidates(found);
        HashSet<String> loadedPluginsById = new HashSet<String>();
        final LinkedHashMap<PluginContainer, Module> pluginContainers = new LinkedHashMap<PluginContainer, Module>();
        block12: for (PluginDescription candidate : sortedPlugins) {
            for (PluginDependency dependency : candidate.getDependencies()) {
                if (dependency.isOptional() || loadedPluginsById.contains(dependency.getId())) continue;
                logger.error("Can't load plugin {} due to missing dependency {}", (Object)candidate.getId(), (Object)dependency.getId());
                continue block12;
            }
            try {
                PluginDescription realPlugin = loader.loadPlugin(candidate);
                container = new VelocityPluginContainer(realPlugin);
                pluginContainers.put(container, loader.createModule(container));
                loadedPluginsById.add(realPlugin.getId());
            }
            catch (Exception e) {
                logger.error("Can't create module for plugin {}", (Object)candidate.getId(), (Object)e);
            }
        }
        AbstractModule commonModule = new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(ProxyServer.class).toInstance(VelocityPluginManager.this.server);
                this.bind(PluginManager.class).toInstance(VelocityPluginManager.this.server.getPluginManager());
                this.bind(EventManager.class).toInstance(VelocityPluginManager.this.server.getEventManager());
                this.bind(CommandManager.class).toInstance(VelocityPluginManager.this.server.getCommandManager());
                for (PluginContainer container : pluginContainers.keySet()) {
                    this.bind(PluginContainer.class).annotatedWith(Names.named(container.getDescription().getId())).toInstance(container);
                }
            }
        };
        for (Map.Entry plugin : pluginContainers.entrySet()) {
            container = (PluginContainer)plugin.getKey();
            PluginDescription description = container.getDescription();
            try {
                loader.createPlugin(container, (Module)plugin.getValue(), commonModule);
            }
            catch (Exception e) {
                logger.error("Can't create plugin {}", (Object)description.getId(), (Object)e);
                continue;
            }
            logger.info("Loaded plugin {} {} by {}", (Object)description.getId(), (Object)description.getVersion().orElse("<UNKNOWN>"), (Object)Joiner.on(", ").join(description.getAuthors()));
            this.registerPlugin(container);
        }
    }

    @Override
    public Optional<PluginContainer> fromInstance(Object instance) {
        Preconditions.checkNotNull(instance, "instance");
        if (instance instanceof PluginContainer) {
            return Optional.of((PluginContainer)instance);
        }
        return Optional.ofNullable(this.pluginInstances.get(instance));
    }

    @Override
    public Optional<PluginContainer> getPlugin(String id) {
        Preconditions.checkNotNull(id, "id");
        return Optional.ofNullable(this.plugins.get(id));
    }

    @Override
    public Collection<PluginContainer> getPlugins() {
        return Collections.unmodifiableCollection(this.plugins.values());
    }

    @Override
    public boolean isLoaded(String id) {
        return this.plugins.containsKey(id);
    }

    @Override
    public void addToClasspath(Object plugin, Path path) {
        Preconditions.checkNotNull(plugin, "instance");
        Preconditions.checkNotNull(path, "path");
        Optional<PluginContainer> optContainer = this.fromInstance(plugin);
        Preconditions.checkArgument(optContainer.isPresent(), "plugin is not loaded");
        Optional<?> optInstance = optContainer.get().getInstance();
        Preconditions.checkArgument(optInstance.isPresent(), "plugin has no instance");
        ClassLoader pluginClassloader = optInstance.get().getClass().getClassLoader();
        if (!(pluginClassloader instanceof PluginClassLoader)) {
            throw new UnsupportedOperationException("Operation is not supported on non-Java Velocity plugins.");
        }
        ((PluginClassLoader)pluginClassloader).addPath(path);
    }
}

