/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.recipients.RecipientId;

public class ContactHelper {
    private final SignalAccount account;

    public ContactHelper(SignalAccount account) {
        this.account = account;
    }

    public boolean isContactBlocked(RecipientId recipientId) {
        Contact sourceContact = this.account.getContactStore().getContact(recipientId);
        return sourceContact != null && sourceContact.isBlocked();
    }

    public void setContactName(RecipientId recipientId, String givenName, String familyName) {
        Contact contact = this.account.getContactStore().getContact(recipientId);
        Contact.Builder builder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
        builder.withIsHidden(false);
        if (givenName != null) {
            builder.withGivenName(givenName);
        }
        if (familyName != null) {
            builder.withFamilyName(familyName);
        }
        this.account.getContactStore().storeContact(recipientId, builder.build());
    }

    public void setExpirationTimer(RecipientId recipientId, int messageExpirationTimer) {
        Contact.Builder builder;
        Contact contact = this.account.getContactStore().getContact(recipientId);
        if (contact != null && contact.messageExpirationTime() == messageExpirationTimer) {
            return;
        }
        Contact.Builder builder2 = builder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
        int version = contact == null ? 1 : (contact.messageExpirationTimeVersion() == Integer.MAX_VALUE ? Integer.MAX_VALUE : contact.messageExpirationTimeVersion() + 1);
        this.account.getContactStore().storeContact(recipientId, builder.withMessageExpirationTime(messageExpirationTimer).withMessageExpirationTimeVersion(version).build());
    }

    public void setExpirationTimer(RecipientId recipientId, int messageExpirationTimer, int messageExpirationTimerVersion) {
        Contact contact = this.account.getContactStore().getContact(recipientId);
        if (contact != null && (contact.messageExpirationTime() == messageExpirationTimer || contact.messageExpirationTimeVersion() >= messageExpirationTimerVersion)) {
            return;
        }
        Contact.Builder builder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
        this.account.getContactStore().storeContact(recipientId, builder.withMessageExpirationTime(messageExpirationTimer).withMessageExpirationTimeVersion(messageExpirationTimerVersion).build());
    }

    public void setContactBlocked(RecipientId recipientId, boolean blocked) {
        Contact.Builder builder;
        Contact contact = this.account.getContactStore().getContact(recipientId);
        Contact.Builder builder2 = builder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
        if (blocked) {
            builder.withIsProfileSharingEnabled(false);
        }
        this.account.getContactStore().storeContact(recipientId, builder.withIsBlocked(blocked).build());
    }

    public void setContactProfileSharing(RecipientId recipientId, boolean profileSharing) {
        Contact contact = this.account.getContactStore().getContact(recipientId);
        Contact.Builder builder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
        builder.withIsProfileSharingEnabled(profileSharing);
        this.account.getContactStore().storeContact(recipientId, builder.build());
    }

    public void setContactHidden(RecipientId recipientId, boolean hidden) {
        Contact contact = this.account.getContactStore().getContact(recipientId);
        Contact.Builder builder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
        this.account.getContactStore().storeContact(recipientId, builder.withIsHidden(hidden).build());
    }
}

