/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.senderKeys;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.helper.RecipientAddressResolver;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.storage.senderKeys.SenderKeyRecordStore;
import org.asamk.signal.manager.storage.senderKeys.SenderKeyStore;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.groups.state.SenderKeyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.ServiceId;

public class LegacySenderKeyRecordStore {
    private static final Logger logger = LoggerFactory.getLogger(LegacySenderKeyRecordStore.class);
    static final Pattern senderKeyFileNamePattern = Pattern.compile("(\\d+)_(\\d+)_([\\da-z\\-]+)");

    public static void migrate(File senderKeysPath, RecipientResolver resolver, RecipientAddressResolver addressResolver, SenderKeyStore senderKeyStore) {
        File[] files = senderKeysPath.listFiles();
        if (files == null) {
            return;
        }
        List<Pair<SenderKeyRecordStore.Key, SenderKeyRecord>> senderKeys = LegacySenderKeyRecordStore.parseFileNames(files, resolver).stream().map(key -> {
            SenderKeyRecord record = LegacySenderKeyRecordStore.loadSenderKeyLocked(key, senderKeysPath);
            Optional<ServiceId> serviceId = addressResolver.resolveRecipientAddress(key.recipientId).serviceId();
            if (record == null || serviceId.isEmpty()) {
                return null;
            }
            return new Pair<SenderKeyRecordStore.Key, SenderKeyRecord>(new SenderKeyRecordStore.Key(serviceId.get().toString(), key.deviceId, key.distributionId), record);
        }).filter(Objects::nonNull).toList();
        senderKeyStore.addLegacySenderKeys(senderKeys);
        LegacySenderKeyRecordStore.deleteAllSenderKeys(senderKeysPath);
    }

    private static void deleteAllSenderKeys(File senderKeysPath) {
        File[] files = senderKeysPath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.error("Failed to delete sender key file {}: {}", (Object)file, (Object)e.getMessage());
            }
        }
        try {
            Files.delete(senderKeysPath.toPath());
        }
        catch (IOException e) {
            logger.error("Failed to delete sender keys directory {}: {}", (Object)senderKeysPath, (Object)e.getMessage());
        }
    }

    private static List<Key> parseFileNames(File[] files, RecipientResolver resolver) {
        return Arrays.stream(files).map(f -> senderKeyFileNamePattern.matcher(f.getName())).filter(Matcher::matches).map(matcher -> {
            RecipientId recipientId = resolver.resolveRecipient(Long.parseLong(matcher.group(1)));
            if (recipientId == null) {
                return null;
            }
            return new Key(recipientId, Integer.parseInt(matcher.group(2)), UUID.fromString(matcher.group(3)));
        }).filter(Objects::nonNull).toList();
    }

    private static File getSenderKeyFile(Key key, File senderKeysPath) {
        return new File(senderKeysPath, key.recipientId().id() + "_" + key.deviceId() + "_" + key.distributionId().toString());
    }

    private static SenderKeyRecord loadSenderKeyLocked(Key key, File senderKeysPath) {
        SenderKeyRecord senderKeyRecord;
        File file = LegacySenderKeyRecordStore.getSenderKeyFile(key, senderKeysPath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            senderKeyRecord = new SenderKeyRecord(inputStream.readAllBytes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidMessageException e) {
                logger.warn("Failed to load sender key, resetting sender key: {}", (Object)e.getMessage());
                return null;
            }
        }
        inputStream.close();
        return senderKeyRecord;
    }

    record Key(RecipientId recipientId, int deviceId, UUID distributionId) {
    }
}

