/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.asamk.Signal;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.RecipientAddress;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.types.Variant;

public class DbusReceiveMessageHandler
implements Manager.ReceiveMessageHandler {
    private final DBusConnection conn;
    private final String objectPath;

    public DbusReceiveMessageHandler(DBusConnection conn, String objectPath) {
        this.conn = conn;
        this.objectPath = objectPath;
    }

    public void handleMessage(MessageEnvelope envelope, Throwable exception) {
        try {
            this.sendDbusMessages(envelope);
        }
        catch (DBusException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendDbusMessages(MessageEnvelope envelope) throws DBusException {
        MessageEnvelope.Sync.Sent transcript;
        MessageEnvelope.Sync syncMessage;
        String senderString = envelope.sourceAddress().map(RecipientAddress::getLegacyIdentifier).orElse("");
        if (envelope.receipt().isPresent()) {
            MessageEnvelope.Receipt receiptMessage = (MessageEnvelope.Receipt)envelope.receipt().get();
            String type = switch (receiptMessage.type()) {
                default -> throw new MatchException(null, null);
                case MessageEnvelope.Receipt.Type.READ -> "read";
                case MessageEnvelope.Receipt.Type.VIEWED -> "viewed";
                case MessageEnvelope.Receipt.Type.DELIVERY -> "delivery";
                case MessageEnvelope.Receipt.Type.UNKNOWN -> "unknown";
            };
            Iterator iterator = receiptMessage.timestamps().iterator();
            while (iterator.hasNext()) {
                long timestamp = (Long)iterator.next();
                this.conn.sendMessage((Message)new Signal.ReceiptReceived(this.objectPath, timestamp, senderString));
                this.conn.sendMessage((Message)new Signal.ReceiptReceivedV2(this.objectPath, timestamp, senderString, type, Map.of()));
            }
        }
        if (envelope.data().isPresent()) {
            MessageEnvelope.Data message = (MessageEnvelope.Data)envelope.data().get();
            byte[] groupId = message.groupContext().map(MessageEnvelope.Data.GroupContext::groupId).map(GroupId::serialize).orElseGet(() -> new byte[0]);
            Boolean isGroupUpdate = message.groupContext().map(MessageEnvelope.Data.GroupContext::isGroupUpdate).orElse(false);
            if (!message.isEndSession() && !isGroupUpdate.booleanValue()) {
                this.conn.sendMessage((Message)new Signal.MessageReceived(this.objectPath, message.timestamp(), senderString, groupId, message.body().orElse(""), this.getAttachments(message)));
                this.conn.sendMessage((Message)new Signal.MessageReceivedV2(this.objectPath, message.timestamp(), senderString, groupId, message.body().orElse(""), this.getMessageExtras(message)));
            }
        }
        if (envelope.edit().isPresent()) {
            MessageEnvelope.Edit editMessage = (MessageEnvelope.Edit)envelope.edit().get();
            MessageEnvelope.Data message = editMessage.dataMessage();
            byte[] groupId = message.groupContext().map(MessageEnvelope.Data.GroupContext::groupId).map(GroupId::serialize).orElseGet(() -> new byte[0]);
            Boolean isGroupUpdate = message.groupContext().map(MessageEnvelope.Data.GroupContext::isGroupUpdate).orElse(false);
            if (!message.isEndSession() && !isGroupUpdate.booleanValue()) {
                this.conn.sendMessage((Message)new Signal.EditMessageReceived(this.objectPath, message.timestamp(), editMessage.targetSentTimestamp(), senderString, groupId, message.body().orElse(""), this.getMessageExtras(message)));
            }
        }
        if (envelope.sync().isPresent() && (syncMessage = (MessageEnvelope.Sync)envelope.sync().get()).sent().isPresent() && (transcript = (MessageEnvelope.Sync.Sent)syncMessage.sent().get()).message().isPresent()) {
            MessageEnvelope.Data dataMessage = (MessageEnvelope.Data)transcript.message().get();
            if (transcript.destination().isPresent() || dataMessage.groupContext().isPresent()) {
                byte[] groupId = dataMessage.groupContext().map(MessageEnvelope.Data.GroupContext::groupId).map(GroupId::serialize).orElseGet(() -> new byte[0]);
                this.conn.sendMessage((Message)new Signal.SyncMessageReceived(this.objectPath, dataMessage.timestamp(), senderString, transcript.destination().map(RecipientAddress::getLegacyIdentifier).orElse(""), groupId, dataMessage.body().orElse(""), this.getAttachments(dataMessage)));
                this.conn.sendMessage((Message)new Signal.SyncMessageReceivedV2(this.objectPath, dataMessage.timestamp(), senderString, transcript.destination().map(RecipientAddress::getLegacyIdentifier).orElse(""), groupId, dataMessage.body().orElse(""), this.getMessageExtras(dataMessage)));
            }
        }
    }

    private List<String> getAttachments(MessageEnvelope.Data message) {
        ArrayList<String> attachments = new ArrayList<String>();
        if (!message.attachments().isEmpty()) {
            for (MessageEnvelope.Data.Attachment attachment : message.attachments()) {
                if (!attachment.file().isPresent()) continue;
                attachments.add(((File)attachment.file().get()).getAbsolutePath());
            }
        }
        return attachments;
    }

    private HashMap<String, Variant<?>> getMessageExtras(MessageEnvelope.Data message) {
        HashMap extras = new HashMap();
        if (!message.attachments().isEmpty()) {
            List<Map> attachments = message.attachments().stream().filter(a -> a.id().isPresent()).map(this::getAttachmentMap).toList();
            extras.put("attachments", new Variant(attachments, "aa{sv}"));
        }
        if (!message.mentions().isEmpty()) {
            List<Map> mentions = message.mentions().stream().map(this::getMentionMap).toList();
            extras.put("mentions", new Variant(mentions, "aa{sv}"));
        }
        extras.put("expiresInSeconds", new Variant((Object)message.expiresInSeconds()));
        if (message.quote().isPresent()) {
            extras.put("quote", new Variant(this.getQuoteMap((MessageEnvelope.Data.Quote)message.quote().get()), "a{sv}"));
        }
        if (message.reaction().isPresent()) {
            MessageEnvelope.Data.Reaction reaction = (MessageEnvelope.Data.Reaction)message.reaction().get();
            extras.put("reaction", new Variant(this.getReactionMap(reaction), "a{sv}"));
        }
        if (message.remoteDeleteId().isPresent()) {
            extras.put("remoteDelete", new Variant(Map.of("timestamp", new Variant((Object)((Long)message.remoteDeleteId().get()))), "a{sv}"));
        }
        if (message.sticker().isPresent()) {
            MessageEnvelope.Data.Sticker sticker = (MessageEnvelope.Data.Sticker)message.sticker().get();
            extras.put("sticker", new Variant(this.getStickerMap(sticker), "a{sv}"));
        }
        extras.put("isViewOnce", new Variant((Object)message.isViewOnce()));
        return extras;
    }

    private Map<String, Variant<?>> getQuoteMap(MessageEnvelope.Data.Quote quote) {
        return Map.of("id", new Variant((Object)quote.id()), "author", new Variant((Object)quote.author().getLegacyIdentifier()), "text", new Variant((Object)quote.text().orElse("")));
    }

    private Map<String, Variant<? extends Serializable>> getStickerMap(MessageEnvelope.Data.Sticker sticker) {
        return Map.of("packId", new Variant((Object)sticker.packId().serialize()), "stickerId", new Variant((Object)sticker.stickerId()));
    }

    private Map<String, Variant<?>> getReactionMap(MessageEnvelope.Data.Reaction reaction) {
        return Map.of("emoji", new Variant((Object)reaction.emoji()), "targetAuthor", new Variant((Object)reaction.targetAuthor().getLegacyIdentifier()), "targetSentTimestamp", new Variant((Object)reaction.targetSentTimestamp()), "isRemove", new Variant((Object)reaction.isRemove()));
    }

    private Map<String, Variant<?>> getAttachmentMap(MessageEnvelope.Data.Attachment a) {
        HashMap map = new HashMap();
        if (a.id().isPresent()) {
            map.put("remoteId", new Variant((Object)((String)a.id().get())));
        }
        if (a.file().isPresent()) {
            map.put("file", new Variant((Object)((File)a.file().get()).getAbsolutePath()));
        }
        map.put("contentType", new Variant((Object)a.contentType()));
        map.put("isVoiceNote", new Variant((Object)a.isVoiceNote()));
        map.put("isBorderless", new Variant((Object)a.isBorderless()));
        map.put("isGif", new Variant((Object)a.isGif()));
        if (a.caption().isPresent()) {
            map.put("caption", new Variant((Object)((String)a.caption().get())));
        }
        if (a.fileName().isPresent()) {
            map.put("fileName", new Variant((Object)((String)a.fileName().get())));
        }
        if (a.size().isPresent()) {
            map.put("size", new Variant((Object)((Long)a.size().get())));
        }
        if (a.width().isPresent()) {
            map.put("width", new Variant((Object)((Integer)a.width().get())));
        }
        if (a.height().isPresent()) {
            map.put("height", new Variant((Object)((Integer)a.height().get())));
        }
        return map;
    }

    private Map<String, Variant<?>> getMentionMap(MessageEnvelope.Data.Mention mention) {
        return Map.of("recipient", new Variant((Object)mention.recipient().getLegacyIdentifier()), "start", new Variant((Object)mention.start()), "length", new Variant((Object)mention.length()));
    }
}

