/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.jsonrpc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.runtime.SwitchBootstraps;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.asamk.signal.commands.Command;
import org.asamk.signal.commands.Commands;
import org.asamk.signal.commands.JsonRpcMultiCommand;
import org.asamk.signal.commands.JsonRpcSingleCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.json.JsonReceiveMessageHandler;
import org.asamk.signal.jsonrpc.JsonRpcReader;
import org.asamk.signal.jsonrpc.JsonRpcRequest;
import org.asamk.signal.jsonrpc.JsonRpcSender;
import org.asamk.signal.jsonrpc.SignalJsonRpcCommandHandler;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalJsonRpcDispatcherHandler {
    private static final Logger logger = LoggerFactory.getLogger(SignalJsonRpcDispatcherHandler.class);
    private final ObjectMapper objectMapper;
    private final JsonRpcSender jsonRpcSender;
    private final JsonRpcReader jsonRpcReader;
    private final boolean noReceiveOnStart;
    private final Map<Integer, List<Pair<Manager, Manager.ReceiveMessageHandler>>> receiveHandlers = new HashMap<Integer, List<Pair<Manager, Manager.ReceiveMessageHandler>>>();
    private SignalJsonRpcCommandHandler commandHandler;
    private static final AtomicInteger nextSubscriptionId = new AtomicInteger(0);

    public SignalJsonRpcDispatcherHandler(JsonWriter jsonWriter, Supplier<String> lineSupplier, boolean noReceiveOnStart) {
        this.noReceiveOnStart = noReceiveOnStart;
        this.objectMapper = Util.createJsonObjectMapper();
        this.jsonRpcSender = new JsonRpcSender(jsonWriter);
        this.jsonRpcReader = new JsonRpcReader(this.jsonRpcSender, lineSupplier);
    }

    public void handleConnection(MultiAccountManager c) {
        this.commandHandler = new SignalJsonRpcCommandHandler(c, this::getCommand);
        if (!this.noReceiveOnStart) {
            this.subscribeReceive(c.getManagers(), true);
            c.addOnManagerAddedHandler(m -> this.subscribeReceive((Manager)m, true));
            c.addOnManagerRemovedHandler(this::unsubscribeReceive);
        }
        this.handleConnection();
    }

    public void handleConnection(Manager m) {
        this.commandHandler = new SignalJsonRpcCommandHandler(m, this::getCommand);
        if (!this.noReceiveOnStart) {
            this.subscribeReceive(m, true);
        }
        Thread currentThread = Thread.currentThread();
        m.addClosedListener(currentThread::interrupt);
        this.handleConnection();
    }

    private int subscribeReceive(Manager manager, boolean internalSubscription) {
        return this.subscribeReceive(List.of(manager), internalSubscription);
    }

    private int subscribeReceive(List<Manager> managers, boolean internalSubscription) {
        int subscriptionId = nextSubscriptionId.getAndIncrement();
        List<Pair> handlers = managers.stream().map(m -> {
            JsonReceiveMessageHandler receiveMessageHandler = new JsonReceiveMessageHandler((Manager)m, s -> {
                block4: {
                    ContainerNode params;
                    if (internalSubscription) {
                        params = (ContainerNode)this.objectMapper.valueToTree(s);
                    } else {
                        ObjectNode paramsNode = new ObjectNode(this.objectMapper.getNodeFactory());
                        paramsNode.set("subscription", (JsonNode)IntNode.valueOf((int)subscriptionId));
                        paramsNode.set("result", this.objectMapper.valueToTree(s));
                        params = paramsNode;
                    }
                    JsonRpcRequest jsonRpcRequest = JsonRpcRequest.forNotification("receive", params, null);
                    try {
                        this.jsonRpcSender.sendRequest(jsonRpcRequest);
                    }
                    catch (AssertionError e) {
                        if (!(((Throwable)((Object)e)).getCause() instanceof ClosedChannelException)) break block4;
                        this.unsubscribeReceive(subscriptionId);
                    }
                }
            });
            m.addReceiveHandler((Manager.ReceiveMessageHandler)receiveMessageHandler);
            return new Pair(m, (Object)receiveMessageHandler);
        }).toList();
        this.receiveHandlers.put(subscriptionId, handlers);
        return subscriptionId;
    }

    private boolean unsubscribeReceive(int subscriptionId) {
        List<Pair<Manager, Manager.ReceiveMessageHandler>> handlers = this.receiveHandlers.remove(subscriptionId);
        if (handlers == null) {
            return false;
        }
        for (Pair<Manager, Manager.ReceiveMessageHandler> pair : handlers) {
            this.unsubscribeReceiveHandler(pair);
        }
        return true;
    }

    private void unsubscribeReceive(Manager m) {
        Optional<Integer> subscriptionId = this.receiveHandlers.entrySet().stream().filter(e -> ((List)e.getValue()).size() == 1 && ((Manager)((Pair)((List)e.getValue()).getFirst()).first()).equals((Object)m)).map(Map.Entry::getKey).findFirst();
        subscriptionId.ifPresent(this::unsubscribeReceive);
    }

    private void handleConnection() {
        try {
            this.jsonRpcReader.readMessages((method, params) -> this.commandHandler.handleRequest(this.objectMapper, method, params), response -> logger.debug("Received unexpected response for id {}", (Object)response.getId()));
        }
        finally {
            this.receiveHandlers.forEach((_subscriptionId, handlers) -> handlers.forEach(this::unsubscribeReceiveHandler));
            this.receiveHandlers.clear();
        }
    }

    private void unsubscribeReceiveHandler(Pair<Manager, Manager.ReceiveMessageHandler> pair) {
        Manager m = (Manager)pair.first();
        Manager.ReceiveMessageHandler handler = (Manager.ReceiveMessageHandler)pair.second();
        m.removeReceiveHandler(handler);
    }

    private Command getCommand(String method) {
        if ("subscribeReceive".equals(method)) {
            return new SubscribeReceiveCommand();
        }
        if ("unsubscribeReceive".equals(method)) {
            return new UnsubscribeReceiveCommand();
        }
        return Commands.getCommand(method);
    }

    private class SubscribeReceiveCommand
    implements JsonRpcSingleCommand<Void>,
    JsonRpcMultiCommand<Void> {
        private SubscribeReceiveCommand() {
        }

        @Override
        public String getName() {
            return "subscribeReceive";
        }

        @Override
        public void handleCommand(Void request, Manager m, JsonWriter jsonWriter) throws CommandException {
            int subscriptionId = SignalJsonRpcDispatcherHandler.this.subscribeReceive(m, false);
            jsonWriter.write(subscriptionId);
        }

        @Override
        public void handleCommand(Void request, MultiAccountManager c, JsonWriter jsonWriter) throws CommandException {
            int subscriptionId = SignalJsonRpcDispatcherHandler.this.subscribeReceive(c.getManagers(), false);
            jsonWriter.write(subscriptionId);
        }
    }

    private class UnsubscribeReceiveCommand
    implements JsonRpcSingleCommand<JsonNode>,
    JsonRpcMultiCommand<JsonNode> {
        private UnsubscribeReceiveCommand() {
        }

        @Override
        public String getName() {
            return "unsubscribeReceive";
        }

        @Override
        public TypeReference<JsonNode> getRequestType() {
            return new TypeReference<JsonNode>(this){};
        }

        @Override
        public void handleCommand(JsonNode request, Manager m, JsonWriter jsonWriter) throws CommandException {
            Integer subscriptionId = this.getSubscriptionId(request);
            if (subscriptionId == null) {
                SignalJsonRpcDispatcherHandler.this.unsubscribeReceive(m);
            } else if (!SignalJsonRpcDispatcherHandler.this.unsubscribeReceive(subscriptionId)) {
                throw new UserErrorException("Unknown subscription id");
            }
        }

        @Override
        public void handleCommand(JsonNode request, MultiAccountManager c, JsonWriter jsonWriter) throws CommandException {
            Integer subscriptionId = this.getSubscriptionId(request);
            if (subscriptionId == null) {
                throw new UserErrorException("Missing subscription parameter with subscription id");
            }
            if (!SignalJsonRpcDispatcherHandler.this.unsubscribeReceive(subscriptionId)) {
                throw new UserErrorException("Unknown subscription id");
            }
        }

        private Integer getSubscriptionId(JsonNode request) {
            JsonNode jsonNode = request;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayNode.class, ObjectNode.class}, (Object)jsonNode, n)) {
                case 0 -> {
                    ArrayNode req = (ArrayNode)jsonNode;
                    yield req.get(0).asInt();
                }
                case 1 -> {
                    ObjectNode req = (ObjectNode)jsonNode;
                    yield req.get("subscription").asInt();
                }
                default -> null;
            };
        }
    }
}

