/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.util;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.asamk.signal.util.RandomUtils;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jcajce.provider.asymmetric.x509.KeyFactory;
import org.bouncycastle.jcajce.provider.keystore.bc.BcKeyStoreSpi;

public class SecurityProvider
extends Provider {
    private static final String PROVIDER_NAME = "SSP";
    private static final String info = "Security Provider v1.0";

    public SecurityProvider() {
        super(PROVIDER_NAME, "1.0", info);
        this.put("SecureRandom.DEFAULT", DefaultRandom.class.getName());
        this.put("KeyStore.BKS", BcKeyStoreSpi.Std.class.getCanonicalName());
        this.put("KeyStore.BKS-V1", BcKeyStoreSpi.Version1.class.getCanonicalName());
        this.put("KeyStore.BouncyCastle", BcKeyStoreSpi.BouncyCastleStore.class.getCanonicalName());
        this.put("KeyFactory.X.509", KeyFactory.class.getCanonicalName());
        this.put("CertificateFactory.X.509", CertificateFactory.class.getCanonicalName());
    }

    public static class DefaultRandom
    extends SecureRandomSpi {
        private static final SecureRandom random = RandomUtils.getSecureRandom();

        @Override
        protected void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }
}

