/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.crypto;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;

public class CryptographicHash
implements NativeHandleGuard.Owner {
    private final long unsafeHandle = FilterExceptions.filterExceptions(() -> Native.CryptographicHash_New(algo));

    public CryptographicHash(String algo) {
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    protected void finalize() {
        Native.CryptographicHash_Destroy(this.unsafeHandle);
    }

    public void update(byte[] input, int offset, int len) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            Native.CryptographicHash_UpdateWithOffset(guard.nativeHandle(), input, offset, len);
        }
    }

    public void update(byte[] input) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            Native.CryptographicHash_Update(guard.nativeHandle(), input);
        }
    }

    public byte[] finish() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.CryptographicHash_Finalize(guard.nativeHandle());
            return byArray;
        }
    }
}

