/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.multidevice;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.signal.core.util.stream.LimitedInputStream;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.messages.multidevice.ChunkedInputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContact;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContactAvatar;
import org.whispersystems.signalservice.api.messages.multidevice.VerifiedMessage;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.push.ContactDetails;
import org.whispersystems.signalservice.internal.push.Verified;
import org.whispersystems.signalservice.internal.util.Util;

public class DeviceContactsInputStream
extends ChunkedInputStream {
    private static final String TAG = DeviceContactsInputStream.class.getSimpleName();

    public DeviceContactsInputStream(InputStream in) {
        super(in);
    }

    public DeviceContact read() throws IOException {
        int detailsLength = (int)this.readRawVarint32();
        if (detailsLength == -1) {
            return null;
        }
        byte[] detailsSerialized = new byte[detailsLength];
        Util.readFully(this.in, detailsSerialized);
        ContactDetails details = (ContactDetails)((Object)ContactDetails.ADAPTER.decode(detailsSerialized));
        if (!SignalServiceAddress.isValidAddress(details.aci, details.number)) {
            throw new IOException("Missing contact address!");
        }
        Optional<ServiceId.ACI> aci = Optional.ofNullable(ServiceId.ACI.parseOrNull(details.aci));
        Optional<String> e164 = Optional.ofNullable(details.number);
        Optional<String> name = Optional.ofNullable(details.name);
        Optional<DeviceContactAvatar> avatar = Optional.empty();
        Optional<String> color = details.color != null ? Optional.of(details.color) : Optional.empty();
        Optional<VerifiedMessage> verified = Optional.empty();
        Optional<ProfileKey> profileKey = Optional.empty();
        Optional<Integer> expireTimer = Optional.empty();
        Optional<Integer> expireTimerVersion = Optional.empty();
        Optional<Integer> inboxPosition = Optional.empty();
        boolean archived = false;
        if (details.avatar != null && details.avatar.length != null) {
            long avatarLength = details.avatar.length.intValue();
            LimitedInputStream avatarStream = new LimitedInputStream(this.in, avatarLength);
            String avatarContentType = details.avatar.contentType != null ? details.avatar.contentType : "image/*";
            avatar = Optional.of(new DeviceContactAvatar((InputStream)avatarStream, avatarLength, avatarContentType));
        }
        if (details.verified != null) {
            try {
                if (!SignalServiceAddress.isValidAddress(details.verified.destinationAci, null)) {
                    throw new InvalidMessageException("Missing Verified address!");
                }
                IdentityKey identityKey = new IdentityKey(details.verified.identityKey.toByteArray(), 0);
                SignalServiceAddress destination = new SignalServiceAddress(ServiceId.parseOrThrow(details.verified.destinationAci));
                verified = Optional.of(new VerifiedMessage(destination, identityKey, switch (details.verified.state) {
                    case Verified.State.VERIFIED -> VerifiedMessage.VerifiedState.VERIFIED;
                    case Verified.State.UNVERIFIED -> VerifiedMessage.VerifiedState.UNVERIFIED;
                    case Verified.State.DEFAULT -> VerifiedMessage.VerifiedState.DEFAULT;
                    default -> throw new InvalidMessageException("Unknown state: " + String.valueOf((Object)details.verified.state));
                }, System.currentTimeMillis()));
            }
            catch (InvalidKeyException | InvalidMessageException e) {
                Log.w((String)TAG, (Throwable)e);
                verified = Optional.empty();
            }
        }
        if (details.profileKey != null) {
            try {
                profileKey = Optional.ofNullable(new ProfileKey(details.profileKey.toByteArray()));
            }
            catch (InvalidInputException e) {
                Log.w((String)TAG, (String)"Invalid profile key ignored", (Throwable)e);
            }
        }
        if (details.expireTimer != null && details.expireTimer > 0) {
            expireTimer = Optional.of(details.expireTimer);
        }
        if (details.expireTimerVersion != null && details.expireTimerVersion > 0) {
            expireTimerVersion = Optional.of(details.expireTimerVersion);
        }
        if (details.inboxPosition != null) {
            inboxPosition = Optional.of(details.inboxPosition);
        }
        archived = details.archived;
        return new DeviceContact(aci, e164, name, avatar, color, verified, profileKey, expireTimer, expireTimerVersion, inboxPosition, archived);
    }
}

