/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push.exceptions;

import java.io.IOException;

public class NonSuccessfulResponseCodeException
extends IOException {
    private final int code;
    private final String body;

    public NonSuccessfulResponseCodeException(int code) {
        super("StatusCode: " + code);
        this.code = code;
        this.body = null;
    }

    public NonSuccessfulResponseCodeException(int code, String s) {
        super("[" + code + "] " + s);
        this.code = code;
        this.body = null;
    }

    public NonSuccessfulResponseCodeException(int code, String s, String body) {
        super("[" + code + "] " + s);
        this.code = code;
        this.body = body;
    }

    public int getCode() {
        return this.code;
    }

    public boolean is4xx() {
        return this.code >= 400 && this.code < 500;
    }

    public boolean is5xx() {
        return this.code >= 500 && this.code < 600;
    }

    public String getBody() {
        return this.body;
    }
}

