/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okio.ByteString;

public final class UuidUtil {
    public static final UUID UNKNOWN_UUID = new UUID(0L, 0L);
    public static final String UNKNOWN_UUID_STRING = UNKNOWN_UUID.toString();
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", 2);

    private UuidUtil() {
    }

    public static Optional<UUID> parse(String uuid) {
        return Optional.ofNullable(UuidUtil.parseOrNull(uuid));
    }

    public static UUID parseOrNull(@Nullable String uuid) {
        return UuidUtil.isUuid(uuid) ? UuidUtil.parseOrThrow(uuid) : null;
    }

    public static UUID parseOrUnknown(String uuid) {
        return uuid == null || uuid.isEmpty() ? UNKNOWN_UUID : UuidUtil.parseOrThrow(uuid);
    }

    public static UUID parseOrThrow(String uuid) {
        return UUID.fromString(uuid);
    }

    public static UUID parseOrThrow(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        long high = byteBuffer.getLong();
        long low = byteBuffer.getLong();
        return new UUID(high, low);
    }

    public static boolean isUuid(String uuid) {
        return uuid != null && UUID_PATTERN.matcher(uuid).matches();
    }

    public static byte[] toByteArray(@Nonnull UUID uuid) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return buffer.array();
    }

    public static ByteString toByteString(@Nonnull UUID uuid) {
        return ByteString.of((byte[])UuidUtil.toByteArray(uuid));
    }

    public static UUID fromByteString(ByteString bytes) {
        return UuidUtil.parseOrThrow(bytes.toByteArray());
    }

    @Nullable
    public static UUID fromByteStringOrNull(@Nullable ByteString bytes) {
        if (bytes == null) {
            return null;
        }
        return UuidUtil.parseOrNull(bytes.toByteArray());
    }

    public static UUID fromByteStringOrUnknown(ByteString bytes) {
        UUID uuid = UuidUtil.fromByteStringOrNull(bytes);
        return uuid != null ? uuid : UNKNOWN_UUID;
    }

    public static UUID parseOrNull(byte[] byteArray) {
        return byteArray != null && byteArray.length == 16 ? UuidUtil.parseOrThrow(byteArray) : null;
    }

    public static List<UUID> fromByteStrings(Collection<ByteString> byteStringCollection) {
        ArrayList<UUID> result2 = new ArrayList<UUID>(byteStringCollection.size());
        for (ByteString byteString : byteStringCollection) {
            result2.add(UuidUtil.fromByteString(byteString));
        }
        return result2;
    }

    public static List<UUID> filterKnown(Collection<UUID> uuids) {
        ArrayList<UUID> result2 = new ArrayList<UUID>(uuids.size());
        for (UUID uuid : uuids) {
            if (UNKNOWN_UUID.equals(uuid)) continue;
            result2.add(uuid);
        }
        return result2;
    }
}

