/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.contacts.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.whispersystems.signalservice.api.crypto.InvalidCiphertextException;
import org.whispersystems.signalservice.internal.util.Util;

final class AESCipher {
    private static final int TAG_LENGTH_BYTES = 16;
    private static final int TAG_LENGTH_BITS = 128;

    AESCipher() {
    }

    static byte[] decrypt(byte[] key, byte[] iv, byte[] ciphertext, byte[] tag) throws InvalidCiphertextException {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, iv));
            return cipher.doFinal(ByteUtil.combine((byte[][])new byte[][]{ciphertext, tag}));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeyException | BadPaddingException e) {
            throw new InvalidCiphertextException(e);
        }
    }

    static AESEncryptedResult encrypt(byte[] key, byte[] aad, byte[] requestData) {
        try {
            byte[] iv = Util.getSecretBytes(12);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, iv));
            if (aad != null) {
                cipher.updateAAD(aad);
            }
            byte[] cipherText = cipher.doFinal(requestData);
            byte[][] parts = ByteUtil.split((byte[])cipherText, (int)(cipherText.length - 16), (int)16);
            byte[] mac = parts[1];
            byte[] data = parts[0];
            return new AESEncryptedResult(iv, data, mac, aad);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class AESEncryptedResult {
        final byte[] iv;
        final byte[] data;
        final byte[] mac;
        final byte[] aad;

        private AESEncryptedResult(byte[] iv, byte[] data, byte[] mac, byte[] aad) {
            this.iv = iv;
            this.data = data;
            this.mac = mac;
            this.aad = aad;
        }
    }
}

