/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.contacts.crypto;

import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kdf.HKDFv3;
import org.signal.libsignal.protocol.util.ByteUtil;

public class RemoteAttestationKeys {
    private final byte[] clientKey = new byte[32];
    private final byte[] serverKey = new byte[32];

    public RemoteAttestationKeys(ECKeyPair keyPair, byte[] serverPublicEphemeral, byte[] serverPublicStatic) throws InvalidKeyException {
        byte[] ephemeralToEphemeral = Curve.calculateAgreement((ECPublicKey)ECPublicKey.fromPublicKeyBytes((byte[])serverPublicEphemeral), (ECPrivateKey)keyPair.getPrivateKey());
        byte[] ephemeralToStatic = Curve.calculateAgreement((ECPublicKey)ECPublicKey.fromPublicKeyBytes((byte[])serverPublicStatic), (ECPrivateKey)keyPair.getPrivateKey());
        byte[] masterSecret = ByteUtil.combine((byte[][])new byte[][]{ephemeralToEphemeral, ephemeralToStatic});
        byte[] publicKeys = ByteUtil.combine((byte[][])new byte[][]{keyPair.getPublicKey().getPublicKeyBytes(), serverPublicEphemeral, serverPublicStatic});
        HKDFv3 generator = new HKDFv3();
        byte[] keys = HKDFv3.deriveSecrets((byte[])masterSecret, (byte[])publicKeys, (byte[])new byte[0], (int)(this.clientKey.length + this.serverKey.length));
        System.arraycopy(keys, 0, this.clientKey, 0, this.clientKey.length);
        System.arraycopy(keys, this.clientKey.length, this.serverKey, 0, this.serverKey.length);
    }

    public byte[] getClientKey() {
        return this.clientKey;
    }

    public byte[] getServerKey() {
        return this.serverKey;
    }
}

