/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.protocol.incrementalmac.ChunkSizeChoice;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.crypto.DigestingOutputStream;
import org.whispersystems.signalservice.api.crypto.SkippingOutputStream;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.internal.crypto.AttachmentDigest;
import org.whispersystems.signalservice.internal.push.http.AttachmentCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.CancelationSignal;
import org.whispersystems.signalservice.internal.push.http.OutputStreamFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0011J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/whispersystems/signalservice/internal/push/http/DigestingRequestBody;", "Lokhttp3/RequestBody;", "inputStream", "Ljava/io/InputStream;", "outputStreamFactory", "Lorg/whispersystems/signalservice/internal/push/http/OutputStreamFactory;", "contentType", "", "contentLength", "", "incremental", "", "progressListener", "Lorg/whispersystems/signalservice/api/messages/SignalServiceAttachment$ProgressListener;", "cancelationSignal", "Lorg/whispersystems/signalservice/internal/push/http/CancelationSignal;", "contentStart", "(Ljava/io/InputStream;Lorg/whispersystems/signalservice/internal/push/http/OutputStreamFactory;Ljava/lang/String;JZLorg/whispersystems/signalservice/api/messages/SignalServiceAttachment$ProgressListener;Lorg/whispersystems/signalservice/internal/push/http/CancelationSignal;J)V", "attachmentDigest", "Lorg/whispersystems/signalservice/internal/crypto/AttachmentDigest;", "getAttachmentDigest", "()Lorg/whispersystems/signalservice/internal/crypto/AttachmentDigest;", "setAttachmentDigest", "(Lorg/whispersystems/signalservice/internal/crypto/AttachmentDigest;)V", "Lokhttp3/MediaType;", "isOneShot", "logMessage", "actual", "expected", "writeTo", "", "sink", "Lokio/BufferedSink;", "Companion", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nDigestingRequestBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigestingRequestBody.kt\norg/whispersystems/signalservice/internal/push/http/DigestingRequestBody\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class DigestingRequestBody
extends RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final OutputStreamFactory outputStreamFactory;
    @NotNull
    private final String contentType;
    private final long contentLength;
    private final boolean incremental;
    @Nullable
    private final SignalServiceAttachment.ProgressListener progressListener;
    @Nullable
    private final CancelationSignal cancelationSignal;
    private final long contentStart;
    @Nullable
    private AttachmentDigest attachmentDigest;
    @NotNull
    public static final String TAG = "DigestingRequestBody";

    public DigestingRequestBody(@NotNull InputStream inputStream, @NotNull OutputStreamFactory outputStreamFactory, @NotNull String contentType, long contentLength, boolean incremental, @Nullable SignalServiceAttachment.ProgressListener progressListener, @Nullable CancelationSignal cancelationSignal, long contentStart) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStreamFactory, (String)"outputStreamFactory");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.inputStream = inputStream;
        this.outputStreamFactory = outputStreamFactory;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.incremental = incremental;
        this.progressListener = progressListener;
        this.cancelationSignal = cancelationSignal;
        this.contentStart = contentStart;
        if (!(this.contentLength >= this.contentStart)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.contentStart >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final AttachmentDigest getAttachmentDigest() {
        return this.attachmentDigest;
    }

    public final void setAttachmentDigest(@Nullable AttachmentDigest attachmentDigest) {
        this.attachmentDigest = attachmentDigest;
    }

    @Nullable
    public MediaType contentType() {
        return MediaType.Companion.parse(this.contentType);
    }

    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        byte[] byArray;
        DigestingOutputStream digestingOutputStream;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        ByteArrayOutputStream digestStream = new ByteArrayOutputStream();
        SkippingOutputStream inner = new SkippingOutputStream(this.contentStart, sink.outputStream());
        boolean isIncremental = this.incremental && this.outputStreamFactory instanceof AttachmentCipherOutputStreamFactory;
        ChunkSizeChoice chunkSizeChoice = ChunkSizeChoice.inferChunkSize((int)((int)this.contentLength));
        Intrinsics.checkNotNullExpressionValue((Object)chunkSizeChoice, (String)"inferChunkSize(...)");
        ChunkSizeChoice sizeChoice = chunkSizeChoice;
        if (isIncremental) {
            OutputStreamFactory outputStreamFactory = this.outputStreamFactory;
            Intrinsics.checkNotNull((Object)outputStreamFactory, (String)"null cannot be cast to non-null type org.whispersystems.signalservice.internal.push.http.AttachmentCipherOutputStreamFactory");
            digestingOutputStream = ((AttachmentCipherOutputStreamFactory)outputStreamFactory).createIncrementalFor(inner, this.contentLength, sizeChoice, digestStream);
        } else {
            DigestingOutputStream digestingOutputStream2 = this.outputStreamFactory.createFor(inner);
            Intrinsics.checkNotNull((Object)digestingOutputStream2);
            digestingOutputStream = digestingOutputStream2;
        }
        DigestingOutputStream outputStream = digestingOutputStream;
        byte[] buffer = new byte[16384];
        int read = 0;
        while (true) {
            int n;
            int it = n = this.inputStream.read(buffer, 0, buffer.length);
            boolean bl = false;
            read = it;
            if (n == -1) break;
            CancelationSignal cancelationSignal = this.cancelationSignal;
            boolean bl2 = cancelationSignal != null ? cancelationSignal.isCanceled() : false;
            if (bl2) {
                throw new IOException("Canceled!");
            }
            outputStream.write(buffer, 0, read);
            SignalServiceAttachment.ProgressListener progressListener = this.progressListener;
            if (progressListener == null) continue;
            progressListener.onAttachmentProgress(this.contentLength, outputStream.getTotalBytesWritten());
        }
        outputStream.flush();
        if (isIncremental) {
            if (this.contentLength != outputStream.getTotalBytesWritten()) {
                Log.w((String)TAG, (String)("Content uploaded " + this.logMessage(outputStream.getTotalBytesWritten(), this.contentLength) + " bytes compared to expected!"));
            } else {
                Log.d((String)TAG, (String)"Wrote the expected number of bytes.");
            }
            outputStream.close();
            digestStream.close();
            byte[] byArray2 = digestStream.toByteArray();
            Intrinsics.checkNotNull((Object)byArray2);
            byArray = byArray2;
        } else {
            byArray = new byte[]{};
        }
        byte[] incrementalDigest = byArray;
        byte[] byArray3 = outputStream.getTransmittedDigest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getTransmittedDigest(...)");
        this.attachmentDigest = new AttachmentDigest(byArray3, incrementalDigest, sizeChoice.getSizeInBytes());
    }

    public long contentLength() {
        return this.contentLength > 0L ? this.contentLength - this.contentStart : -1L;
    }

    public boolean isOneShot() {
        return true;
    }

    private final String logMessage(long actual, long expected) {
        long difference = actual - expected;
        return difference > 0L ? "+" + difference : String.valueOf(difference);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/whispersystems/signalservice/internal/push/http/DigestingRequestBody$Companion;", "", "()V", "TAG", "", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

