# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.FunctionCall do
  @moduledoc "An active function call."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  defstruct [:selection, :client]

  (
    @doc "A unique identifier for this FunctionCall."
    @spec id(t()) :: {:ok, Dagger.FunctionCallID.t()} | {:error, term()}
    def id(%__MODULE__{} = function_call) do
      selection = select(function_call.selection, "id")
      execute(selection, function_call.client)
    end
  )

  (
    @doc ""
    @spec input_args(t()) :: {:ok, [Dagger.FunctionCallArgValue.t()]} | {:error, term()}
    def input_args(%__MODULE__{} = function_call) do
      selection = select(function_call.selection, "inputArgs")
      selection = select(selection, "id name value")

      with {:ok, data} <- execute(selection, function_call.client) do
        {:ok,
         data
         |> Enum.map(fn value ->
           elem_selection = Dagger.QueryBuilder.Selection.query()
           elem_selection = select(elem_selection, "loadFunctionCallArgValueFromID")
           elem_selection = arg(elem_selection, "id", value["id"])
           %Dagger.FunctionCallArgValue{selection: elem_selection, client: function_call.client}
         end)}
      end
    end
  )

  (
    @doc ""
    @spec name(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def name(%__MODULE__{} = function_call) do
      selection = select(function_call.selection, "name")
      execute(selection, function_call.client)
    end
  )

  (
    @doc ""
    @spec parent(t()) :: {:ok, Dagger.JSON.t()} | {:error, term()}
    def parent(%__MODULE__{} = function_call) do
      selection = select(function_call.selection, "parent")
      execute(selection, function_call.client)
    end
  )

  (
    @doc ""
    @spec parent_name(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def parent_name(%__MODULE__{} = function_call) do
      selection = select(function_call.selection, "parentName")
      execute(selection, function_call.client)
    end
  )

  (
    @doc "Set the return value of the function call to the provided value.\n\n## Required Arguments\n\n* `value` - JSON serialization of the return value."
    @spec return_value(t(), Dagger.JSON.t()) :: {:ok, Dagger.Void.t() | nil} | {:error, term()}
    def return_value(%__MODULE__{} = function_call, value) do
      selection = select(function_call.selection, "returnValue")
      selection = arg(selection, "value", value)
      execute(selection, function_call.client)
    end
  )
end
