/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class AdddomainsToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<Domain> DOMAIN_CLASS = Domain.class;

    public String getTokenName() {
        return "ADDDOMAINS";
    }

    protected char separator() {
        return '.';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        Prerequisite prereq;
        String tokString;
        ParseResult pr = this.checkForIllegalSeparator('|', value);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer pipeTok = new StringTokenizer(value, "|");
        String first = pipeTok.nextToken();
        ArrayList<AssociatedPrereqObject> apoList = new ArrayList<AssociatedPrereqObject>();
        StringTokenizer tok = new StringTokenizer(first, ".");
        while (tok.hasMoreTokens()) {
            String domainKey;
            tokString = tok.nextToken();
            prereq = null;
            int openBracketLoc = tokString.indexOf(91);
            if (openBracketLoc == -1) {
                if (tokString.indexOf(93) != -1) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + " must have '[' if it contains a PREREQ tag", context);
                }
                domainKey = tokString;
            } else {
                if (tokString.indexOf(93) != tokString.length() - 1) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + " must end with ']' if it contains a PREREQ tag", context);
                }
                domainKey = tokString.substring(0, openBracketLoc);
                String prereqString = tokString.substring(openBracketLoc + 1, tokString.length() - 1);
                if (prereqString.length() == 0) {
                    return new ParseResult.Fail(this.getTokenName() + " cannot have empty prerequisite : " + value, context);
                }
                prereq = this.getPrerequisite(prereqString);
                if (prereq == null) {
                    return new ParseResult.Fail(this.getTokenName() + " had invalid prerequisite : " + prereqString, context);
                }
                Logging.deprecationPrint((String)(this.getTokenName() + " using PRExxx in brackets is deprecated: " + value + " ... Please use a trailing pipe: " + this.getTokenName() + ":x|PRExxx"), (LoadContext)context);
            }
            AssociatedPrereqObject apo = context.getListContext().addToList(this.getTokenName(), (CDOMObject)pcc, PCClass.ALLOWED_DOMAINS, (CDOMReference)context.getReferenceContext().getCDOMReference(DOMAIN_CLASS, domainKey));
            apoList.add(apo);
            if (prereq == null) continue;
            apo.addPrerequisite(prereq);
        }
        while (true) {
            if (!pipeTok.hasMoreTokens()) {
                return ParseResult.SUCCESS;
            }
            tokString = pipeTok.nextToken();
            if (this.looksLikeAPrerequisite(tokString)) break;
            AssociatedPrereqObject apo = context.getListContext().addToList(this.getTokenName(), (CDOMObject)pcc, PCClass.ALLOWED_DOMAINS, (CDOMReference)context.getReferenceContext().getCDOMReference(DOMAIN_CLASS, tokString));
            apoList.add(apo);
        }
        while (true) {
            if ((prereq = this.getPrerequisite(tokString)) == null) {
                return new ParseResult.Fail(this.getTokenName() + " had invalid prerequisite : " + tokString, context);
            }
            for (AssociatedPrereqObject apo : apoList) {
                apo.addPrerequisite(prereq);
            }
            if (!pipeTok.hasMoreTokens()) break;
            tokString = pipeTok.nextToken();
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), (CDOMObject)pcc, PCClass.ALLOWED_DOMAINS);
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty() || changes.includesGlobalClear()) {
            context.addWriteMessage(this.getTokenName() + " does not support .CLEAR");
            return null;
        }
        MapToList mtl = changes.getAddedAssociations();
        if (mtl == null || mtl.isEmpty()) {
            return null;
        }
        PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
        TreeSet<String> set = new TreeSet<String>();
        TreeSet<String> noPrereqSet = new TreeSet<String>();
        for (CDOMReference domain : mtl.getKeySet()) {
            for (AssociatedPrereqObject assoc : mtl.getListFor((Object)domain)) {
                StringBuilder sb = new StringBuilder(domain.getLSTformat(false));
                List prereqs = assoc.getPrerequisiteList();
                if (prereqs == null || prereqs.size() == 0) {
                    noPrereqSet.add(sb.toString());
                    continue;
                }
                for (Prerequisite prereq : prereqs) {
                    sb.append("|");
                    StringWriter swriter = new StringWriter();
                    try {
                        prereqWriter.write((Writer)swriter, prereq);
                    }
                    catch (PersistenceLayerException e) {
                        context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                        return null;
                    }
                    sb.append(swriter.toString());
                }
                set.add(sb.toString());
            }
        }
        if (!noPrereqSet.isEmpty()) {
            set.add(StringUtil.join(noPrereqSet, (String)"|"));
        }
        return set.toArray(new String[set.size()]);
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

