/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import pcgen.cdom.base.Loadable;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class TabInfo
implements Loadable {
    private URI sourceURI;
    private String tabName = "";
    private Tab tabID;
    private boolean isVisible = true;
    private File helpFile;
    private Set<Integer> hiddenColumns;
    private String helpContext;

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(URI source) {
        this.sourceURI = source;
    }

    public void setTab(Tab tab) {
        this.tabID = tab;
    }

    @Override
    public void setName(String name) {
        if (!Tab.exists(name)) {
            throw new IllegalArgumentException(name + " is not a valid Tab name");
        }
        this.tabID = Tab.getTab(name);
    }

    @Override
    public String getDisplayName() {
        return this.tabID.toString();
    }

    @Override
    public String getKeyName() {
        return this.getDisplayName();
    }

    public void setTabName(String name) {
        this.tabName = name;
    }

    public String getTabName() {
        return this.tabName;
    }

    public String getResolvedName() {
        String temp = this.tabName;
        if (temp.startsWith("in_")) {
            temp = LanguageBundle.getString(temp);
        }
        return temp;
    }

    @Override
    public String getLSTformat() {
        return this.getKeyName();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isType(String type) {
        return false;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public Tab getTab() {
        return this.tabID;
    }

    public void clearHiddenColumns() {
        if (this.hiddenColumns != null) {
            this.hiddenColumns.clear();
        }
    }

    public void hideColumn(int column) {
        if (this.hiddenColumns == null) {
            this.hiddenColumns = new HashSet<Integer>();
        }
        this.hiddenColumns.add(column);
    }

    public boolean isColumnVisible(int column) {
        return this.hiddenColumns == null || !this.hiddenColumns.contains(column);
    }

    public Collection<Integer> getHiddenColumns() {
        if (this.hiddenColumns == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableSet(this.hiddenColumns);
    }

    public void setHelpContext(File context) {
        this.helpFile = context;
    }

    public File getHelpContext() {
        return this.helpFile;
    }

    public String getRawHelpContext() {
        return this.helpContext;
    }

    public void setRawHelpContext(String value) {
        this.helpContext = value;
    }
}

