/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.PrerequisiteFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;

public class AddedTemplateFacet
extends AbstractSourcedListFacet<CharID, PCTemplate>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private PrerequisiteFacet prerequisiteFacet;
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private CDOMObjectConsolidationFacet consolidationFacet;

    public Collection<PCTemplate> select(CharID id, CDOMObject po) {
        ArrayList<PCTemplate> list = new ArrayList<PCTemplate>();
        this.removeAll(id, po);
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (!pc.isImporting()) {
            for (CDOMReference<PCTemplate> ref : po.getSafeListFor(ListKey.TEMPLATE)) {
                for (PCTemplate pct : ref.getContainedObjects()) {
                    this.add(id, pct, po);
                    list.add(pct);
                }
            }
            ArrayList<PCTemplate> added = new ArrayList<PCTemplate>();
            for (CDOMReference<PCTemplate> ref : po.getSafeListFor(ListKey.TEMPLATE_ADDCHOICE)) {
                added.addAll(ref.getContainedObjects());
            }
            for (CDOMReference<PCTemplate> ref : po.getSafeListFor(ListKey.TEMPLATE_CHOOSE)) {
                ArrayList<PCTemplate> chooseList = new ArrayList<PCTemplate>(added);
                chooseList.addAll(ref.getContainedObjects());
                PCTemplate selected = this.chooseTemplate(po, chooseList, true, id);
                if (selected == null) continue;
                this.add(id, selected, po);
                list.add(selected);
            }
        }
        return list;
    }

    public Collection<PCTemplate> remove(CharID id, CDOMObject po) {
        ArrayList<PCTemplate> list = new ArrayList<PCTemplate>();
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (!pc.isImporting()) {
            for (CDOMReference<PCTemplate> ref : po.getSafeListFor(ListKey.REMOVE_TEMPLATES)) {
                for (PCTemplate pct : ref.getContainedObjects()) {
                    list.add(pct);
                }
            }
        }
        return list;
    }

    public PCTemplate chooseTemplate(CDOMObject anOwner, List<PCTemplate> list, boolean forceChoice, CharID id) {
        ArrayList<PCTemplate> availableList = new ArrayList<PCTemplate>();
        for (PCTemplate pct : list) {
            if (!this.prerequisiteFacet.qualifies(id, pct, anOwner)) continue;
            availableList.add(pct);
        }
        if (availableList.size() == 1) {
            return (PCTemplate)availableList.get(0);
        }
        if (availableList.size() < 1) {
            return null;
        }
        List selectedList = new ArrayList(1);
        String title = "Template Choice";
        if (anOwner != null) {
            title = title + " (" + anOwner.getDisplayName() + ")";
        }
        if ((selectedList = Globals.getChoiceFromList(title, availableList, selectedList, 1, forceChoice, false, this.trackingFacet.getPC(id))).size() == 1) {
            return (PCTemplate)selectedList.get(0);
        }
        return null;
    }

    public Collection<PCTemplate> getFromSource(CharID id, CDOMObject cdo) {
        ArrayList<PCTemplate> list = new ArrayList<PCTemplate>();
        Map map = this.getCachedMap(id);
        if (map != null) {
            for (Map.Entry me : map.entrySet()) {
                Set<Object> sourceSet = me.getValue();
                if (!sourceSet.contains(cdo)) continue;
                list.add((PCTemplate)me.getKey());
            }
        }
        return list;
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CharID id = dfce.getCharID();
        CDOMObject cdo = dfce.getCDOMObject();
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        Collection<PCTemplate> list = this.getFromSource(id, cdo);
        if (list.isEmpty()) {
            for (PCTemplate pct : this.select(id, cdo)) {
                pc.addTemplate(pct);
            }
            for (PCTemplate pct : this.remove(id, cdo)) {
                pc.removeTemplate(pct);
            }
        } else {
            for (PCTemplate pct : list) {
                pc.addTemplate(pct);
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        CharID id = dfce.getCharID();
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        Collection<PCTemplate> list = this.getFromSource(id, cdo);
        if (list != null) {
            for (PCTemplate pct : list) {
                pc.removeTemplate(pct);
            }
        }
        this.removeAll(id, cdo);
        List<CDOMReference<PCTemplate>> refList = cdo.getListFor(ListKey.TEMPLATE);
        if (refList != null) {
            for (CDOMReference cDOMReference : refList) {
                for (PCTemplate pct : cDOMReference.getContainedObjects()) {
                    pc.removeTemplate(pct);
                }
            }
        }
    }

    public void setPrerequisiteFacet(PrerequisiteFacet prerequisiteFacet) {
        this.prerequisiteFacet = prerequisiteFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

