/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.core.TextProperty;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public final class SpecialProperty
extends TextProperty {
    public SpecialProperty() {
    }

    public SpecialProperty(String name) {
        super(name);
    }

    public static SpecialProperty createFromLst(String input) {
        StringTokenizer tok = new StringTokenizer(input, "|", false);
        SpecialProperty sp = new SpecialProperty();
        if (!tok.hasMoreTokens()) {
            return sp;
        }
        String spName = tok.nextToken();
        if (PreParserFactory.isPreReqString(spName)) {
            Logging.errorPrint("Leading PRExxx found in SPROP: " + input);
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(spName);
        boolean hitPre = false;
        boolean warnedPre = false;
        while (tok.hasMoreTokens()) {
            String cString = tok.nextToken();
            if (PreParserFactory.isPreReqString(cString)) {
                hitPre = true;
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    Prerequisite prereq = factory.parse(cString);
                    sp.addPrerequisite(prereq);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                    return null;
                }
            } else {
                if (hitPre && !warnedPre) {
                    warnedPre = true;
                    Logging.deprecationPrint("Found PRExxx in middle ofSPROP value: " + input);
                    Logging.deprecationPrint("PRExxx should be at the end");
                }
                sb.append("|");
                sb.append(cString);
            }
            if (!".CLEAR".equals(cString)) continue;
            Logging.errorPrint("Invalid/Embedded .CLEAR found in SPROP: " + input);
            return null;
        }
        sp.setName(sb.toString());
        return sp;
    }
}

