/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public class DIWarningDialog
extends JDialog
implements ActionListener {
    private String fileText;
    private String introText;
    private int result = 2;
    private static final String ACTION_YES = "yes";
    private static final String ACTION_NO = "no";
    private static final String ACTION_CANCEL = "cancel";

    public DIWarningDialog(Frame parent, String fileList, String introText) {
        super(parent, LanguageBundle.getString("in_dataInstaller"), true);
        this.fileText = fileList;
        this.introText = introText;
        this.initComponents();
        Utility.setDialogRelativeLocation(parent, this);
    }

    public int getResponse() {
        return this.result;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JLabel introLabel = new JLabel(this.introText);
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0);
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 5, 10);
        this.add((Component)introLabel, gbc);
        JTextArea messageArea = new JTextArea();
        messageArea.setName("errorMessageBox");
        messageArea.setEditable(false);
        messageArea.setTabSize(8);
        messageArea.setText(this.fileText);
        JScrollPane messageAreaContainer = new JScrollPane(messageArea);
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 1.0);
        gbc.fill = 1;
        gbc.insets = new Insets(5, 10, 5, 10);
        this.add((Component)messageAreaContainer, gbc);
        JLabel dummy = new JLabel(" ");
        Utility.buildRelativeConstraints(gbc, 1, 1, 1.0, 0.0, 2, 17);
        this.add((Component)dummy, gbc);
        JButton yesButton = new JButton(LanguageBundle.getString("in_yes"));
        yesButton.setActionCommand(ACTION_YES);
        yesButton.addActionListener(this);
        Utility.buildRelativeConstraints(gbc, 1, 1, 0.0, 0.0, 0, 13);
        gbc.insets = new Insets(5, 5, 10, 5);
        this.add((Component)yesButton, gbc);
        JButton noButton = new JButton(LanguageBundle.getString("in_no"));
        noButton.setActionCommand(ACTION_NO);
        noButton.addActionListener(this);
        Utility.buildRelativeConstraints(gbc, 1, 1, 0.0, 0.0, 0, 13);
        this.add((Component)noButton, gbc);
        JButton cancelButton = new JButton(LanguageBundle.getString("in_cancel"));
        cancelButton.setActionCommand(ACTION_CANCEL);
        cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(cancelButton);
        Utility.buildRelativeConstraints(gbc, 0, 0, 0.0, 0.0, 0, 13);
        gbc.insets = new Insets(5, 5, 10, 10);
        this.add((Component)cancelButton, gbc);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DIWarningDialog.this.result = 2;
                DIWarningDialog.this.setVisible(false);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.result = ACTION_YES.equals(e.getActionCommand()) ? 0 : (ACTION_NO.equals(e.getActionCommand()) ? 1 : 2);
        this.setVisible(false);
    }
}

