/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.models;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import org.apache.commons.lang.StringUtils;
import pcgen.base.lang.UnreachableError;
import pcgen.facade.core.CharacterFacade;
import pcgen.io.ExportHandler;
import pcgen.util.Logging;

public class HtmlSheetSupport {
    private static final ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("html-sheet-thread");
            return thread;
        }
    };
    private ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
    private WeakReference<CharacterFacade> characterRef;
    private final File templateFile;
    private final JEditorPane htmlPane;
    private ImageCache cache = new ImageCache();
    private FutureTask<HTMLDocument> refresher = null;
    private boolean installed = false;
    private String missingSheetMsg;

    public HtmlSheetSupport(JEditorPane htmlPane, String infoSheetFile) {
        this.templateFile = !StringUtils.isEmpty(infoSheetFile) ? new File(infoSheetFile) : null;
        this.htmlPane = htmlPane;
    }

    public HtmlSheetSupport(CharacterFacade character, JEditorPane htmlPane, String infoSheetFile) {
        this(htmlPane, infoSheetFile);
        this.setCharacter(character);
    }

    public void setCharacter(CharacterFacade character) {
        this.characterRef = new WeakReference<CharacterFacade>(character);
    }

    public void install() {
        this.installed = true;
        this.refresh();
    }

    public void uninstall() {
        this.installed = false;
    }

    public void refresh() {
        if (this.templateFile == null) {
            this.htmlPane.setText(this.missingSheetMsg);
            return;
        }
        if (this.characterRef == null || this.characterRef.get() == null) {
            return;
        }
        if (this.refresher != null && !this.refresher.isDone()) {
            this.refresher.cancel(false);
        }
        this.refresher = new Refresher();
        this.executor.execute(this.refresher);
    }

    public void setMissingSheetMsg(String missingSheetMsg) {
        this.missingSheetMsg = missingSheetMsg;
    }

    private static class ImageCache
    extends Dictionary<URL, Image> {
        private HashMap<URL, Image> cache = new HashMap();

        private ImageCache() {
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        @Override
        public Enumeration<URL> keys() {
            return Collections.enumeration(this.cache.keySet());
        }

        @Override
        public Enumeration<Image> elements() {
            return Collections.enumeration(this.cache.values());
        }

        @Override
        public Image get(Object key) {
            if (!(key instanceof URL)) {
                return null;
            }
            URL src = (URL)key;
            if (!this.cache.containsKey(src)) {
                Image newImage = Toolkit.getDefaultToolkit().createImage(src);
                if (newImage != null) {
                    ImageIcon ii = new ImageIcon();
                    ii.setImage(newImage);
                }
                this.cache.put(src, newImage);
            }
            return this.cache.get(src);
        }

        @Override
        public Image put(URL key, Image value) {
            return this.cache.put(key, value);
        }

        @Override
        public Image remove(Object key) {
            return this.cache.remove(key);
        }
    }

    private class DocumentBuilder
    implements Callable<HTMLDocument> {
        private DocumentBuilder() {
        }

        @Override
        public HTMLDocument call() throws Exception {
            StringWriter writer = new StringWriter();
            ((CharacterFacade)HtmlSheetSupport.this.characterRef.get()).export(new ExportHandler(HtmlSheetSupport.this.templateFile), new BufferedWriter(writer));
            StringReader reader = new StringReader(writer.toString());
            EditorKit kit = HtmlSheetSupport.this.htmlPane.getEditorKit();
            HTMLDocument doc = new HTMLDocument();
            doc.setBase(HtmlSheetSupport.this.templateFile.getParentFile().toURI().toURL());
            doc.putProperty("IgnoreCharsetDirective", true);
            doc.putProperty("imageCache", HtmlSheetSupport.this.cache);
            kit.read(reader, (Document)doc, 0);
            return doc;
        }
    }

    private class Refresher
    extends FutureTask<HTMLDocument> {
        public Refresher() {
            super(new DocumentBuilder());
        }

        @Override
        protected void done() {
            if (!HtmlSheetSupport.this.installed || this.isCancelled()) {
                return;
            }
            try {
                final HTMLDocument doc = (HTMLDocument)this.get();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        HtmlSheetSupport.this.htmlPane.setDocument(doc);
                    }
                });
            }
            catch (InvocationTargetException ex) {
                throw new UnreachableError();
            }
            catch (InterruptedException ex) {
                Logging.errorPrint(HtmlSheetSupport.this.templateFile.getName(), ex);
            }
            catch (ExecutionException ex) {
                Logging.errorPrint(HtmlSheetSupport.this.templateFile.getName(), ex.getCause());
            }
        }
    }
}

