/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.nfunk.jep.ParseException;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.ChronicleEntry;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.display.SkillDisplay;
import pcgen.system.PCGenSettings;
import pcgen.util.AbstractCountCommand;
import pcgen.util.Logging;
import pcgen.util.ParameterTree;
import pcgen.util.enumeration.View;
import pcgen.util.enumeration.Visibility;

public abstract class JepCountType {
    private static CaseInsensitiveMap<JepCountType> typeMap = null;
    public static final JepCountType ABILITIESDISTINCT = new JepCountAbilities(){

        @Override
        protected Double countData(Collection<? extends CNAbility> filtered, PlayerCharacter pc) {
            if (this.assocList.isEmpty()) {
                return filtered.size();
            }
            double accum = 0.0;
            for (CNAbility cNAbility : filtered) {
                for (String assoc : pc.getAssociationList(cNAbility)) {
                    if (!this.assocList.contains(assoc)) continue;
                    accum += 1.0;
                }
            }
            return accum;
        }
    };
    public static final JepCountType ABILITIES = new JepCountAbilities(){

        @Override
        protected Double countData(Collection<? extends CNAbility> filtered, PlayerCharacter pc) {
            double accum = 0.0;
            for (CNAbility cNAbility : filtered) {
                if (this.assocList.isEmpty()) {
                    double ac = pc.getSelectCorrectedAssociationCount(cNAbility);
                    accum += 1.01 >= ac ? 1.0 : ac;
                    continue;
                }
                for (String assoc : pc.getAssociationList(cNAbility)) {
                    if (!this.assocList.contains(assoc)) continue;
                    accum += 1.0;
                }
            }
            return accum;
        }
    };
    public static final JepCountType CAMPAIGNHISTORY = new JepCountFilterable<ChronicleEntry>(){

        @Override
        protected Collection<ChronicleEntry> getData(PlayerCharacter pc) {
            return pc.getDisplay().getChronicleEntries();
        }

        @Override
        public Double count(PlayerCharacter pc, Object[] params) throws ParseException {
            Object[] objectArray;
            if (params.length > 0) {
                objectArray = params;
            } else {
                String[] stringArray = new String[1];
                objectArray = stringArray;
                stringArray[0] = "EXPORT=YES";
            }
            Object[] par = objectArray;
            return super.count(pc, par);
        }

        @Override
        protected Set<ChronicleEntry> filterSetP(String c, Collection<ChronicleEntry> coll) throws ParseException {
            String[] keyValue = c.split("=");
            if (!"EXPORT".equalsIgnoreCase(keyValue[0])) {
                throw new ParseException("Bad parameter to count(\"CAMPAIGNHISTORY\" ... )" + c);
            }
            if (!"NO".equalsIgnoreCase(keyValue[1]) && !"YES".equalsIgnoreCase(keyValue[1])) {
                throw new ParseException("Bad EXPORT value to count(\"CAMPAIGNHISTORY\" ... )" + c);
            }
            boolean wantExport = "YES".equalsIgnoreCase(keyValue[1]);
            HashSet<ChronicleEntry> cs = new HashSet<ChronicleEntry>();
            for (ChronicleEntry ce : coll) {
                if (ce.isOutputEntry() != wantExport) continue;
                cs.add(ce);
            }
            return cs;
        }
    };
    public static final JepCountType CLASSES = new JepCountCDOMObject<PCClass>(){

        @Override
        protected Collection<PCClass> getData(PlayerCharacter pc) {
            return pc.getDisplay().getClassSet();
        }
    };
    public static final JepCountType DOMAINS = new JepCountCDOMObject<Domain>(){

        @Override
        protected Collection<Domain> getData(PlayerCharacter pc) {
            return pc.getDisplay().getDomainSet();
        }
    };
    public static final JepCountType EQUIPMENT = new JepCountCDOMObject<Equipment>(){

        @Override
        protected Collection<Equipment> getData(PlayerCharacter pc) {
            return pc.getEquipmentListInOutputOrder();
        }

        @Override
        protected Set<? extends Equipment> filterSetP(String c, Collection<Equipment> coll) throws ParseException {
            AbstractCountCommand.JepEquipmentCountEnum en;
            String[] keyValue = c.split("=");
            try {
                en = AbstractCountCommand.JepEquipmentCountEnum.valueOf(keyValue[0]);
            }
            catch (IllegalArgumentException ex) {
                Logging.errorPrint("Bad parameter to count(\"Equipment\"), " + c);
                return new HashSet();
            }
            HashSet<Equipment> cs = new HashSet<Equipment>(coll);
            Iterator it = cs.iterator();
            switch (en) {
                case TYPE: {
                    this.filterPObjectByType(it, keyValue[1]);
                    break;
                }
                case WIELDCATEGORY: {
                    while (it.hasNext()) {
                        Equipment e = (Equipment)it.next();
                        if (e.getWieldName().equalsIgnoreCase(keyValue[1])) continue;
                        it.remove();
                    }
                    break;
                }
                case LOCATION: {
                    if ("CARRIED".equalsIgnoreCase(keyValue[1]) || "Equipped".equalsIgnoreCase(keyValue[1])) {
                        // empty if block
                    }
                }
                case LOC: {
                    break;
                }
                case TYP: {
                    break;
                }
            }
            return cs;
        }
    };
    public static final JepCountType FOLLOWERS = new JepCountType(){

        @Override
        public Number count(PlayerCharacter pc, Object[] params) {
            return pc.getDisplay().getFollowerList().size();
        }
    };
    public static final JepCountType LANGUAGES = new JepCountCDOMObject<Language>(){

        @Override
        protected Collection<Language> getData(PlayerCharacter pc) {
            return pc.getDisplay().getLanguageSet();
        }
    };
    public static final JepCountType RACESUBTYPE = new JepCountType(){

        @Override
        public Number count(PlayerCharacter pc, Object[] params) throws ParseException {
            return pc.getDisplay().getRacialSubTypeCount();
        }
    };
    public static final JepCountType SKILLS = new JepCountCDOMObject<Skill>(){

        @Override
        protected Collection<Skill> getData(PlayerCharacter pc) {
            return pc.getDisplay().getSkillSet();
        }
    };
    public static final JepCountType SKILLSIT = new JepCountSkillSit();
    public static final JepCountType SPELLBOOKS = new JepCountType(){

        @Override
        public Number count(PlayerCharacter pc, Object[] params) {
            return pc.getDisplay().getSpellBookCount();
        }
    };

    public abstract Number count(PlayerCharacter var1, Object[] var2) throws ParseException;

    private static final void buildMap() {
        typeMap = new CaseInsensitiveMap();
        Field[] fields = JepCountType.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod)) continue;
            try {
                Object obj = fields[i].get(null);
                if (!(obj instanceof JepCountType)) continue;
                typeMap.put((Object)fields[i].getName(), (Object)((JepCountType)obj));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new UnreachableError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UnreachableError((Throwable)e);
            }
        }
    }

    public static synchronized JepCountType valueOf(String name) {
        if (typeMap == null) {
            JepCountType.buildMap();
        }
        return (JepCountType)typeMap.get((Object)name);
    }

    public static synchronized Collection<JepCountType> getAllConstants() {
        if (typeMap == null) {
            JepCountType.buildMap();
        }
        return Collections.unmodifiableCollection(typeMap.values());
    }

    private static class JepCountSkillSit
    extends JepCountType {
        private JepCountSkillSit() {
        }

        @Override
        public Number count(PlayerCharacter pc, Object[] params) throws ParseException {
            String filtername;
            SkillFilter sf = null;
            View v = View.ALL;
            if (params.length == 0) {
                return this.processCount(pc, sf, v);
            }
            if (params.length > 2) {
                Logging.errorPrint("count(\"SKILLSIT\") allows up to 2 parameters");
            }
            int nextparameter = 0;
            if ((sf = SkillFilter.getByToken(filtername = params[nextparameter++].toString())) != null) {
                if (params.length == 1) {
                    return this.processCount(pc, sf, v);
                }
                filtername = params[nextparameter++].toString();
            }
            if (filtername.startsWith("VIEW=")) {
                v = View.getViewFromName(filtername.substring(5));
                if (v == null) {
                    Logging.errorPrint("count(\"SKILLSIT\") found View it does not understand: " + filtername + " Legal values are: " + Arrays.asList(View.values()));
                }
            } else {
                Logging.errorPrint("count(\"SKILLSIT\") found parameter (Skill Filter?) it does not understand: " + filtername);
            }
            while (nextparameter != params.length) {
                Logging.errorPrint("count(\"SKILLSIT\") found parameter it did not expect (out of order?): '" + params[nextparameter++] + "'.  Parameter was ignored.");
            }
            return this.processCount(pc, sf, v);
        }

        private Number processCount(PlayerCharacter pc, SkillFilter sf, View v) {
            if (sf == null) {
                sf = this.getDefaultSkillFilter(pc);
            }
            int count = 0;
            List<Skill> skills = SkillDisplay.getSkillListInOutputOrder(pc, pc.getDisplay().getPartialSkillList(v));
            for (Skill sk : skills) {
                if (!pc.includeSkill(sk, sf) || !sk.qualifies(pc, null)) continue;
                ++count;
                for (String situation : sk.getUniqueListFor(ListKey.SITUATION)) {
                    double bonus = pc.getTotalBonusTo("SITUATION", sk.getKeyName() + "=" + situation);
                    if (!(bonus > 0.01) && !(bonus < -0.01)) continue;
                    ++count;
                }
            }
            return (double)count;
        }

        private SkillFilter getDefaultSkillFilter(PlayerCharacter pc) {
            if (pc == null) {
                return SkillFilter.getByValue(PCGenSettings.OPTIONS_CONTEXT.initInt("skillsOutputFilter", SkillFilter.Usable.getValue()));
            }
            return pc.getSkillFilter();
        }
    }

    public static interface ObjectFilter<T> {
        public boolean accept(T var1);
    }

    public static abstract class JepCountAbilities
    extends JepCountFilterable<CNAbility> {
        protected final List<String> assocList = new ArrayList<String>();

        @Override
        protected Collection<CNAbility> getData(PlayerCharacter pc) {
            this.assocList.clear();
            return pc.getCNAbilities();
        }

        @Override
        protected Collection<? extends CNAbility> filterSetP(String c, Collection<CNAbility> coll) {
            AbstractCountCommand.JepAbilityCountEnum en;
            String[] keyValue = c.split("=");
            try {
                en = AbstractCountCommand.JepAbilityCountEnum.valueOf(keyValue[0]);
            }
            catch (IllegalArgumentException ex) {
                Logging.errorPrint("Bad parameter to count(\"Ability\"), " + c);
                return new HashSet();
            }
            ObjectFilter<CNAbility> filter = null;
            switch (en) {
                case CATEGORY: 
                case CAT: {
                    filter = new CategoryFilter(keyValue[1]);
                    break;
                }
                case NAME: 
                case NAM: {
                    filter = new DisplayNameFilter(keyValue[1]);
                    break;
                }
                case KEY: {
                    filter = new KeyNameFilter(keyValue[1], this.assocList);
                    break;
                }
                case NATURE: 
                case NAT: {
                    try {
                        Nature n = Nature.valueOf(keyValue[1]);
                        if (n.equals((Object)Nature.ANY)) break;
                        filter = new NatureFilter(n);
                    }
                    catch (IllegalArgumentException ex) {
                        Logging.errorPrint("Bad parameter to count(\"Ability\"), no such NATURE " + c);
                    }
                    break;
                }
                case TYPE: 
                case TYP: {
                    filter = new TypeFilter(keyValue[1]);
                    break;
                }
                case EXCLUDETYPE: {
                    filter = new TypeExclusionFilter(keyValue[1]);
                    break;
                }
                case VISIBILITY: 
                case VIS: {
                    try {
                        Visibility vi = Visibility.valueOf(keyValue[1]);
                        filter = new VisibilityFilter(vi);
                    }
                    catch (IllegalArgumentException ex) {
                        Logging.errorPrint("Bad parameter to count(\"Ability\"), no such Visibility " + keyValue[1]);
                    }
                    break;
                }
                case ASPECT: {
                    filter = new AspectFilter(keyValue);
                }
            }
            ArrayList<CNAbility> ret = new ArrayList<CNAbility>(coll);
            if (filter != null) {
                Iterator it = ret.iterator();
                while (it.hasNext()) {
                    CNAbility cna = (CNAbility)it.next();
                    if (filter.accept(cna)) continue;
                    it.remove();
                }
            }
            return ret;
        }
    }

    public static abstract class JepCountFilterable<T>
    extends JepCountType {
        protected abstract Collection<T> getData(PlayerCharacter var1);

        protected static ParameterTree convertParams(Object[] params) {
            ParameterTree pt = null;
            for (Object param : params) {
                try {
                    if (pt == null) {
                        pt = ParameterTree.makeTree((String)param);
                        continue;
                    }
                    ParameterTree npt = ParameterTree.makeTree("[and]");
                    npt.setLeftTree(pt);
                    pt = npt;
                    ParameterTree npt1 = ParameterTree.makeTree((String)param);
                    pt.setRightTree(npt1);
                }
                catch (ParseException pe) {
                    Logging.errorPrint(MessageFormat.format("Malformed parameter to count {0}", param), pe);
                }
            }
            return pt;
        }

        protected Collection<? extends T> doFilterP(ParameterTree pt, Collection<T> coll) throws ParseException {
            String c = pt.getContents();
            if (c.equalsIgnoreCase("[or]") || c.equalsIgnoreCase("[and]")) {
                HashSet<T> a = new HashSet<T>(this.doFilterP(pt.getLeftTree(), coll));
                Collection<T> b = this.doFilterP(pt.getRightTree(), coll);
                if (c.equalsIgnoreCase("[or]")) {
                    a.addAll(b);
                } else {
                    a.retainAll(b);
                }
                return a;
            }
            return this.filterSetP(c, coll);
        }

        @Override
        public Double count(PlayerCharacter pc, Object[] params) throws ParseException {
            ParameterTree pt = JepCountFilterable.convertParams(params);
            Collection<T> data = this.getData(pc);
            Collection<T> results = pt == null ? data : this.doFilterP(pt, data);
            return this.countData(results, pc);
        }

        protected Double countData(Collection<? extends T> filtered, PlayerCharacter pc) {
            return filtered.size();
        }

        protected abstract Collection<? extends T> filterSetP(String var1, Collection<T> var2) throws ParseException;
    }

    public static abstract class JepCountCDOMObject<T extends CDOMObject>
    extends JepCountFilterable<T> {
        @Override
        public Double count(PlayerCharacter pc, Object[] params) throws ParseException {
            return super.count(pc, this.validateParams(params));
        }

        protected Object[] validateParams(Object[] params) throws ParseException {
            Object[] p = new Object[1];
            if (1 > params.length) {
                p[0] = "TYPE=ALL";
            } else {
                p = params;
            }
            return p;
        }

        @Override
        protected Set<? extends T> filterSetP(String c, Collection<T> coll) throws ParseException {
            String[] keyValue = c.split("=");
            if (!"TYPE".equalsIgnoreCase(keyValue[0])) {
                throw new ParseException("Bad parameter to count(\"CLASSES\" ... )" + c);
            }
            HashSet<T> cs = new HashSet<T>(coll);
            Iterator it = cs.iterator();
            this.filterPObjectByType(it, keyValue[1]);
            return cs;
        }

        protected void filterPObjectByType(Iterator<? extends T> it, String tString) {
            if (!"ALL".equalsIgnoreCase(tString)) {
                ArrayList typeList = new ArrayList();
                Collections.addAll(typeList, tString.split("\\."));
                block0: while (it.hasNext()) {
                    CDOMObject pObj = (CDOMObject)it.next();
                    for (String type : typeList) {
                        if (pObj.isType(type)) continue;
                        it.remove();
                        continue block0;
                    }
                }
            }
        }
    }

    private static final class CategoryFilter
    implements ObjectFilter<CNAbility> {
        private final String cat;

        private CategoryFilter(String cat) {
            this.cat = cat;
        }

        @Override
        public boolean accept(CNAbility o) {
            Category<Ability> parentCategory = o.getAbilityCategory().getParentCategory();
            return parentCategory.getKeyName().equalsIgnoreCase(this.cat);
        }
    }

    private static final class DisplayNameFilter
    implements ObjectFilter<CNAbility> {
        private final String name;

        private DisplayNameFilter(String keyValue) {
            this.name = keyValue;
        }

        @Override
        public boolean accept(CNAbility o) {
            return o.getAbility().getDisplayName().equalsIgnoreCase(this.name);
        }
    }

    private static final class KeyNameFilter
    implements ObjectFilter<CNAbility> {
        private final String name;
        private final List<String> assocList;

        private KeyNameFilter(String keyValue, List<String> list) {
            this.name = keyValue;
            this.assocList = list;
        }

        @Override
        public boolean accept(CNAbility o) {
            ArrayList<String> assocs = new ArrayList<String>();
            String undec = AbilityUtilities.getUndecoratedName(this.name, assocs);
            Ability ab = o.getAbility();
            String keyName = ab.getKeyName();
            if (keyName.equalsIgnoreCase(undec)) {
                this.assocList.addAll(assocs);
                return true;
            }
            return keyName.equalsIgnoreCase(this.name);
        }
    }

    private static final class NatureFilter
    implements ObjectFilter<CNAbility> {
        Nature nature;

        public NatureFilter(Nature n) {
            this.nature = n;
        }

        @Override
        public boolean accept(CNAbility o) {
            return o.getNature().equals((Object)this.nature);
        }
    }

    private static final class TypeExclusionFilter
    implements ObjectFilter<CNAbility> {
        String type;

        public TypeExclusionFilter(String typ) {
            this.type = typ;
        }

        @Override
        public boolean accept(CNAbility o) {
            StringTokenizer tok = new StringTokenizer(this.type, ".");
            Ability a = o.getAbility();
            while (tok.hasMoreTokens()) {
                if (!a.containsInList(ListKey.TYPE, Type.getConstant(tok.nextToken()))) continue;
                return false;
            }
            return true;
        }
    }

    private static final class TypeFilter
    implements ObjectFilter<CNAbility> {
        String type;

        public TypeFilter(String typ) {
            this.type = typ;
        }

        @Override
        public boolean accept(CNAbility o) {
            return o.getAbility().isType(this.type);
        }
    }

    private static final class VisibilityFilter
    implements ObjectFilter<CNAbility> {
        private final Visibility vi;

        private VisibilityFilter(Visibility vi) {
            this.vi = vi;
        }

        @Override
        public boolean accept(CNAbility o) {
            return o.getAbility().getSafe(ObjectKey.VISIBILITY).equals((Object)this.vi);
        }
    }

    private static final class AspectFilter
    implements ObjectFilter<CNAbility> {
        private final String[] keyValue;

        private AspectFilter(String[] keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public boolean accept(CNAbility o) {
            return o.getAbility().get(MapKey.ASPECT, AspectName.getConstant(this.keyValue[1])) != null;
        }
    }
}

